/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.test;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.TestCase;
import org.melati.poem.PoemDatabase;
import org.melati.poem.dbms.Hsqldb;

public class DatabaseUnifyWithDBTest
extends TestCase {
    public DatabaseUnifyWithDBTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testUnifyWithDB() throws Exception {
        Driver driver = null;
        String url = "jdbc:hsqldb:mem:unifiable";
        Class<?> driverClass = Class.forName("org.hsqldb.jdbcDriver");
        driver = (Driver)driverClass.newInstance();
        Properties info = new Properties();
        info.put("user", "sa");
        info.put("password", "");
        Connection c = driver.connect(url, info);
        Statement s = c.createStatement();
        Hsqldb dbms = new Hsqldb();
        StringBuffer sqb = new StringBuffer();
        sqb.append("CREATE TABLE " + dbms.getQuotedName("testable") + " (");
        sqb.append(String.valueOf(dbms.getQuotedName("id")) + " INTEGER NOT NULL PRIMARY KEY");
        sqb.append(", ");
        sqb.append(String.valueOf(dbms.getQuotedName("testname")) + " VARCHAR(233) NOT NULL");
        sqb.append(", ");
        sqb.append(String.valueOf(dbms.getQuotedName("deleted")) + " BOOLEAN");
        sqb.append(", ");
        sqb.append(String.valueOf(dbms.getQuotedName("canRead")) + " INTEGER");
        sqb.append(", ");
        sqb.append(String.valueOf(dbms.getQuotedName("canCreate")) + " INTEGER");
        sqb.append(", ");
        sqb.append(String.valueOf(dbms.getQuotedName("canDelete")) + " INTEGER");
        sqb.append(", ");
        sqb.append(String.valueOf(dbms.getQuotedName("canSelect")) + " INTEGER");
        sqb.append(")");
        try {
            s.executeUpdate(sqb.toString());
        }
        catch (SQLException e) {
            try {
                DatabaseUnifyWithDBTest.assertTrue((e.getMessage().indexOf("already exists") > 0 ? 1 : 0) != 0);
            }
            catch (Error e2) {
                throw e;
            }
        }
        try {
            s.executeUpdate("CREATE UNIQUE INDEX \"TESTABLE_ID_INDEX\" ON \"TESTABLE\" (\"ID\")");
        }
        catch (SQLException e) {
            DatabaseUnifyWithDBTest.assertTrue((e.getMessage().indexOf("already exists") > 0 ? 1 : 0) != 0);
        }
        StringBuffer sqb2 = new StringBuffer();
        sqb2.append("INSERT INTO " + dbms.getQuotedName("testable") + " (");
        sqb2.append(dbms.getQuotedName("id"));
        sqb2.append(", ");
        sqb2.append(dbms.getQuotedName("testname"));
        sqb2.append(") VALUES (");
        sqb2.append("0, 't1'");
        sqb2.append(") ");
        try {
            s.executeUpdate(sqb2.toString());
        }
        catch (SQLException e) {
            DatabaseUnifyWithDBTest.assertTrue((e.getMessage().indexOf("Violation of unique index") >= 0 ? 1 : 0) != 0);
        }
        s.close();
        c.commit();
        if (!c.isClosed()) {
            Statement st = c.createStatement();
            st.close();
        }
        c.close();
        PoemDatabase db = new PoemDatabase();
        db.connect("unifiable", "org.melati.poem.dbms.Hsqldb", url, "sa", "", 22);
        DatabaseUnifyWithDBTest.assertEquals((int)22, (int)db.getFreeTransactionsCount());
        DatabaseUnifyWithDBTest.assertTrue((db.getClass().getName() == "org.melati.poem.PoemDatabase" ? 1 : 0) != 0);
        DatabaseUnifyWithDBTest.assertEquals((String)"testable", (String)db.getTable("testable").getName());
        db.setLogSQL(false);
    }

    public void testUnifyWithDB_nonIDKey() throws Exception {
        Driver driver = null;
        String url = "jdbc:hsqldb:mem:unifiable";
        Class<?> driverClass = Class.forName("org.hsqldb.jdbcDriver");
        driver = (Driver)driverClass.newInstance();
        Properties info = new Properties();
        info.put("user", "sa");
        info.put("password", "");
        Connection c = driver.connect(url, info);
        Statement s = c.createStatement();
        Hsqldb dbms = new Hsqldb();
        StringBuffer sqb = new StringBuffer();
        sqb.append("CREATE TABLE " + dbms.getQuotedName("testable2") + " (");
        sqb.append(String.valueOf(dbms.getQuotedName("testableId")) + " INTEGER NOT NULL PRIMARY KEY");
        sqb.append(", ");
        sqb.append(String.valueOf(dbms.getQuotedName("testname")) + " VARCHAR(233) NOT NULL");
        sqb.append(", ");
        sqb.append(String.valueOf(dbms.getQuotedName("deleted")) + " BOOLEAN");
        sqb.append(", ");
        sqb.append(String.valueOf(dbms.getQuotedName("canRead")) + " INTEGER");
        sqb.append(", ");
        sqb.append(String.valueOf(dbms.getQuotedName("canCreate")) + " INTEGER");
        sqb.append(", ");
        sqb.append(String.valueOf(dbms.getQuotedName("canDelete")) + " INTEGER");
        sqb.append(", ");
        sqb.append(String.valueOf(dbms.getQuotedName("canSelect")) + " INTEGER");
        sqb.append(")");
        try {
            s.executeUpdate(sqb.toString());
        }
        catch (SQLException e) {
            DatabaseUnifyWithDBTest.assertTrue((e.getMessage().indexOf("already exists") > 0 ? 1 : 0) != 0);
        }
        try {
            s.executeUpdate("CREATE UNIQUE INDEX \"TESTABLE_ID_INDEX\" ON \"TESTABLE2\" (\"TESTABLEID\")");
        }
        catch (SQLException e) {
            DatabaseUnifyWithDBTest.assertTrue((String)e.getMessage(), (e.getMessage().indexOf("already exists") > 0 ? 1 : 0) != 0);
        }
        StringBuffer sqb2 = new StringBuffer();
        sqb2.append("INSERT INTO " + dbms.getQuotedName("testable2") + " (");
        sqb2.append(dbms.getQuotedName("testableid"));
        sqb2.append(", ");
        sqb2.append(dbms.getQuotedName("testname"));
        sqb2.append(") VALUES (");
        sqb2.append("0, 't1'");
        sqb2.append(") ");
        try {
            s.executeUpdate(sqb2.toString());
        }
        catch (SQLException e) {
            DatabaseUnifyWithDBTest.assertTrue((String)e.getMessage(), (e.getMessage().indexOf("Violation of unique index") >= 0 ? 1 : 0) != 0);
        }
        s.close();
        c.commit();
        if (!c.isClosed()) {
            Statement st = c.createStatement();
            st.close();
        }
        c.close();
        PoemDatabase db = new PoemDatabase();
        db.connect("unifiable", "org.melati.poem.dbms.Hsqldb", url, "sa", "", 22);
        DatabaseUnifyWithDBTest.assertEquals((int)22, (int)db.getFreeTransactionsCount());
        DatabaseUnifyWithDBTest.assertTrue((db.getClass().getName() == "org.melati.poem.PoemDatabase" ? 1 : 0) != 0);
        DatabaseUnifyWithDBTest.assertEquals((String)"testable2", (String)db.getTable("testable2").getName());
        db.setLogSQL(false);
    }
}

