/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import org.melati.poem.AccessPoemException;
import org.melati.poem.AccessToken;
import org.melati.poem.AppBugPoemException;
import org.melati.poem.Capability;
import org.melati.poem.Column;
import org.melati.poem.CreationAccessPoemException;
import org.melati.poem.Database;
import org.melati.poem.DeletePersistentAccessPoemException;
import org.melati.poem.DeletionIntegrityPoemException;
import org.melati.poem.Field;
import org.melati.poem.IntegrityFix;
import org.melati.poem.InvalidOperationOnFloatingPersistentPoemException;
import org.melati.poem.JdbcTable;
import org.melati.poem.NoSuchColumnPoemException;
import org.melati.poem.ParsingPoemException;
import org.melati.poem.Persistent;
import org.melati.poem.PoemException;
import org.melati.poem.PoemLocale;
import org.melati.poem.PoemThread;
import org.melati.poem.PoemTransaction;
import org.melati.poem.ReadPersistentAccessPoemException;
import org.melati.poem.ReferencePoemType;
import org.melati.poem.RowDisappearedPoemException;
import org.melati.poem.SessionToken;
import org.melati.poem.StringKeyReferencePoemType;
import org.melati.poem.Table;
import org.melati.poem.Treeable;
import org.melati.poem.UnexpectedExceptionPoemException;
import org.melati.poem.ValidationPoemException;
import org.melati.poem.WritePersistentAccessPoemException;
import org.melati.poem.transaction.Transaction;
import org.melati.poem.transaction.Transactioned;
import org.melati.poem.util.FlattenedEnumeration;
import org.melati.poem.util.MappedEnumeration;

public class JdbcPersistent
extends Transactioned
implements Persistent,
Cloneable {
    private Table<?> table;
    private Integer troid;
    private AccessToken clearedToken;
    private boolean knownCanRead = false;
    private boolean knownCanWrite = false;
    private boolean knownCanDelete = false;
    private boolean dirty = false;
    private static final int NONEXISTENT = 0;
    private static final int EXISTENT = 1;
    private static final int DELETED = 2;
    private int status = 0;
    private Object[] extras = null;

    public JdbcPersistent() {
    }

    public JdbcPersistent(JdbcTable<?> table, Integer troid) {
        super(table.getDatabase());
        this.table = table;
        this.troid = troid;
    }

    public JdbcPersistent(String tableName, String troidString) {
        super(PoemThread.database());
        this.table = PoemThread.database().getTable(tableName);
        this.troid = new Integer(troidString);
    }

    final void setStatusNonexistent() {
        this.status = 0;
    }

    final void setStatusExistent() {
        this.status = 1;
    }

    @Override
    public final boolean statusNonexistent() {
        return this.status == 0;
    }

    @Override
    public final boolean statusExistent() {
        return this.status == 1;
    }

    private void assertNotFloating() {
        if (this.troid == null) {
            throw new InvalidOperationOnFloatingPersistentPoemException(this);
        }
    }

    private void assertNotDeleted() {
        if (this.status == 2) {
            throw new RowDisappearedPoemException(this);
        }
    }

    @Override
    protected void load(Transaction transaction) {
        if (this.troid == null) {
            throw new InvalidOperationOnFloatingPersistentPoemException(this);
        }
        this.table.load((PoemTransaction)transaction, this);
    }

    @Override
    protected boolean upToDate(Transaction transaction) {
        return this.valid;
    }

    @Override
    protected void writeDown(Transaction transaction) {
        if (this.status != 2) {
            this.assertNotFloating();
            this.table.writeDown((PoemTransaction)transaction, this);
        }
    }

    @Override
    protected void writeLock(Transaction transaction) {
        if (this.troid != null) {
            super.writeLock(transaction);
            this.assertNotDeleted();
            this.dirty = true;
            this.table.notifyTouched((PoemTransaction)transaction, this);
        }
    }

    @Override
    protected void readLock(Transaction transaction) {
        if (this.troid != null) {
            super.readLock(transaction);
            this.assertNotDeleted();
        }
    }

    @Override
    protected void commit(Transaction transaction) {
        this.assertNotFloating();
        super.commit(transaction);
    }

    @Override
    protected void rollback(Transaction transaction) {
        this.assertNotFloating();
        if (this.status == 2) {
            this.status = 1;
        }
        super.rollback(transaction);
    }

    @Override
    public void makePersistent() {
        this.getTable().create(this);
    }

    synchronized Object[] extras() {
        if (this.extras == null) {
            this.extras = new Object[this.table.extrasCount()];
        } else if (this.extras.length < this.table.extrasCount()) {
            Object[] newExtras = new Object[this.table.extrasCount()];
            System.arraycopy(this.extras, 0, newExtras, 0, this.extras.length);
            this.extras = newExtras;
        }
        return this.extras;
    }

    @Override
    public final Table<?> getTable() {
        return this.table;
    }

    synchronized void setTable(JdbcTable<?> table, Integer troid) {
        this.setTransactionPool(table.getDatabase());
        this.table = table;
        this.troid = troid;
    }

    @Override
    public final Database getDatabase() {
        return this.table.getDatabase();
    }

    @Override
    public final Integer troid() {
        return this.troid;
    }

    @Override
    public final Integer getTroid() throws AccessPoemException {
        this.assertCanRead();
        return this.troid();
    }

    protected void existenceLock(SessionToken sessionToken) {
        super.readLock(sessionToken.transaction);
    }

    protected void readLock(SessionToken sessionToken) throws AccessPoemException {
        this.assertCanRead(sessionToken.accessToken);
        this.readLock(sessionToken.transaction);
    }

    protected void writeLock(SessionToken sessionToken) throws AccessPoemException {
        if (this.troid != null) {
            this.assertCanWrite(sessionToken.accessToken);
        }
        this.writeLock(sessionToken.transaction);
    }

    protected void deleteLock(SessionToken sessionToken) throws AccessPoemException {
        if (this.troid != null) {
            this.assertCanDelete(sessionToken.accessToken);
        }
        this.writeLock(sessionToken.transaction);
    }

    @Override
    public void existenceLock() {
        this.existenceLock(PoemThread.sessionToken());
    }

    protected void readLock() throws AccessPoemException {
        this.readLock(PoemThread.sessionToken());
    }

    protected void writeLock() throws AccessPoemException {
        this.writeLock(PoemThread.sessionToken());
    }

    protected Capability getCanRead() {
        return null;
    }

    @Override
    public void assertCanRead(AccessToken token) throws AccessPoemException {
        if (!(this.clearedToken == token && this.knownCanRead || this.troid == null)) {
            Capability canRead = this.getCanRead();
            if (canRead == null) {
                canRead = this.getTable().getDefaultCanRead();
            }
            if (canRead != null) {
                if (!token.givesCapability(canRead)) {
                    throw new ReadPersistentAccessPoemException(this, token, canRead);
                }
                if (this.clearedToken != token) {
                    this.knownCanWrite = false;
                    this.knownCanDelete = false;
                }
                this.clearedToken = token;
                this.knownCanRead = true;
            }
        }
    }

    @Override
    public final void assertCanRead() throws AccessPoemException {
        this.assertCanRead(PoemThread.accessToken());
    }

    @Override
    public final boolean getReadable() {
        try {
            this.assertCanRead();
            return true;
        }
        catch (AccessPoemException e) {
            return false;
        }
    }

    protected Capability getCanWrite() {
        return null;
    }

    @Override
    public void assertCanWrite(AccessToken token) throws AccessPoemException {
        if (!(this.clearedToken == token && this.knownCanWrite || this.troid == null)) {
            Capability canWrite = this.getCanWrite();
            if (canWrite == null) {
                canWrite = this.getTable().getDefaultCanWrite();
            }
            if (canWrite != null) {
                if (!token.givesCapability(canWrite)) {
                    throw new WritePersistentAccessPoemException(this, token, canWrite);
                }
                if (this.clearedToken != token) {
                    this.knownCanRead = false;
                    this.knownCanDelete = false;
                }
                this.clearedToken = token;
                this.knownCanWrite = true;
            }
        }
    }

    @Override
    public final void assertCanWrite() throws AccessPoemException {
        this.assertCanWrite(PoemThread.accessToken());
    }

    protected Capability getCanDelete() {
        return null;
    }

    @Override
    public void assertCanDelete(AccessToken token) throws AccessPoemException {
        if (!(this.clearedToken == token && this.knownCanDelete || this.troid == null)) {
            Capability canDelete = this.getCanDelete();
            if (canDelete == null) {
                canDelete = this.getTable().getDefaultCanDelete();
            }
            if (canDelete != null) {
                if (!token.givesCapability(canDelete)) {
                    throw new DeletePersistentAccessPoemException(this, token, canDelete);
                }
                if (this.clearedToken != token) {
                    this.knownCanRead = false;
                    this.knownCanWrite = false;
                }
                this.clearedToken = token;
                this.knownCanDelete = true;
            }
        }
    }

    @Override
    public final void assertCanDelete() throws AccessPoemException {
        this.assertCanDelete(PoemThread.accessToken());
    }

    protected Capability getCanSelect() {
        return null;
    }

    @Override
    public void assertCanCreate(AccessToken token) {
        Capability canCreate = this.getTable().getCanCreate();
        if (canCreate != null && !token.givesCapability(canCreate)) {
            throw new CreationAccessPoemException(this.getTable(), token, canCreate);
        }
    }

    @Override
    public final void assertCanCreate() throws AccessPoemException {
        this.assertCanCreate(PoemThread.accessToken());
    }

    @Override
    public Object getRaw(String name) throws NoSuchColumnPoemException, AccessPoemException {
        return this.getTable().getColumn(name).getRaw(this);
    }

    @Override
    public final String getRawString(String name) throws AccessPoemException, NoSuchColumnPoemException {
        Column<?> column = this.getTable().getColumn(name);
        return column.getType().stringOfRaw(column.getRaw(this));
    }

    @Override
    public void setRaw(String name, Object raw) throws NoSuchColumnPoemException, AccessPoemException, ValidationPoemException {
        this.getTable().getColumn(name).setRaw(this, raw);
    }

    @Override
    public final void setRawString(String name, String string) throws NoSuchColumnPoemException, AccessPoemException, ParsingPoemException, ValidationPoemException {
        Column<?> column = this.getTable().getColumn(name);
        column.setRaw(this, column.getType().rawOfString(string));
    }

    @Override
    public Object getCooked(String name) throws NoSuchColumnPoemException, AccessPoemException {
        return this.getTable().getColumn(name).getCooked(this);
    }

    @Override
    public final String getCookedString(String name, PoemLocale locale, int style) throws NoSuchColumnPoemException, AccessPoemException {
        Column<?> column = this.getTable().getColumn(name);
        return column.getType().stringOfCooked(column.getCooked(this), locale, style);
    }

    @Override
    public void setCooked(String name, Object cooked) throws NoSuchColumnPoemException, ValidationPoemException, AccessPoemException {
        this.getTable().getColumn(name).setCooked(this, cooked);
    }

    @Override
    public final Field<?> getField(String name) throws NoSuchColumnPoemException, AccessPoemException {
        return this.getTable().getColumn(name).asField(this);
    }

    @Override
    public Enumeration<Field<?>> fieldsOfColumns(Enumeration<Column<?>> columns) {
        final JdbcPersistent _this = this;
        return new MappedEnumeration<Field<?>, Column<?>>(columns){

            @Override
            public Field<?> mapped(Column<?> column) {
                return column.asField(_this);
            }
        };
    }

    @Override
    public Enumeration<Field<?>> getFields() {
        return this.fieldsOfColumns(this.getTable().columns());
    }

    @Override
    public Enumeration<Field<?>> getRecordDisplayFields() {
        return this.fieldsOfColumns(this.getTable().getRecordDisplayColumns());
    }

    @Override
    public Enumeration<Field<?>> getDetailDisplayFields() {
        return this.fieldsOfColumns(this.getTable().getDetailDisplayColumns());
    }

    @Override
    public Enumeration<Field<?>> getSummaryDisplayFields() {
        return this.fieldsOfColumns(this.getTable().getSummaryDisplayColumns());
    }

    @Override
    public Enumeration<Field<?>> getSearchCriterionFields() {
        return this.fieldsOfColumns(this.getTable().getSearchCriterionColumns());
    }

    @Override
    public Field<?> getPrimaryDisplayField() {
        return this.getTable().displayColumn().asField(this);
    }

    @Override
    public void delete(Map<Column<?>, IntegrityFix> columnToIntegrityFix) {
        this.assertNotFloating();
        this.deleteLock(PoemThread.sessionToken());
        Enumeration<Column<?>> columns = this.getDatabase().referencesTo(this.getTable());
        Vector<Enumeration<Persistent>> refEnumerations = new Vector<Enumeration<Persistent>>();
        while (columns.hasMoreElements()) {
            IntegrityFix fix;
            Column<?> column = columns.nextElement();
            try {
                fix = columnToIntegrityFix == null ? null : columnToIntegrityFix.get(column);
            }
            catch (ClassCastException e) {
                throw new AppBugPoemException("columnToIntegrityFix argument to Persistent.deleteAndCommit is meant to be a Map from Column to IntegrityFix", e);
            }
            if (fix == null) {
                fix = column.getIntegrityFix();
            }
            if (column.getType() instanceof ReferencePoemType) {
                refEnumerations.addElement(fix.referencesTo(this, column, column.selectionWhereEq(this.troid()), columnToIntegrityFix));
                continue;
            }
            if (column.getType() instanceof StringKeyReferencePoemType) {
                this.getDatabase().log("Found a StringKeyReferencePoemType " + this.getName());
                String keyName = ((StringKeyReferencePoemType)column.getType()).targetKeyName();
                String keyValue = (String)this.getRaw(keyName);
                if (keyValue == null) continue;
                refEnumerations.addElement(fix.referencesTo(this, column, column.selectionWhereEq(keyValue), columnToIntegrityFix));
                continue;
            }
            throw new UnexpectedExceptionPoemException("Only expecting Reference or StringKeyReferences");
        }
        FlattenedEnumeration<Persistent> refs = new FlattenedEnumeration<Persistent>(refEnumerations.elements());
        if (refs.hasMoreElements()) {
            throw new DeletionIntegrityPoemException(this, refs);
        }
        this.delete_unsafe();
    }

    @Override
    public void delete_unsafe() {
        this.assertNotFloating();
        SessionToken sessionToken = PoemThread.sessionToken();
        this.deleteLock(sessionToken);
        try {
            this.status = 2;
            this.table.delete(this.troid(), sessionToken.transaction);
        }
        catch (PoemException e) {
            this.status = 1;
            throw e;
        }
    }

    @Override
    public final void delete() {
        this.delete(null);
    }

    @Override
    public void deleteAndCommit(Map<Column<?>, IntegrityFix> integrityFixOfColumn) throws AccessPoemException, DeletionIntegrityPoemException {
        this.getDatabase().beginExclusiveLock();
        try {
            try {
                this.delete(integrityFixOfColumn);
                PoemThread.commit();
            }
            catch (RuntimeException e) {
                PoemThread.rollback();
                throw e;
            }
        }
        finally {
            this.getDatabase().endExclusiveLock();
        }
    }

    @Override
    public final void deleteAndCommit() throws AccessPoemException, DeletionIntegrityPoemException {
        this.deleteAndCommit(null);
    }

    @Override
    public Persistent duplicated() throws AccessPoemException {
        this.assertNotFloating();
        this.assertNotDeleted();
        return (JdbcPersistent)this.clone();
    }

    @Override
    public Persistent duplicatedFloating() throws AccessPoemException {
        return (JdbcPersistent)this.clone();
    }

    public String toString() {
        if (this.getTable() == null) {
            return "null/" + this.troid();
        }
        return String.valueOf(this.getTable().getName()) + "/" + this.troid();
    }

    @Override
    public String displayString(PoemLocale locale, int style) throws AccessPoemException {
        Column<?> displayColumn = this.getTable().displayColumn();
        if (displayColumn.isTroidColumn() && this.troid == null) {
            return "null";
        }
        return displayColumn.getType().stringOfCooked(displayColumn.getCooked(this), locale, style);
    }

    @Override
    public String displayString(PoemLocale locale) throws AccessPoemException {
        return this.displayString(locale, 2);
    }

    @Override
    public String displayString() throws AccessPoemException {
        return this.displayString(PoemLocale.HERE, 2);
    }

    public final int hashCode() {
        if (this.troid == null) {
            throw new InvalidOperationOnFloatingPersistentPoemException(this);
        }
        return this.getTable().hashCode() + this.troid();
    }

    public final boolean equals(Object object) {
        if (object == null || !(object instanceof Persistent)) {
            return false;
        }
        JdbcPersistent other = (JdbcPersistent)object;
        return other.troid() == this.troid() && other.getTable() == this.getTable();
    }

    @Override
    public synchronized void invalidate() {
        this.assertNotFloating();
        super.invalidate();
        this.extras = null;
    }

    protected Object clone() {
        JdbcPersistent it;
        this.assertCanRead();
        try {
            it = (JdbcPersistent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new UnexpectedExceptionPoemException(e, "Object no longer supports clone.");
        }
        it.extras = (Object[])this.extras().clone();
        it.reset();
        it.troid = null;
        it.status = 0;
        return it;
    }

    @Override
    public String dump() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.dump(ps);
        return baos.toString();
    }

    @Override
    public void dump(PrintStream p) {
        p.println(String.valueOf(this.getTable().getName()) + "/" + this.troid());
        Enumeration<Field<?>> f = this.getRecordDisplayFields();
        while (f.hasMoreElements()) {
            p.print("  ");
            f.nextElement().dump(p);
            p.println();
        }
    }

    @Override
    public void postWrite() {
    }

    @Override
    public void postInsert() {
    }

    @Override
    public void postModify() {
    }

    @Override
    public void preEdit() {
    }

    @Override
    public void postEdit(boolean creating) {
    }

    protected String countMatchSQL(boolean includeDeleted, boolean excludeUnselectable) {
        return this.getTable().countSQL(this.fromClause(), this.getTable().whereClause(this), includeDeleted, excludeUnselectable);
    }

    protected String fromClause() {
        return this.getTable().quotedName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Treeable[] getChildren() {
        Object[] kids;
        Enumeration refs = this.getDatabase().referencesTo(this);
        Vector<Persistent> v = new Vector<Persistent>();
        while (refs.hasMoreElements()) {
            v.addElement((Persistent)refs.nextElement());
        }
        Vector<Persistent> vector = v;
        synchronized (vector) {
            kids = new Treeable[v.size()];
            v.copyInto(kids);
        }
        return kids;
    }

    @Override
    public String getName() {
        return this.displayString();
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }
}

