/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.sql.ResultSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.melati.poem.Capability;
import org.melati.poem.Column;
import org.melati.poem.Database;
import org.melati.poem.FieldSet;
import org.melati.poem.Persistent;
import org.melati.poem.Table;
import org.melati.poem.TailoredResultSetEnumeration;

public class TailoredQuery {
    protected Database database;
    protected String sql;
    int selectedColumnsCount;
    Column<?>[] columns;
    boolean[] isCanReadColumn;
    Table<?>[] tables;
    Table<?>[] tablesWithoutCanReadColumn;
    Hashtable<String, Integer> table_columnMap = new Hashtable();

    public TailoredQuery(Column<?>[] selectedColumns, Table<?>[] otherTables, String whereClause, String orderByClause) {
        this(null, selectedColumns, otherTables, whereClause, orderByClause);
    }

    public TailoredQuery(String modifier, Column<?>[] selectedColumns, Table<?>[] otherTables, String whereClause, String orderByClause) {
        Column column;
        this.database = selectedColumns[0].getDatabase();
        Vector tablesV = new Vector();
        int c = 0;
        while (c < selectedColumns.length) {
            Table<Persistent> table = selectedColumns[c].getTable();
            if (!tablesV.contains(table)) {
                tablesV.addElement(table);
            }
            ++c;
        }
        int t = 0;
        while (t < otherTables.length) {
            if (!tablesV.contains(otherTables[t])) {
                tablesV.addElement(otherTables[t]);
            }
            ++t;
        }
        this.tables = new Table[tablesV.size()];
        tablesV.copyInto(this.tables);
        Vector columnsV = new Vector();
        Vector<Integer> canReadColumnIndices = new Vector<Integer>();
        Vector tablesWithoutCanReadColumnV = new Vector();
        this.selectedColumnsCount = selectedColumns.length;
        int c2 = 0;
        while (c2 < selectedColumns.length) {
            columnsV.addElement(selectedColumns[c2]);
            ++c2;
        }
        int t2 = 0;
        while (t2 < this.tables.length) {
            Table<?> table = this.tables[t2];
            Column<Capability> canRead = table.canReadColumn();
            if (canRead == null) {
                if (!tablesWithoutCanReadColumnV.contains(table)) {
                    tablesWithoutCanReadColumnV.addElement(table);
                }
            } else if (!columnsV.contains(canRead)) {
                canReadColumnIndices.addElement(new Integer(columnsV.size()));
                columnsV.addElement(canRead);
            } else {
                canReadColumnIndices.addElement(new Integer(columnsV.indexOf(canRead)));
            }
            ++t2;
        }
        this.columns = new Column[columnsV.size()];
        columnsV.copyInto(this.columns);
        this.isCanReadColumn = new boolean[columnsV.size()];
        int i = 0;
        while (i < canReadColumnIndices.size()) {
            int c3 = (Integer)canReadColumnIndices.elementAt(i);
            this.isCanReadColumn[c3] = true;
            ++i;
        }
        this.tablesWithoutCanReadColumn = new Table[tablesWithoutCanReadColumnV.size()];
        tablesWithoutCanReadColumnV.copyInto(this.tablesWithoutCanReadColumn);
        StringBuffer sqlLocal = new StringBuffer();
        sqlLocal.append("SELECT ");
        if (modifier != null) {
            sqlLocal.append(modifier);
            sqlLocal.append(' ');
        }
        int c4 = 0;
        while (c4 < columnsV.size()) {
            if (c4 > 0) {
                sqlLocal.append(", ");
            }
            column = (Column)columnsV.elementAt(c4);
            sqlLocal.append(column.getTable().quotedName());
            sqlLocal.append('.');
            sqlLocal.append(column.quotedName());
            ++c4;
        }
        sqlLocal.append(" FROM ");
        int t3 = 0;
        while (t3 < this.tables.length) {
            if (t3 > 0) {
                sqlLocal.append(", ");
            }
            sqlLocal.append(this.tables[t3].quotedName());
            ++t3;
        }
        if (whereClause != null && !whereClause.trim().equals("")) {
            sqlLocal.append(" WHERE ");
            sqlLocal.append(whereClause);
        }
        if (orderByClause != null && !orderByClause.trim().equals("")) {
            sqlLocal.append(" ORDER BY ");
            sqlLocal.append(orderByClause);
        }
        this.sql = sqlLocal.toString();
        c4 = 0;
        while (c4 < columnsV.size()) {
            column = (Column)columnsV.elementAt(c4);
            this.table_columnMap.put(String.valueOf(column.getTable().getName()) + "_" + column.getName(), new Integer(c4));
            ++c4;
        }
    }

    public Enumeration<FieldSet> selection() {
        return new TailoredResultSetEnumeration<FieldSet>(this, this.database.sqlQuery(this.sql));
    }

    public Enumeration<Object> selection_firstRaw() {
        return new FirstRawTailoredResultSetEnumeration<Object>(this, this.database.sqlQuery(this.sql));
    }

    public String toString() {
        return String.valueOf(super.toString()) + "(SQL=" + this.sql + ")";
    }

    public class FirstRawTailoredResultSetEnumeration<T>
    extends TailoredResultSetEnumeration<T> {
        public FirstRawTailoredResultSetEnumeration(TailoredQuery query, ResultSet resultSet) {
            super(query, resultSet);
        }

        @Override
        protected Object mapped(ResultSet them) {
            this.checkTableAccess();
            int c = 1;
            while (c < this.query.columns.length) {
                this.column(them, c);
                ++c;
            }
            return this.column(them, 0);
        }
    }
}

