/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.dbms;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.melati.poem.BinaryPoemType;
import org.melati.poem.Column;
import org.melati.poem.PoemType;
import org.melati.poem.StringPoemType;
import org.melati.poem.Table;
import org.melati.poem.dbms.AnsiStandard;
import org.melati.poem.util.StringUtils;

public class Hsqldb
extends AnsiStandard {
    public static int hsqldbTextHack = 266;
    public static int hsqldbTextSize1 = 0x100000;
    public static int hsqldbTextSize2 = 0x1000000;

    public Hsqldb() {
        this.setDriverClassName("org.hsqldb.jdbcDriver");
    }

    @Override
    public void shutdown(Connection connection) throws SQLException {
        if (!connection.isClosed()) {
            Statement st = connection.createStatement();
            try {
                try {
                    st.execute("SHUTDOWN SCRIPT");
                }
                catch (SQLException e) {
                    if (!e.getMessage().equals("Access is denied: Session is closed")) {
                        throw e;
                    }
                    st.close();
                }
            }
            finally {
                st.close();
            }
        }
    }

    @Override
    public String createTableTypeQualifierSql(Table<?> table) {
        String tableType = table == null || table.getDbmsTableType() == null ? "CACHED " : String.valueOf(table.getDbmsTableType()) + " ";
        return tableType;
    }

    @Override
    public String getStringSqlDefinition(int size) {
        if (size < 0) {
            return "LONGVARCHAR";
        }
        return "VARCHAR(" + size + ")";
    }

    @Override
    public String getLongSqlDefinition() {
        return "BIGINT";
    }

    @Override
    public String getBinarySqlDefinition(int size) throws SQLException {
        return "LONGVARBINARY";
    }

    @Override
    public <S, O> PoemType<O> canRepresent(PoemType<S> storage, PoemType<O> type) {
        if (storage instanceof StringPoemType && type instanceof StringPoemType) {
            if (!(((StringPoemType)storage).getSize() != hsqldbTextHack && ((StringPoemType)storage).getSize() != hsqldbTextSize1 && ((StringPoemType)storage).getSize() != hsqldbTextSize2 || ((StringPoemType)type).getSize() != -1 || !storage.getNullable() && type.getNullable())) {
                return type;
            }
            return storage.canRepresent(type);
        }
        if (storage instanceof BinaryPoemType && type instanceof BinaryPoemType) {
            if (!(((BinaryPoemType)storage).getSize() != 0 && ((BinaryPoemType)storage).getSize() <= ((BinaryPoemType)type).getSize() || !storage.getNullable() && type.getNullable())) {
                return type;
            }
            return storage.canRepresent(type);
        }
        return super.canRepresent(storage, type);
    }

    @Override
    public String unreservedName(String name) {
        if (name.equalsIgnoreCase("UNIQUE")) {
            name = "MELATI_" + name.toUpperCase();
        }
        if (name.equalsIgnoreCase("CONSTRAINT")) {
            name = "MELATI_" + name.toUpperCase();
        }
        return name.toUpperCase();
    }

    @Override
    public String melatiName(String name) {
        if (name == null) {
            return name;
        }
        if (name.equalsIgnoreCase("MELATI_UNIQUE")) {
            name = "UNIQUE";
        }
        if (name.equalsIgnoreCase("MELATI_CONSTRAINT")) {
            name = "CONSTRAINT";
        }
        return name.toLowerCase();
    }

    @Override
    public String caseInsensitiveRegExpSQL(String term1, String term2) {
        if (StringUtils.isQuoted(term2)) {
            term2 = term2.substring(1, term2.length() - 1);
        }
        term2 = StringUtils.quoted(StringUtils.quoted(term2, '%'), '\'');
        return String.valueOf(term1) + " LIKE " + term2;
    }

    @Override
    public String getForeignKeyDefinition(String tableName, String fieldName, String targetTableName, String targetTableFieldName, String fixName) {
        StringBuffer sb = new StringBuffer();
        sb.append(" ADD FOREIGN KEY (" + this.getQuotedName(fieldName) + ") REFERENCES " + this.getQuotedName(targetTableName) + "(" + this.getQuotedName(targetTableFieldName) + ")");
        if (fixName.equals("delete")) {
            sb.append(" ON DELETE CASCADE");
        }
        if (fixName.equals("clear")) {
            sb.append(" ON DELETE SET NULL");
        }
        return sb.toString();
    }

    @Override
    public String getJdbcMetadataName(String name) {
        return name.toUpperCase();
    }

    @Override
    public String alterColumnAddCommentSQL(Column<?> column, String comment) {
        return null;
    }
}

