/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.transaction;

import java.util.Vector;
import org.melati.poem.UnexpectedExceptionPoemException;
import org.melati.poem.transaction.TransactionIndexTooLargeException;
import org.melati.poem.transaction.TransactionPool;
import org.melati.poem.transaction.Transactioned;
import org.melati.poem.transaction.WouldDeadlockException;

public abstract class Transaction {
    public final int index;
    public final int mask;
    public final int negMask;
    private Transaction blockedOn = null;
    private Vector<Transaction> blockees = new Vector();
    private int blockedOnMask;
    private int seenCapacityMin = 50;
    private int seenCapacityMax = 1000;
    private Vector<Transactioned> seen = new Vector(this.seenCapacityMin);
    private int touchedCapacityMin = 50;
    private int touchedCapacityMax = 1000;
    private Vector<Transactioned> touched = new Vector();
    private TransactionPool transactionPool;

    public Transaction(TransactionPool transactionPoolP, int indexP) {
        this.transactionPool = transactionPoolP;
        if (indexP > this.transactionPool.transactionsMax()) {
            throw new TransactionIndexTooLargeException();
        }
        this.index = indexP;
        this.mask = 1 << this.index;
        this.negMask = ~this.mask;
    }

    protected abstract void backingCommit();

    protected abstract void backingRollback();

    synchronized void block(Transaction blockee) {
        this.blockees.addElement(blockee);
        blockee.blockedOn = this;
        blockee.propagateBlockage();
        try {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new UnexpectedExceptionPoemException(e);
            }
        }
        finally {
            this.blockees.removeElement(blockee);
            blockee.blockedOn = null;
            blockee.propagateBlockage();
        }
    }

    private synchronized void propagateBlockage() {
        if (this.blockedOn == null) {
            this.blockedOnMask = this.mask;
        } else {
            if ((this.blockedOn.blockedOnMask & this.mask) != 0) {
                throw new WouldDeadlockException();
            }
            this.blockedOnMask = this.blockedOn.blockedOnMask | this.mask;
        }
        int i = this.blockees.size() - 1;
        while (i >= 0) {
            this.blockees.elementAt(i).propagateBlockage();
            --i;
        }
    }

    final void notifyTouched(Transactioned persistent) {
        this.touched.addElement(persistent);
    }

    final void notifySeen(Transactioned persistent) {
        this.seen.addElement(persistent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDown() {
        Vector<Transactioned> vector = this.touched;
        synchronized (vector) {
            for (Transactioned persistent : this.touched) {
                persistent.writeDown(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unSee() {
        Vector<Transactioned> vector = this.seen;
        synchronized (vector) {
            for (Transactioned persistent : this.seen) {
                persistent.unSee(this);
            }
            if (this.seen.size() > this.seenCapacityMax) {
                this.seen = new Vector(this.seenCapacityMin);
            } else {
                this.seen.setSize(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(boolean commit) {
        try {
            if (commit) {
                this.writeDown();
                this.backingCommit();
            } else {
                this.backingRollback();
            }
            for (Transactioned persistent : this.touched) {
                if (commit) {
                    persistent.commit(this);
                    continue;
                }
                persistent.rollback(this);
            }
        }
        catch (Throwable throwable) {
            if (this.touched.size() > this.touchedCapacityMax) {
                this.touched = new Vector(this.touchedCapacityMin);
            } else {
                this.touched.setSize(0);
            }
            this.unSee();
            Transaction transaction = this;
            synchronized (transaction) {
                this.notifyAll();
            }
            throw throwable;
        }
        if (this.touched.size() > this.touchedCapacityMax) {
            this.touched = new Vector(this.touchedCapacityMin);
        } else {
            this.touched.setSize(0);
        }
        this.unSee();
        Transaction transaction = this;
        synchronized (transaction) {
            this.notifyAll();
        }
    }

    public void commit() {
        try {
            this.finish(true);
        }
        catch (RuntimeException e) {
            try {
                System.err.println("Rolling back due to " + e);
                this.finish(false);
            }
            catch (Exception ignore) {
                Object var2_3 = null;
            }
            throw e;
        }
    }

    public void rollback() {
        this.finish(false);
    }

    public Transaction getBlockedOn() {
        return this.blockedOn;
    }

    public String toString() {
        return "transaction" + this.index;
    }
}

