/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.melati.poem.util.SkipEnumeration;

public class LimitedEnumeration<T>
implements SkipEnumeration<T> {
    private Enumeration<T> base;
    private int limit;
    private int seen = 0;

    public LimitedEnumeration(Enumeration<T> base, int limit) {
        this.base = base;
        this.limit = limit;
    }

    @Override
    public synchronized boolean hasMoreElements() {
        return this.seen < this.limit && this.base.hasMoreElements();
    }

    @Override
    public synchronized T nextElement() throws NoSuchElementException {
        if (this.seen >= this.limit) {
            throw new NoSuchElementException();
        }
        T it = this.base.nextElement();
        ++this.seen;
        return it;
    }

    @Override
    public synchronized void skip() throws NoSuchElementException {
        if (this.seen >= this.limit) {
            throw new NoSuchElementException();
        }
        if (this.base instanceof SkipEnumeration) {
            ((SkipEnumeration)this.base).skip();
        } else {
            this.base.nextElement();
        }
        ++this.seen;
    }
}

