/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.util;

import java.util.Enumeration;
import java.util.Vector;
import org.melati.poem.util.ArrayUtils;
import org.melati.poem.util.EnumUtils;
import org.melati.poem.util.Order;

public final class SortUtils {
    private SortUtils() {
    }

    public static void swap(Object[] arr, int i, int j) {
        Object t = arr[i];
        arr[i] = arr[j];
        arr[j] = t;
    }

    public static void insertionSort(Order cmp, Object[] arr) {
        int i = 1;
        while (i < arr.length) {
            Object val_i = arr[i];
            if (!cmp.lessOrEqual(arr[i - 1], val_i)) {
                int j = i - 1;
                arr[i] = arr[j];
                while (j >= 1 && !cmp.lessOrEqual(arr[j - 1], val_i)) {
                    arr[j] = arr[j - 1];
                    --j;
                }
                arr[j] = val_i;
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void partlyQSort(Order cmp, Object[] arr, int lo, int hi) {
        block9: {
            if (hi - lo < 6) break block9;
            mid = lo + hi >> 1;
            if (cmp.lessOrEqual(arr[mid], arr[lo])) {
                SortUtils.swap(arr, mid, lo);
            }
            if (cmp.lessOrEqual(arr[hi], arr[mid])) {
                SortUtils.swap(arr, mid, hi);
                if (cmp.lessOrEqual(arr[mid], arr[lo])) {
                    SortUtils.swap(arr, mid, lo);
                }
            }
            pivot = arr[mid];
            i = lo + 1;
            j = hi - 1;
            ** GOTO lbl23
            {
                ++i;
                do {
                    if (!cmp.lessOrEqual(pivot, arr[i])) continue block0;
                    while (!cmp.lessOrEqual(arr[j], pivot)) {
                        --j;
                    }
                    if (i < j) {
                        SortUtils.swap(arr, i, j);
                    }
                    ++i;
                    --j;
lbl23:
                    // 2 sources

                } while (i < j);
            }
            if (j - lo <= hi - i) {
                SortUtils.partlyQSort(cmp, arr, lo, j);
                SortUtils.partlyQSort(cmp, arr, i, hi);
            } else {
                SortUtils.partlyQSort(cmp, arr, i, hi);
                SortUtils.partlyQSort(cmp, arr, lo, j);
            }
        }
    }

    public static void qsort(Order cmp, Object[] arr) {
        SortUtils.partlyQSort(cmp, arr, 0, arr.length - 1);
        SortUtils.insertionSort(cmp, arr);
    }

    public static Object[] sorted(Order cmp, Object[] arr) {
        Object[] arr2 = (Object[])arr.clone();
        SortUtils.qsort(cmp, arr2);
        return arr2;
    }

    public static <O> O[] sorted(Order cmp, Vector<O> v) {
        Object[] arr = ArrayUtils.arrayOf(v);
        SortUtils.qsort(cmp, arr);
        return arr;
    }

    public static <O> O[] sorted(Order cmp, Enumeration<O> e) {
        return SortUtils.sorted(cmp, EnumUtils.vectorOf(e));
    }
}

