/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.test;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import org.melati.poem.AccessToken;
import org.melati.poem.Column;
import org.melati.poem.ExecutingSQLPoemException;
import org.melati.poem.Persistent;
import org.melati.poem.Table;
import org.melati.poem.User;
import org.melati.poem.UserTable;
import org.melati.poem.dbms.Dbms;
import org.melati.poem.test.PoemTestCase;

public class PoemDatabaseTest
extends PoemTestCase {
    public PoemDatabaseTest(String arg0) {
        super(arg0);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.getDb().setLogCommits(false);
        this.getDb().setLogSQL(false);
    }

    public void testGetUserTable() {
        UserTable ut1 = this.getDb().getUserTable();
        UserTable ut2 = (UserTable)this.getDb().getTable("user");
        PoemDatabaseTest.assertEquals((Object)ut1, (Object)ut2);
    }

    public void testTransactionsMax() {
        PoemDatabaseTest.assertEquals((int)this.maxTrans, (int)this.getDb().transactionsMax());
    }

    public void testGetDisplayTables() {
        String expected = "user (from the data structure definition)group (from the data structure definition)capability (from the data structure definition)groupMembership (from the data structure definition)groupCapability (from the data structure definition)tableInfo (from the data structure definition)columnInfo (from the data structure definition)tableCategory (from the data structure definition)setting (from the data structure definition)";
        String outcome = "";
        for (Table t : this.getDb().getDisplayTables()) {
            outcome = outcome + t.toString();
        }
        if (this.getDb().getDbms().canDropColumns()) {
            PoemDatabaseTest.assertEquals((String)"user (from the data structure definition)group (from the data structure definition)capability (from the data structure definition)groupMembership (from the data structure definition)groupCapability (from the data structure definition)tableInfo (from the data structure definition)columnInfo (from the data structure definition)tableCategory (from the data structure definition)setting (from the data structure definition)", (String)outcome);
        }
    }

    public void testSqlQuery() {
        String query = "select * from " + this.getDb().getUserTable().quotedName();
        this.getDb().setLogSQL(true);
        ResultSet rs = this.getDb().sqlQuery(query);
        this.getDb().setLogSQL(false);
        int count = 0;
        try {
            while (rs.next()) {
                ++count;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            PoemDatabaseTest.fail();
        }
        PoemDatabaseTest.assertEquals((int)2, (int)count);
    }

    public void testSqlQueryThrows() {
        String query = "select * from nonexistanttable";
        try {
            this.getDb().sqlQuery(query);
            PoemDatabaseTest.fail((String)"Should have blown up");
        }
        catch (ExecutingSQLPoemException e) {
            Object var2_3 = null;
        }
    }

    public void testHasCapability() {
        PoemDatabaseTest.assertTrue((boolean)this.getDb().hasCapability(this.getDb().getUserTable().administratorUser(), this.getDb().getCanAdminister()));
        PoemDatabaseTest.assertTrue((boolean)this.getDb().hasCapability(this.getDb().getUserTable().guestUser(), null));
        this.getDb().setCanAdminister();
        PoemDatabaseTest.assertFalse((boolean)this.getDb().hasCapability(this.getDb().getUserTable().guestUser(), this.getDb().getCanAdminister()));
        User u = (User)this.getDb().getUserTable().newPersistent();
        u.setName("test");
        u.setLogin("test");
        u.setPassword("test");
        u.makePersistent();
        PoemDatabaseTest.assertFalse((boolean)this.getDb().hasCapability(u, this.getDb().getCanAdminister()));
        u.delete();
    }

    public void testAdministerCapability() {
    }

    public void testGetCanAdminister() {
    }

    public final void testGuestUser() {
        User u = this.getDb().getUserTable().guestUser();
        PoemDatabaseTest.assertEquals((String)u.getLogin(), (String)"_guest_");
    }

    public final void testAdministratorUser() {
        User u = this.getDb().getUserTable().administratorUser();
        PoemDatabaseTest.assertEquals((String)u.getPassword(), (String)"FIXME");
    }

    public void testReferencesToTable() {
        String expected = "groupMembership.user: reference to user (INT (org.melati.poem.ReferencePoemType)) (from the data structure definition)";
        String outcome = "";
        Enumeration en = this.getDb().referencesTo((Table)this.getDb().getUserTable());
        while (en.hasMoreElements()) {
            outcome = outcome + (Column)en.nextElement();
        }
        PoemDatabaseTest.assertEquals((String)expected, (String)outcome);
    }

    public void testGetDbms() {
        Dbms dbms = this.getDb().getDbms();
        System.err.println(dbms);
    }

    public void testToString() {
        String name = this.getDb().toString();
        PoemDatabaseTest.assertTrue((boolean)name.endsWith(this.getDatabaseName()));
    }

    public void testLogSQL() {
        PoemDatabaseTest.assertFalse((boolean)this.getDb().logSQL());
    }

    public void testSetLogSQL() {
        PoemDatabaseTest.assertFalse((boolean)this.getDb().logSQL());
        this.getDb().setLogSQL(true);
        PoemDatabaseTest.assertTrue((boolean)this.getDb().logSQL());
        this.getDb().setLogSQL(false);
        PoemDatabaseTest.assertFalse((boolean)this.getDb().logSQL());
    }

    public void testConnect() {
    }

    public void testDisconnect() {
    }

    public void testShutdown() {
    }

    public void testTables() {
    }

    public void testColumns() {
    }

    public void testAddConstraints() {
    }

    public void testSetTransactionsMax() {
        int current = 0;
        current = this.getDb().transactionsMax();
        PoemDatabaseTest.assertEquals((int)this.maxTrans, (int)current);
        this.getDb().setTransactionsMax(12);
        PoemDatabaseTest.assertTrue((this.getDb().transactionsMax() == 12 ? 1 : 0) != 0);
        this.getDb().setTransactionsMax(current);
    }

    public void testGetTransactionsCount() {
        PoemDatabaseTest.assertEquals((int)this.maxTrans, (int)this.getDb().getTransactionsCount());
    }

    public void testGetFreeTransactionsCount() {
        PoemDatabaseTest.assertEquals((int)(this.maxTrans - 1), (int)this.getDb().getFreeTransactionsCount());
    }

    public void testPoemTransaction() {
        PoemDatabaseTest.assertEquals((String)(this.getDatabaseName() + "/transaction0"), (String)this.getDb().poemTransaction(0).toString());
    }

    public void testTransaction() {
        PoemDatabaseTest.assertEquals((String)(this.getDatabaseName() + "/transaction0"), (String)this.getDb().transaction(0).toString());
    }

    public void testIsFree() {
        for (int i = 0; i < this.maxTrans - 1; ++i) {
            PoemDatabaseTest.assertTrue((boolean)this.getDb().isFree(this.getDb().poemTransaction(i)));
        }
        PoemDatabaseTest.assertFalse((boolean)this.getDb().isFree(this.getDb().poemTransaction(this.maxTrans - 1)));
        try {
            System.err.println(this.getDb().isFree(this.getDb().poemTransaction(this.maxTrans)));
            PoemDatabaseTest.fail((String)"Should have bombed.");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Object var1_3 = null;
        }
    }

    public void testBeginExclusiveLock() {
    }

    public void testEndExclusiveLock() {
    }

    public void testInSession() {
    }

    public void testBeginSession() {
    }

    public void testEndSession() {
    }

    public void testGetTable() {
        PoemDatabaseTest.assertEquals((Object)this.getDb().getUserTable(), (Object)this.getDb().getTable("user"));
    }

    public void testGetTableInfoTable() {
        PoemDatabaseTest.assertEquals((Object)this.getDb().getTableInfoTable(), (Object)this.getDb().getTable("tableinfo"));
    }

    public void testGetTableCategoryTable() {
        PoemDatabaseTest.assertEquals((Object)this.getDb().getTableCategoryTable(), (Object)this.getDb().getTable("tablecategory"));
    }

    public void testGetColumnInfoTable() {
        PoemDatabaseTest.assertEquals((Object)this.getDb().getColumnInfoTable(), (Object)this.getDb().getTable("columninfo"));
    }

    public void testGetCapabilityTable() {
        PoemDatabaseTest.assertEquals((Object)this.getDb().getCapabilityTable(), (Object)this.getDb().getTable("capability"));
    }

    public void testGetGroupTable() {
        PoemDatabaseTest.assertEquals((Object)this.getDb().getGroupTable(), (Object)this.getDb().getTable("group"));
    }

    public void testGetGroupMembershipTable() {
        PoemDatabaseTest.assertEquals((Object)this.getDb().getGroupMembershipTable(), (Object)this.getDb().getTable("groupmembership"));
    }

    public void testGetGroupCapabilityTable() {
        PoemDatabaseTest.assertEquals((Object)this.getDb().getGroupCapabilityTable(), (Object)this.getDb().getTable("groupcapability"));
    }

    public void testGetSettingTable() {
        PoemDatabaseTest.assertEquals((Object)this.getDb().getSettingTable(), (Object)this.getDb().getTable("setting"));
    }

    public void testSqlUpdate() {
        try {
            this.getDb().sqlUpdate("insert");
            PoemDatabaseTest.fail((String)"should have blown up");
        }
        catch (ExecutingSQLPoemException e) {
            Object var1_2 = null;
        }
    }

    public void testSqlUpdate1() {
        try {
            this.getDb().sqlUpdate("INSERT INTO \"COLUMNINFO\" VALUES('Name','A human-readable name for the group',TRUE,-7,FALSE,60,20,1,22,2,NULL,NULL,NULL,15,1,'name',1,TRUE,0,0,0,FALSE,FALSE,TRUE,2)");
            PoemDatabaseTest.fail((String)"should have blown up");
        }
        catch (ExecutingSQLPoemException e) {
            Object var1_2 = null;
        }
    }

    public void testSqlUpdate2() {
        this.getDb().setLogSQL(true);
        this.getDb().sqlUpdate("CREATE TABLE RAWSQL (ID INT)");
        this.getDb().sqlUpdate("DROP TABLE RAWSQL");
        this.getDb().setLogSQL(false);
    }

    public void testGivesCapabilitySQL() {
        PoemDatabaseTest.assertTrue((this.getDb().givesCapabilitySQL((User)this.getDb().guestAccessToken(), this.getDb().administerCapability()).indexOf("SELECT") == 0 ? 1 : 0) != 0);
    }

    public void testGuestAccessToken() {
        AccessToken guest = this.getDb().guestAccessToken();
        User guestUser = this.getDb().getUserTable().guestUser();
        PoemDatabaseTest.assertEquals((Object)guest, (Object)guestUser);
    }

    public void testSetCanAdminister() {
        this.getDb().setCanAdminister();
        PoemDatabaseTest.assertEquals((Object)this.getDb().getCapabilityTable().get("_administer_"), (Object)this.getDb().getCanAdminister());
        this.getDb().setCanAdminister("testing");
        PoemDatabaseTest.assertEquals((Object)this.getDb().getCapabilityTable().get("testing"), (Object)this.getDb().getCanAdminister());
        this.getDb().setCanAdminister();
        this.getDb().getCapabilityTable().getNameColumn().firstWhereEq((Object)"testing").delete();
    }

    public void testTrimCache() {
        this.getDb().trimCache(12);
    }

    public void testUncacheContents() {
        this.getDb().uncache();
    }

    public void testReferencesToPersistent() {
        Enumeration en = this.getDb().referencesTo((Persistent)this.getDb().getUserTable().administratorUser());
        int count = 0;
        while (en.hasMoreElements()) {
            en.nextElement();
            ++count;
        }
        System.err.println(count);
        PoemDatabaseTest.assertTrue((count == 1 ? 1 : 0) != 0);
    }

    public void testGetReferencesToPersistent() {
        PoemDatabaseTest.assertEquals((int)1, (int)this.getDb().getReferencesTo((Persistent)this.getDb().getUserTable().administratorUser()).size());
    }

    public void testDumpCacheAnalysis() {
        this.getDb().dumpCacheAnalysis();
    }

    public void testDump() {
        this.getDb().dump();
    }

    public void testQuotedName() {
        PoemDatabaseTest.assertEquals((String)this.getDb().getDbms().getQuotedName("user"), (String)this.getDb().quotedName("user"));
    }

    public void testGetCommittedConnection() {
    }

    public void testLogCommits() {
        PoemDatabaseTest.assertFalse((boolean)this.getDb().logCommits());
    }

    public void testSetLogCommits() {
        PoemDatabaseTest.assertFalse((boolean)this.getDb().logCommits());
        this.getDb().setLogCommits(true);
        PoemDatabaseTest.assertTrue((boolean)this.getDb().logCommits());
        this.getDb().setLogCommits(false);
        PoemDatabaseTest.assertFalse((boolean)this.getDb().logCommits());
    }
}

