/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.test;

import java.text.DateFormat;
import java.util.Locale;
import junit.framework.TestCase;
import org.melati.poem.PoemLocale;

public class PoemLocaleTest
extends TestCase {
    public PoemLocaleTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testHashCode() {
        PoemLocale l1 = PoemLocale.fromLanguageTag((String)"en-gb");
        PoemLocaleTest.assertEquals((Object)PoemLocale.HERE, (Object)l1);
        PoemLocaleTest.assertEquals((int)PoemLocale.HERE.hashCode(), (int)l1.hashCode());
    }

    public void testFromLanguageTag() {
        PoemLocaleTest.assertEquals((Object)PoemLocale.HERE, (Object)PoemLocale.fromLanguageTag((String)"en-gb"));
        PoemLocaleTest.assertEquals((String)"en_AU", (String)PoemLocale.fromLanguageTag((String)"en-au").toString());
        PoemLocaleTest.assertEquals((String)"en", (String)PoemLocale.fromLanguageTag((String)"en-").toString());
        PoemLocaleTest.assertEquals((String)"en", (String)PoemLocale.fromLanguageTag((String)"en-a").toString());
        PoemLocaleTest.assertEquals((String)"en", (String)PoemLocale.fromLanguageTag((String)"en-abc").toString());
        PoemLocaleTest.assertEquals((String)"en", (String)PoemLocale.fromLanguageTag((String)"en-abc-fr").toString());
        PoemLocaleTest.assertEquals((String)"en_AU", (String)PoemLocale.fromLanguageTag((String)"en-au-fr").toString());
        PoemLocaleTest.assertNull((Object)PoemLocale.fromLanguageTag((String)""));
    }

    public void testPoemLocale() {
        try {
            new PoemLocale(null);
            PoemLocaleTest.fail((String)"Should have blown up.");
        }
        catch (NullPointerException e) {
            Object var1_2 = null;
        }
    }

    public void testLocale() {
        PoemLocaleTest.assertEquals((String)"en_GB", (String)PoemLocale.HERE.locale().toString());
    }

    public void testMonthName() {
        PoemLocaleTest.assertEquals((String)"January", (String)PoemLocale.HERE.monthName(1));
    }

    public void testShortMonthName() {
        PoemLocaleTest.assertEquals((String)"Jan", (String)PoemLocale.HERE.shortMonthName(1));
    }

    public void testDateFormat() {
        PoemLocaleTest.assertEquals((int)DateFormat.getDateInstance(3, PoemLocale.HERE.locale()).hashCode(), (int)PoemLocale.HERE.dateFormat(3).hashCode());
    }

    public void testTimestampFormat() {
    }

    public void testEqualsObject() {
        PoemLocaleTest.assertEquals((Object)PoemLocale.HERE, (Object)PoemLocale.HERE);
        PoemLocaleTest.assertEquals((Object)PoemLocale.HERE, (Object)new PoemLocale(new Locale("en", "GB")));
        PoemLocaleTest.assertTrue((boolean)PoemLocale.HERE.equals((Object)new PoemLocale(new Locale("en", "GB"))));
        PoemLocaleTest.assertFalse((boolean)PoemLocale.HERE.equals((Object)new Exception()));
    }

    public void testToString() {
        PoemLocaleTest.assertEquals((String)"en_GB", (String)PoemLocale.HERE.toString());
    }
}

