/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.sql.ResultSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.melati.poem.Capability;
import org.melati.poem.Column;
import org.melati.poem.Database;
import org.melati.poem.FieldSet;
import org.melati.poem.Persistent;
import org.melati.poem.Table;
import org.melati.poem.TailoredResultSetEnumeration;

public class TailoredQuery {
    protected Database database;
    protected String sql;
    int selectedColumnsCount;
    Column<?>[] columns;
    boolean[] isCanReadColumn;
    Table<?>[] tables;
    Table<?>[] tablesWithoutCanReadColumn;
    Hashtable<String, Integer> table_columnMap = new Hashtable();

    public TailoredQuery(Column<?>[] selectedColumns, Table<?>[] otherTables, String whereClause, String orderByClause) {
        this(null, selectedColumns, otherTables, whereClause, orderByClause);
    }

    public TailoredQuery(String modifier, Column<?>[] selectedColumns, Table<?>[] otherTables, String whereClause, String orderByClause) {
        Column column;
        int c;
        this.database = selectedColumns[0].getDatabase();
        Vector tablesV = new Vector();
        for (int c2 = 0; c2 < selectedColumns.length; ++c2) {
            Table<Persistent> table = selectedColumns[c2].getTable();
            if (tablesV.contains(table)) continue;
            tablesV.addElement(table);
        }
        for (int t = 0; t < otherTables.length; ++t) {
            if (tablesV.contains(otherTables[t])) continue;
            tablesV.addElement(otherTables[t]);
        }
        this.tables = new Table[tablesV.size()];
        tablesV.copyInto(this.tables);
        Vector columnsV = new Vector();
        Vector<Integer> canReadColumnIndices = new Vector<Integer>();
        Vector tablesWithoutCanReadColumnV = new Vector();
        this.selectedColumnsCount = selectedColumns.length;
        for (int c3 = 0; c3 < selectedColumns.length; ++c3) {
            columnsV.addElement(selectedColumns[c3]);
        }
        for (int t = 0; t < this.tables.length; ++t) {
            Table<?> table = this.tables[t];
            Column<Capability> canRead = table.canReadColumn();
            if (canRead == null) {
                if (tablesWithoutCanReadColumnV.contains(table)) continue;
                tablesWithoutCanReadColumnV.addElement(table);
                continue;
            }
            if (!columnsV.contains(canRead)) {
                canReadColumnIndices.addElement(new Integer(columnsV.size()));
                columnsV.addElement(canRead);
                continue;
            }
            canReadColumnIndices.addElement(new Integer(columnsV.indexOf(canRead)));
        }
        this.columns = new Column[columnsV.size()];
        columnsV.copyInto(this.columns);
        this.isCanReadColumn = new boolean[columnsV.size()];
        for (int i = 0; i < canReadColumnIndices.size(); ++i) {
            int c4 = (Integer)canReadColumnIndices.elementAt(i);
            this.isCanReadColumn[c4] = true;
        }
        this.tablesWithoutCanReadColumn = new Table[tablesWithoutCanReadColumnV.size()];
        tablesWithoutCanReadColumnV.copyInto(this.tablesWithoutCanReadColumn);
        StringBuffer sqlLocal = new StringBuffer();
        sqlLocal.append("SELECT ");
        if (modifier != null) {
            sqlLocal.append(modifier);
            sqlLocal.append(' ');
        }
        for (c = 0; c < columnsV.size(); ++c) {
            if (c > 0) {
                sqlLocal.append(", ");
            }
            column = (Column)columnsV.elementAt(c);
            sqlLocal.append(column.getTable().quotedName());
            sqlLocal.append('.');
            sqlLocal.append(column.quotedName());
        }
        sqlLocal.append(" FROM ");
        for (int t = 0; t < this.tables.length; ++t) {
            if (t > 0) {
                sqlLocal.append(", ");
            }
            sqlLocal.append(this.tables[t].quotedName());
        }
        if (whereClause != null && !whereClause.trim().equals("")) {
            sqlLocal.append(" WHERE ");
            sqlLocal.append(whereClause);
        }
        if (orderByClause != null && !orderByClause.trim().equals("")) {
            sqlLocal.append(" ORDER BY ");
            sqlLocal.append(orderByClause);
        }
        this.sql = sqlLocal.toString();
        for (c = 0; c < columnsV.size(); ++c) {
            column = (Column)columnsV.elementAt(c);
            this.table_columnMap.put(column.getTable().getName() + "_" + column.getName(), new Integer(c));
        }
    }

    public Enumeration<FieldSet> selection() {
        return new TailoredResultSetEnumeration<FieldSet>(this, this.database.sqlQuery(this.sql));
    }

    public Enumeration<Object> selection_firstRaw() {
        return new FirstRawTailoredResultSetEnumeration<Object>(this, this.database.sqlQuery(this.sql));
    }

    public String toString() {
        return super.toString() + "(SQL=" + this.sql + ")";
    }

    public class FirstRawTailoredResultSetEnumeration<T>
    extends TailoredResultSetEnumeration<T> {
        public FirstRawTailoredResultSetEnumeration(TailoredQuery query, ResultSet resultSet) {
            super(query, resultSet);
        }

        @Override
        protected Object mapped(ResultSet them) {
            this.checkTableAccess();
            for (int c = 1; c < this.query.columns.length; ++c) {
                this.column(them, c);
            }
            return this.column(them, 0);
        }
    }
}

