/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.util.Enumeration;
import org.melati.poem.Database;
import org.melati.poem.DefinitionSource;
import org.melati.poem.Group;
import org.melati.poem.GroupMembership;
import org.melati.poem.PoemException;
import org.melati.poem.User;
import org.melati.poem.generated.GroupMembershipTableBase;

public class GroupMembershipTable<T extends GroupMembership>
extends GroupMembershipTableBase<T> {
    public GroupMembershipTable(Database database, String name, DefinitionSource definitionSource) throws PoemException {
        super(database, name, definitionSource);
    }

    @Override
    public void postInitialise() {
        super.postInitialise();
        Database d = this.getDatabase();
        GroupMembership admin = (GroupMembership)this.newPersistent();
        admin.setUser(d.getUserTable().administratorUser());
        admin.setGroup(d.getGroupTable().administratorsGroup());
        if (!this.exists(admin)) {
            this.create(admin);
        }
    }

    public GroupMembership ensure(Group group, User user) {
        GroupMembership p = (GroupMembership)this.newPersistent();
        p.setGroup(group);
        p.setUser(user);
        Enumeration them = this.selection(p);
        if (them.hasMoreElements()) {
            return (GroupMembership)them.nextElement();
        }
        p.makePersistent();
        return p;
    }
}

