/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.util.Enumeration;
import org.melati.poem.AccessPoemException;
import org.melati.poem.ColumnInfo;
import org.melati.poem.NoSuchRowPoemException;
import org.melati.poem.Persistent;
import org.melati.poem.PersistentReferencePoemType;
import org.melati.poem.PoemException;
import org.melati.poem.PoemLocale;
import org.melati.poem.PoemType;
import org.melati.poem.SQLPoemType;
import org.melati.poem.StringKeyPoemType;
import org.melati.poem.Table;
import org.melati.poem.TableMismatchPoemException;
import org.melati.poem.TypeMismatchPoemException;
import org.melati.poem.ValidationPoemException;
import org.melati.poem.util.MappedEnumeration;
import org.melati.poem.util.StringUtils;

public class StringKeyReferencePoemType
extends StringKeyPoemType
implements PersistentReferencePoemType,
PoemType<String> {
    private Table<?> targetTable;
    private String targetKeyName;

    public StringKeyReferencePoemType(Table<?> targetTable, String targetKeyName, boolean nullable, int size) {
        super(nullable, size);
        if (targetTable == null) {
            throw new NullPointerException();
        }
        this.targetTable = targetTable;
        if (targetKeyName == null) {
            throw new NullPointerException();
        }
        this.targetKeyName = targetKeyName;
    }

    @Override
    public Table<?> targetTable() {
        return this.targetTable;
    }

    public String targetKeyName() {
        return this.targetKeyName;
    }

    @Override
    protected Enumeration<String> _possibleRaws() {
        return new MappedEnumeration(this.targetTable.selection()){

            public String mapped(Object p) {
                return (String)((Persistent)p).getRaw(StringKeyReferencePoemType.this.targetKeyName);
            }
        };
    }

    @Override
    protected void _assertValidCooked(Object cooked) throws ValidationPoemException {
        if (!(cooked instanceof Persistent)) {
            throw new TypeMismatchPoemException(cooked, this);
        }
        Persistent persistent = (Persistent)cooked;
        if (persistent.getTable() != this.targetTable) {
            throw new ValidationPoemException(this, persistent, new TableMismatchPoemException(persistent, this.targetTable));
        }
    }

    @Override
    protected Object _cookedOfRaw(Object raw) throws NoSuchRowPoemException {
        return this.targetTable.getColumn(this.targetKeyName).firstWhereEq(raw);
    }

    @Override
    protected String _rawOfCooked(Object cooked) {
        return (String)((Persistent)cooked).getField(this.targetKeyName).getRawString();
    }

    @Override
    protected String _stringOfCooked(Object cooked, PoemLocale locale, int style) throws PoemException {
        return ((Persistent)cooked).displayString(locale, style);
    }

    @Override
    protected boolean _canRepresent(SQLPoemType<?> other) {
        return other instanceof StringKeyReferencePoemType && ((StringKeyReferencePoemType)other).targetTable == this.targetTable;
    }

    @Override
    protected void _saveColumnInfo(ColumnInfo columnInfo) throws AccessPoemException {
        columnInfo.setTypefactoryCode(this.targetTable.tableInfoID());
        columnInfo.setSize(this.getSize());
    }

    @Override
    public String toString() {
        return "string key reference to " + this.targetTable.getName() + " on " + this.targetKeyName + " (" + super.toString() + ")";
    }

    @Override
    public String toDsdType() {
        return StringUtils.capitalised(this.targetTable.getName() + " StringKeyReference on " + this.targetKeyName);
    }
}

