/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.dbms;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.melati.poem.BinaryPoemType;
import org.melati.poem.DoublePoemType;
import org.melati.poem.IntegerPoemType;
import org.melati.poem.LongPoemType;
import org.melati.poem.NoSuchColumnPoemException;
import org.melati.poem.PoemType;
import org.melati.poem.SQLPoemException;
import org.melati.poem.SQLPoemType;
import org.melati.poem.SeriousPoemException;
import org.melati.poem.Table;
import org.melati.poem.dbms.AnsiStandard;
import org.melati.poem.dbms.DuplicateKeySQLPoemException;

public class Postgresql
extends AnsiStandard {
    public Postgresql() {
        this.setDriverClassName("org.postgresql.Driver");
    }

    @Override
    public boolean canDropColumns() {
        return true;
    }

    @Override
    public String preparedStatementPlaceholder(PoemType<?> type) {
        if (type instanceof IntegerPoemType) {
            return "CAST(? AS INT4)";
        }
        if (type instanceof LongPoemType) {
            return "CAST(? AS INT8)";
        }
        if (type instanceof DoublePoemType) {
            return "CAST(? AS FLOAT8)";
        }
        return "?";
    }

    @Override
    public String getStringSqlDefinition(int size) throws SQLException {
        if (size < 0) {
            return "TEXT";
        }
        return super.getStringSqlDefinition(size);
    }

    @Override
    public String getBinarySqlDefinition(int size) throws SQLException {
        return "BYTEA";
    }

    @Override
    public SQLPoemType<?> defaultPoemTypeOfColumnMetaData(ResultSet md) throws SQLException {
        return md.getString("TYPE_NAME").equals("bytea") ? new BinaryPoemType(md.getInt("NULLABLE") == 1, -1) : super.defaultPoemTypeOfColumnMetaData(md);
    }

    @Override
    public SQLPoemException exceptionForUpdate(Table<?> table, String sql, boolean insert, SQLException e) {
        String m = e.getMessage();
        if (m != null && m.indexOf("duplicate key") >= 0) {
            int u;
            int s;
            if (m.endsWith("_index\n") && (s = m.lastIndexOf(32)) >= 0 && (u = m.indexOf(95, s + 1)) >= 0) {
                String colname = m.substring(u + 1, m.length() - 7);
                try {
                    return new DuplicateKeySQLPoemException(table.getColumn(colname), sql, insert, e);
                }
                catch (NoSuchColumnPoemException f) {
                    throw new SeriousPoemException("Duplicate Key exception thrown on a non-existant column", f);
                }
            }
            return new DuplicateKeySQLPoemException(table, sql, insert, e);
        }
        return super.exceptionForUpdate(table, sql, insert, e);
    }
}

