/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.test;

import org.melati.poem.PoemTypeFactory;
import org.melati.poem.Setting;
import org.melati.poem.SettingTable;
import org.melati.poem.test.PoemTestCase;

public class SettingTableTest
extends PoemTestCase {
    public SettingTableTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testPostInitialise() {
    }

    public void testSettingTable() {
    }

    public void testGetCooked() {
        if (!this.getDb().getDbms().canDropColumns()) {
            return;
        }
        Setting stringSetting = this.getDb().getSettingTable().ensure("stringSetting", "set", "String", "A set string setting");
        stringSetting.setValue("new");
        SettingTableTest.assertEquals((Object)"new", (Object)stringSetting.getCooked());
        SettingTableTest.assertEquals((String)"new", (String)((String)this.getDb().getSettingTable().getCooked("stringSetting")));
        SettingTableTest.assertNull((Object)this.getDb().getSettingTable().getCooked("unsetSetting"));
        Setting setting2 = this.getDb().getSettingTable().ensure("nullIntegerSetting", null, "Null Integer", "A null Integer setting");
        SettingTableTest.assertNull((Object)this.getDb().getSettingTable().getCooked("nullIntegerSetting"));
        SettingTableTest.assertNull((Object)this.getDb().getSettingTable().getCooked("nullIntegerSetting"));
        Setting setting3 = this.getDb().getSettingTable().ensure("integerSettingA", 13, "Integer", "A set Integer setting");
        SettingTableTest.assertEquals((Object)new Integer(13), (Object)this.getDb().getSettingTable().getCooked("integerSettingA"));
        SettingTableTest.assertEquals((Object)new Integer(13), (Object)this.getDb().getSettingTable().getCooked("integerSettingA"));
        stringSetting.delete();
        setting2.delete();
        setting3.delete();
    }

    public void testGet() {
        if (!this.getDb().getDbms().canDropColumns()) {
            return;
        }
        Setting setting1 = this.getDb().getSettingTable().ensure("integerSettingG", 12, "Integer", "A set Integer setting");
        SettingTableTest.assertEquals((String)"12", (String)this.getDb().getSettingTable().get("integerSettingG"));
        SettingTableTest.assertNull((Object)this.getDb().getSettingTable().get("unsetSetting"));
        setting1.delete();
    }

    public void testGetOrDie() {
        if (!this.getDb().getDbms().canDropColumns()) {
            return;
        }
        Setting s = this.getDb().getSettingTable().ensure("integerSettingGOD", 12, "Integer", "A set Integer setting");
        SettingTableTest.assertEquals((String)"12", (String)((String)this.getDb().getSettingTable().getOrDie("integerSettingGOD")));
        try {
            this.getDb().getSettingTable().getOrDie("unsetSetting");
            SettingTableTest.fail((String)"Should have blown up");
        }
        catch (SettingTable.UnsetException e) {
            Object var2_3 = null;
        }
        s.delete();
    }

    public void testEnsureStringPoemTypeFactoryObjectStringString() {
        if (!this.getDb().getDbms().canDropColumns()) {
            return;
        }
        Setting stringSetting1 = this.getDb().getSettingTable().ensure("stringSetting", PoemTypeFactory.STRING, (Object)"set", "String", "A set string setting");
        Setting stringSetting2 = this.getDb().getSettingTable().ensure("stringSetting", "set", "String", "A set string setting");
        SettingTableTest.assertEquals((Object)stringSetting1, (Object)stringSetting2);
        stringSetting1.delete();
        Setting integerSetting1 = this.getDb().getSettingTable().ensure("integerSetting", PoemTypeFactory.INTEGER, (Object)new Integer(13), "Integer", "An integer setting");
        Setting integerSetting2 = this.getDb().getSettingTable().ensure("integerSetting", 13, "Integer", "An integer setting");
        SettingTableTest.assertEquals((Object)integerSetting1, (Object)integerSetting2);
        integerSetting1.delete();
        Setting booleanSetting1 = this.getDb().getSettingTable().ensure("booleanSetting", PoemTypeFactory.BOOLEAN, (Object)new Boolean(true), "Boolean", "A boolean setting");
        Setting booleanSetting2 = this.getDb().getSettingTable().ensure("booleanSetting", true, "Boolean", "A boolean setting");
        SettingTableTest.assertEquals((Object)booleanSetting1, (Object)booleanSetting2);
        booleanSetting1.delete();
    }

    public void testEnsureStringStringStringString() {
    }

    public void testEnsureStringIntStringString() {
    }

    public void testEnsureStringBooleanStringString() {
    }
}

