/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.util.test;

import java.util.Enumeration;
import java.util.Vector;
import junit.framework.TestCase;
import org.melati.poem.util.EmptyEnumeration;
import org.melati.poem.util.EnumUtils;
import org.melati.poem.util.LimitedEnumeration;

public class EnumUtilsTest
extends TestCase {
    public EnumUtilsTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSkip() {
        Vector<String> v = new Vector<String>();
        v.add("a");
        v.add("b");
        v.add("c");
        Enumeration e = v.elements();
        EnumUtils.skip(e, (int)2);
        EnumUtilsTest.assertEquals((String)"c", (String)((String)e.nextElement()));
        LimitedEnumeration se = new LimitedEnumeration(v.elements(), 2);
        EnumUtils.skip((Enumeration)se, (int)1);
        EnumUtilsTest.assertEquals((String)"b", (String)((String)se.nextElement()));
    }

    public void testInitial() {
    }

    public void testJoin() {
        Vector<String> v1 = new Vector<String>();
        v1.add("a");
        v1.add("b");
        v1.add("c");
        Enumeration e1 = v1.elements();
        Vector<String> v2 = new Vector<String>();
        v2.add("1");
        v2.add("2");
        v2.add("3");
        Enumeration e2 = v2.elements();
        Enumeration joined = EnumUtils.join(e1, e2);
        EnumUtilsTest.assertEquals((int)6, (int)EnumUtils.vectorOf((Enumeration)joined).size());
    }

    public void testVectorOfEnumerationInt() {
    }

    public void testVectorOfEnumeration() {
    }

    public void testConcatenated() {
        String result = EnumUtils.concatenated((String)",", (Enumeration)new EmptyEnumeration());
        EnumUtilsTest.assertEquals((String)"", (String)result);
    }

    public void testContains() {
        Vector<String> v = new Vector<String>();
        v.add("a");
        v.add("b");
        v.add("c");
        Enumeration e = v.elements();
        EnumUtilsTest.assertTrue((boolean)EnumUtils.contains(e, (Object)"b"));
        EnumUtilsTest.assertTrue((boolean)EnumUtils.contains(e, (Object)"c"));
        EnumUtilsTest.assertFalse((boolean)EnumUtils.contains(e, (Object)"b"));
        e = v.elements();
        EnumUtilsTest.assertFalse((boolean)EnumUtils.contains(e, (Object)"z"));
        EnumUtilsTest.assertFalse((boolean)EnumUtils.contains(e, (Object)"b"));
    }
}

