/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.test;

import java.sql.Date;
import org.melati.poem.DatePoemType;
import org.melati.poem.PoemLocale;
import org.melati.poem.PoemType;
import org.melati.poem.SQLPoemType;
import org.melati.poem.test.SQLPoemTypeSpec;

public class NotNullableDatePoemTypeTest
extends SQLPoemTypeSpec<Date> {
    public NotNullableDatePoemTypeTest() {
    }

    public NotNullableDatePoemTypeTest(String name) {
        super(name);
    }

    @Override
    void setObjectUnderTest() {
        this.it = new DatePoemType(false);
    }

    public void testFullConstructor() {
        DatePoemType it2 = new DatePoemType(91, "DATETIME", this.it.getNullable());
        NotNullableDatePoemTypeTest.assertNotNull((Object)this.it.canRepresent((PoemType)it2));
        NotNullableDatePoemTypeTest.assertNotNull((Object)it2.canRepresent((PoemType)it2));
    }

    @Override
    public void testQuotedRaw() {
        NotNullableDatePoemTypeTest.assertEquals((String)((SQLPoemType)this.it).sqlDefaultValue(this.getDb().getDbms()), (String)((SQLPoemType)this.it).quotedRaw(((SQLPoemType)this.it).rawOfString(((SQLPoemType)this.it).sqlDefaultValue(this.getDb().getDbms()))));
    }

    @Override
    public void testStringOfCooked() {
        super.testStringOfCooked();
        NotNullableDatePoemTypeTest.assertEquals((String)"01-Jan-1970", (String)this.it.stringOfCooked((Object)new Date(1L), PoemLocale.HERE, 2));
    }

    @Override
    public void testToDsdType() {
        DatePoemType t = new DatePoemType(true);
        NotNullableDatePoemTypeTest.assertTrue((boolean)t.toDsdType().equals("Date"));
    }

    @Override
    public void testRawOfString() {
        DatePoemType t = new DatePoemType(true);
        Date d1 = (Date)t.rawOfString("12122001");
        Date d2 = (Date)t.rawOfString("2001-12-12");
        NotNullableDatePoemTypeTest.assertTrue((boolean)d1.equals(d2));
        NotNullableDatePoemTypeTest.assertTrue((!d1.equals(null) ? 1 : 0) != 0);
        NotNullableDatePoemTypeTest.assertTrue((!d2.equals(null) ? 1 : 0) != 0);
        Date d3 = (Date)t.rawOfString(null);
        NotNullableDatePoemTypeTest.assertTrue((d3 == null ? 1 : 0) != 0);
        try {
            t.rawOfString("");
            NotNullableDatePoemTypeTest.fail((String)"Should throw IllegalArgumentException for empty string");
        }
        catch (IllegalArgumentException success2) {
            Object success2 = null;
        }
        try {
            t.rawOfString("1999-2-2");
            NotNullableDatePoemTypeTest.fail((String)"Should throw IllegalArgumentException for malformed date 1999-2-2");
        }
        catch (IllegalArgumentException success3) {
            Object success3 = null;
        }
    }

    public void testToString() {
        DatePoemType t = new DatePoemType(true);
        NotNullableDatePoemTypeTest.assertTrue((boolean)t.toString().equals("nullable DATE (org.melati.poem.DatePoemType)"));
        DatePoemType t2 = new DatePoemType(false);
        NotNullableDatePoemTypeTest.assertTrue((boolean)t2.toString().equals("DATE (org.melati.poem.DatePoemType)"));
    }

    public void testEquals() {
        DatePoemType t = new DatePoemType(true);
        NotNullableDatePoemTypeTest.assertTrue((boolean)((Date)t.rawOfString("2001-12-12")).equals(t.rawOfString("2001-12-12")));
        NotNullableDatePoemTypeTest.assertTrue((boolean)((Date)t.rawOfString("12122001")).equals(t.rawOfString("2001-12-12")));
        NotNullableDatePoemTypeTest.assertTrue((boolean)((Date)t.rawOfString("12122001")).equals(t.rawOfString("2001-12-12")));
        NotNullableDatePoemTypeTest.assertTrue((boolean)((Date)t.rawOfString("02022001")).equals(t.rawOfString("2001-02-02")));
        NotNullableDatePoemTypeTest.assertTrue((boolean)((Date)t.rawOfString("02022001")).equals(t.rawOfString("2001-02-02")));
    }
}

