/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.sql.Connection;
import java.sql.SQLException;
import org.melati.poem.CommitFailedPoemException;
import org.melati.poem.CommitLogEvent;
import org.melati.poem.Database;
import org.melati.poem.RollbackFailedPoemException;
import org.melati.poem.RollbackLogEvent;
import org.melati.poem.SQLSeriousPoemException;
import org.melati.poem.transaction.Transaction;

public class PoemTransaction
extends Transaction {
    private Database database;
    private Connection connection;

    public PoemTransaction(Database database, Connection connection, int index) {
        super(database, index);
        this.database = database;
        this.connection = connection;
        try {
            connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new SQLSeriousPoemException(e);
        }
    }

    public final Database getDatabase() {
        return this.database;
    }

    final Connection getConnection() {
        return this.connection;
    }

    @Override
    protected void backingCommit() {
        try {
            this.connection.commit();
            if (this.database.logCommits()) {
                this.database.log(new CommitLogEvent(this));
            }
        }
        catch (SQLException e) {
            throw new CommitFailedPoemException(e);
        }
    }

    @Override
    protected void backingRollback() {
        try {
            if (this.connection.isClosed()) {
                if (this.database.logCommits()) {
                    this.database.log("No rollback on closed connection for " + new RollbackLogEvent(this));
                }
            } else {
                this.connection.rollback();
                if (this.database.logCommits()) {
                    this.database.log(new RollbackLogEvent(this));
                }
            }
        }
        catch (SQLException e) {
            throw new RollbackFailedPoemException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean commit) {
        try {
            if (commit) {
                this.commit();
            } else {
                this.rollback();
            }
        }
        finally {
            this.database.notifyClosed(this);
        }
    }

    @Override
    public String toString() {
        return this.database.getName() + "/" + super.toString();
    }
}

