/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.melati.poem.AccessPoemException;
import org.melati.poem.AtomPoemType;
import org.melati.poem.ColumnInfo;
import org.melati.poem.ParsingPoemException;
import org.melati.poem.PoemTypeFactory;
import org.melati.poem.SQLPoemType;
import org.melati.poem.TypeMismatchPoemException;

public class DoublePoemType
extends AtomPoemType<Double> {
    public static final DoublePoemType it = new DoublePoemType(true);

    public DoublePoemType(boolean nullable) {
        super(8, "DOUBLE PRECISION", nullable);
    }

    @Override
    protected void _assertValidRaw(Object raw) {
        if (raw != null && !(raw instanceof Double)) {
            throw new TypeMismatchPoemException(raw, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Double _getRaw(ResultSet rs, int col) throws SQLException {
        ResultSet resultSet = rs;
        synchronized (resultSet) {
            double x = rs.getDouble(col);
            return rs.wasNull() ? null : new Double(x);
        }
    }

    @Override
    protected void _setRaw(PreparedStatement ps, int col, Object real) throws SQLException {
        ps.setDouble(col, (Double)real);
    }

    @Override
    protected Double _rawOfString(String rawString) throws ParsingPoemException {
        try {
            return new Double(rawString);
        }
        catch (NumberFormatException e) {
            throw new ParsingPoemException(this, rawString, e);
        }
    }

    @Override
    protected boolean _canRepresent(SQLPoemType<?> other) {
        return this.sqlTypeCode() == other.sqlTypeCode() && other instanceof DoublePoemType;
    }

    @Override
    public String toDsdType() {
        return "Double";
    }

    @Override
    protected void _saveColumnInfo(ColumnInfo columnInfo) throws AccessPoemException {
        columnInfo.setTypefactory(PoemTypeFactory.DOUBLE);
    }
}

