/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.melati.poem.AccessPoemException;
import org.melati.poem.AtomPoemType;
import org.melati.poem.ColumnInfo;
import org.melati.poem.ParsingPoemException;
import org.melati.poem.PoemLocale;
import org.melati.poem.PoemTypeFactory;
import org.melati.poem.SQLPoemType;
import org.melati.poem.TypeMismatchPoemException;
import org.melati.poem.util.StringUtils;

public class TimePoemType
extends AtomPoemType<Time> {
    public static final DateFormat format = new SimpleDateFormat("HH:mm:ss");

    public TimePoemType(boolean nullable) {
        super(92, "TIME", nullable);
    }

    public TimePoemType(int sqlTypeCode, String sqlTypeName, boolean nullable) {
        super(sqlTypeCode, sqlTypeName, nullable);
    }

    @Override
    protected void _assertValidRaw(Object raw) {
        if (raw != null && !(raw instanceof Time)) {
            throw new TypeMismatchPoemException(raw, this);
        }
    }

    @Override
    protected Time _getRaw(ResultSet rs, int col) throws SQLException {
        return rs.getTime(col);
    }

    @Override
    protected void _setRaw(PreparedStatement ps, int col, Object raw) throws SQLException {
        ps.setTime(col, (Time)raw);
    }

    @Override
    protected String _stringOfRaw(Object raw) {
        return format.format((Date)raw);
    }

    @Override
    protected Time _rawOfString(String raw) {
        try {
            return new Time(format.parse(raw).getTime());
        }
        catch (ParseException e) {
            try {
                return Time.valueOf(raw);
            }
            catch (IllegalArgumentException e2) {
                throw new ParsingPoemException(this, raw, e2);
            }
        }
    }

    @Override
    protected String _stringOfCooked(Object cooked, PoemLocale locale, int style) {
        return locale.timestampFormat(style).format((Time)cooked);
    }

    @Override
    protected boolean _canRepresent(SQLPoemType<?> other) {
        return other instanceof TimePoemType;
    }

    @Override
    public String toDsdType() {
        return "Time";
    }

    @Override
    protected void _saveColumnInfo(ColumnInfo columnInfo) throws AccessPoemException {
        columnInfo.setTypefactory(PoemTypeFactory.TIME);
    }

    @Override
    protected String _quotedRaw(Object raw) {
        return StringUtils.quoted(this._stringOfRaw(raw), '\'');
    }
}

