/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.transaction;

import org.melati.poem.PoemBugPoemException;
import org.melati.poem.transaction.CrossTransactionCommitException;
import org.melati.poem.transaction.Transaction;
import org.melati.poem.transaction.TransactionPool;
import org.melati.poem.transaction.WriteCommittedException;

public abstract class Transactioned {
    protected boolean valid = true;
    private int seenMask = 0;
    private Transaction touchedBy = null;
    private TransactionPool transactionPool = null;

    public Transactioned(TransactionPool transactionPool) {
        this.transactionPool = transactionPool;
    }

    public Transactioned() {
        this(null);
    }

    protected abstract void load(Transaction var1);

    protected abstract boolean upToDate(Transaction var1);

    protected abstract void writeDown(Transaction var1);

    protected synchronized void reset() {
        this.valid = true;
        this.seenMask = 0;
        this.touchedBy = null;
    }

    protected final TransactionPool transactionPool() {
        return this.transactionPool;
    }

    protected synchronized void setTransactionPool(TransactionPool transactionPool) {
        if (transactionPool == null) {
            throw new NullPointerException();
        }
        if (this.transactionPool != null && this.transactionPool != transactionPool) {
            throw new IllegalArgumentException();
        }
        this.transactionPool = transactionPool;
    }

    private void ensureValid(Transaction transaction) {
        if (!this.valid) {
            if (transaction == null) {
                transaction = this.touchedBy;
            }
            if (!this.upToDate(transaction)) {
                this.load(transaction);
            }
            this.valid = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readLock(Transaction transaction) {
        if (transaction != null) {
            while (true) {
                Transaction blocker;
                Transactioned transactioned = this;
                synchronized (transactioned) {
                    if (this.touchedBy == null || this.touchedBy == transaction) {
                        if ((this.seenMask & transaction.mask) == 0) {
                            this.seenMask |= transaction.mask;
                            transaction.notifySeen(this);
                        }
                        break;
                    }
                    blocker = this.touchedBy;
                }
                blocker.block(transaction);
            }
        }
        this.ensureValid(transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeLock(Transaction transaction) {
        if (transaction == null) {
            throw new WriteCommittedException(this);
        }
        while (true) {
            Transaction blocker = null;
            Transactioned transactioned = this;
            synchronized (transactioned) {
                if (this.touchedBy == transaction) {
                    break;
                }
                if (this.touchedBy != null) {
                    blocker = this.touchedBy;
                } else {
                    int othersSeenMask = this.seenMask & transaction.negMask;
                    if (othersSeenMask == 0) {
                        this.touchedBy = transaction;
                        transaction.notifyTouched(this);
                        break;
                    }
                    int m = this.transactionPool().transactionsMax();
                    int t = 0;
                    int mask = 1;
                    while (t < m && (othersSeenMask & mask) == 0) {
                        ++t;
                        mask <<= 1;
                    }
                    if (t == m) {
                        throw new PoemBugPoemException("Thought there was a blocking transaction, but didn't find it");
                    }
                    blocker = this.transactionPool().transaction(t);
                }
            }
            blocker.block(transaction);
        }
        this.ensureValid(transaction);
    }

    protected synchronized void commit(Transaction transaction) {
        if (this.touchedBy != transaction) {
            throw new CrossTransactionCommitException(this);
        }
        this.touchedBy = null;
    }

    protected synchronized void rollback(Transaction transaction) {
        if (this.touchedBy != transaction) {
            throw new CrossTransactionCommitException(this);
        }
        this.touchedBy = null;
        this.valid = false;
    }

    public synchronized void invalidate() {
        this.valid = false;
    }

    public synchronized void markValid() {
        this.valid = true;
    }

    protected synchronized void unSee(Transaction transaction) {
        this.seenMask &= transaction.negMask;
    }
}

