// Do not edit this file!  It was generated by Melati POEM's DSD preprocessor.

package org.melati.poem.generated;


import org.melati.poem.AccessPoemException;
import org.melati.poem.Column;
import org.melati.poem.Database;
import org.melati.poem.DefinitionSource;
import org.melati.poem.Field;
import org.melati.poem.JdbcPersistent;
import org.melati.poem.Persistent;
import org.melati.poem.PoemDatabaseTables;
import org.melati.poem.PoemException;
import org.melati.poem.Searchability;
import org.melati.poem.Setting;
import org.melati.poem.StringPoemType;
import org.melati.poem.TroidPoemType;
import org.melati.poem.ValidationPoemException;
import org.melati.poem.ValueInfoTable;


/**
 * Melati POEM generated base class for <code>Table</code> <code>setting</code>.
 *
 * see org.melati.poem.prepro.TableDef#generateTableBaseJava 
 */

public class SettingTableBase<T extends Setting> extends ValueInfoTable<T> {

  private Column<Integer> col_id = null;
  private Column<String> col_name = null;
  private Column<String> col_value = null;

 /**
  * Constructor. 
  * 
  * see org.melati.poem.prepro.TableDef#generateTableBaseJava 
  * @param database          the POEM database we are using
  * @param name              the name of this <code>Table</code>
  * @param definitionSource  which definition is being used
  * @throws PoemException    if anything goes wrong
  */

  public SettingTableBase(
      Database database, String name,
      DefinitionSource definitionSource) throws PoemException {
    super(database, name, definitionSource);
  }


 /**
  * Get the database tables.
  *
  * see org.melati.poem.prepro.TableDef#generateTableBaseJava 
  * @return the database tables
  */
  public PoemDatabaseTables getPoemDatabaseTables() {
    return (PoemDatabaseTables)getDatabase();
  }


 /**
  * Initialise this table by defining its columns.
  *
  * see org.melati.poem.prepro.TableDef#generateTableBaseJava 
  */
  public void init() throws PoemException {
    super.init();
    defineColumn(col_id =
        new Column<Integer>(this, "id",
                   new TroidPoemType(),
                   DefinitionSource.dsd) { 
          public Object getCooked(Persistent g)
              throws AccessPoemException, PoemException {
            return ((Setting)g).getId();
          }

          public void setCooked(Persistent g, Object cooked)
              throws AccessPoemException, ValidationPoemException {
            ((Setting)g).setId((Integer)cooked);
          }

          public Field<Integer> asField(Persistent g) {
            return ((Setting)g).getIdField();
          }

          public boolean defaultUserEditable() {
            return false;
          }

          public boolean defaultUserCreateable() {
            return false;
          }

          public int defaultDisplayOrder() {
            return 0;
          }

          public String defaultDescription() {
            return "The Table Row Object ID";
          }

          public Object getRaw_unsafe(Persistent g)
              throws AccessPoemException {
            return ((Setting)g).getId_unsafe();
          }

          public void setRaw_unsafe(Persistent g, Object raw)
              throws AccessPoemException {
            ((Setting)g).setId_unsafe((Integer)raw);
          }

          public Object getRaw(Persistent g)
              throws AccessPoemException {
            return ((Setting)g).getId();
          }

          public void setRaw(Persistent g, Object raw)
              throws AccessPoemException {
            ((Setting)g).setId((Integer)raw);
          }
        });

    defineColumn(col_name =
        new Column<String>(this, "name",
                   new StringPoemType(false, 200),
                   DefinitionSource.dsd) { 
          public Object getCooked(Persistent g)
              throws AccessPoemException, PoemException {
            return ((Setting)g).getName();
          }

          public void setCooked(Persistent g, Object cooked)
              throws AccessPoemException, ValidationPoemException {
            ((Setting)g).setName((String)cooked);
          }

          public Field<String> asField(Persistent g) {
            return ((Setting)g).getNameField();
          }

          public Searchability defaultSearchability() {
            return Searchability.primary;
          }

          public int defaultDisplayOrder() {
            return 1;
          }

          public String defaultDescription() {
            return "A code name for this setting";
          }

          public boolean defaultUnique() {
            return true;
          }

          public Object getRaw_unsafe(Persistent g)
              throws AccessPoemException {
            return ((Setting)g).getName_unsafe();
          }

          public void setRaw_unsafe(Persistent g, Object raw)
              throws AccessPoemException {
            ((Setting)g).setName_unsafe((String)raw);
          }

          public Object getRaw(Persistent g)
              throws AccessPoemException {
            return ((Setting)g).getName();
          }

          public void setRaw(Persistent g, Object raw)
              throws AccessPoemException {
            ((Setting)g).setName((String)raw);
          }
        });

    defineColumn(col_value =
        new Column<String>(this, "value",
                   new StringPoemType(true, -1),
                   DefinitionSource.dsd) { 
          public Object getCooked(Persistent g)
              throws AccessPoemException, PoemException {
            return ((Setting)g).getValue();
          }

          public void setCooked(Persistent g, Object cooked)
              throws AccessPoemException, ValidationPoemException {
            ((Setting)g).setValue((String)cooked);
          }

          public Field<String> asField(Persistent g) {
            return ((Setting)g).getValueField();
          }

          public int defaultDisplayOrder() {
            return 150;
          }

          public String defaultDescription() {
            return "The value of this setting";
          }

          public Object getRaw_unsafe(Persistent g)
              throws AccessPoemException {
            return ((Setting)g).getValue_unsafe();
          }

          public void setRaw_unsafe(Persistent g, Object raw)
              throws AccessPoemException {
            ((Setting)g).setValue_unsafe((String)raw);
          }

          public Object getRaw(Persistent g)
              throws AccessPoemException {
            return ((Setting)g).getValue();
          }

          public void setRaw(Persistent g, Object raw)
              throws AccessPoemException {
            ((Setting)g).setValue((String)raw);
          }
        });
  }


 /**
  * Retrieves the <code>Id</code> <code>Column</code> for this 
  * <code>setting</code> <code>Table</code>.
  * 
  * see org.melati.poem.prepro.FieldDef#generateColAccessor 
  * @return the id <code>Column</code>
  */
  public final Column<Integer> getIdColumn() {
    return col_id;
  }


 /**
  * Retrieves the <code>Name</code> <code>Column</code> for this 
  * <code>setting</code> <code>Table</code>.
  * 
  * see org.melati.poem.prepro.FieldDef#generateColAccessor 
  * @return the name <code>Column</code>
  */
  public final Column<String> getNameColumn() {
    return col_name;
  }


 /**
  * Retrieves the <code>Value</code> <code>Column</code> for this 
  * <code>setting</code> <code>Table</code>.
  * 
  * see org.melati.poem.prepro.FieldDef#generateColAccessor 
  * @return the value <code>Column</code>
  */
  public final Column<String> getValueColumn() {
    return col_value;
  }


 /**
  * Retrieve the <code>Setting</code> as a <code>Setting</code>.
  *
  * see org.melati.poem.prepro.TableDef#generateTableBaseJava 
  * @param troid a Table Row Object ID
  * @return the <code>Persistent</code> identified by the <code>troid</code>
  */
  public Setting getSettingObject(Integer troid) {
    return (Setting)getObject(troid);
  }


 /**
  * Retrieve the <code>Setting</code> 
  * as a <code>Setting</code>.
  *
  * see org.melati.poem.prepro.TableDef#generateTableBaseJava 
  * @param troid a Table Row Object ID
  * @return the <code>Persistent</code> identified   */
  public Setting getSettingObject(int troid) {
    return (Setting)getObject(troid);
  }

  protected JdbcPersistent _newPersistent() {
    return new Setting();
  }
  public String defaultDescription() {
    return "A configurable Setting for the application, where a Setting can be of any object type";
  }

  public boolean defaultRememberAllTroids() {
    return true;
  }

  public Integer defaultCacheLimit() {
    return new Integer(999999999);
  }

  public String defaultCategory() {
    return "System";
  }

  public int defaultDisplayOrder() {
    return 3040;
  }

  /**
   * @return a newly created or existing Setting
   **/
  public Setting ensure(String name) {
    Setting p = (Setting)getNameColumn().firstWhereEq(name);
    if (p == null) {
      p = (Setting)newPersistent();
      p.setName(name);
    }
    return (Setting)getNameColumn().ensure(p);
  }
}

