/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.test;

import java.util.Enumeration;
import org.melati.poem.AccessPoemException;
import org.melati.poem.BaseFieldAttributes;
import org.melati.poem.Field;
import org.melati.poem.FieldAttributes;
import org.melati.poem.IntegerPoemType;
import org.melati.poem.Persistent;
import org.melati.poem.PoemLocale;
import org.melati.poem.PoemType;
import org.melati.poem.ReferencePoemType;
import org.melati.poem.StringPoemType;
import org.melati.poem.Table;
import org.melati.poem.User;
import org.melati.poem.test.PoemTestCase;

public class FieldTest
extends PoemTestCase {
    Field<String> stringField = null;
    Field<Integer> integerField = null;

    public FieldTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.stringField = new Field((Object)"stringfield", (FieldAttributes)new BaseFieldAttributes("stringName", "String Display Name", "String description", (PoemType)StringPoemType.nullableInstance, 20, 1, null, false, true, true));
        this.integerField = new Field((Object)new Integer(1), (FieldAttributes)new BaseFieldAttributes("integerName", "Integer Display Name", "Integer description", (PoemType)IntegerPoemType.nullableInstance, 20, 1, null, false, true, true));
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testFieldObjectFieldAttributes() {
    }

    public void testFieldAccessPoemExceptionFieldAttributes() {
        Object e2;
        Field f = new Field(new AccessPoemException(), this.stringField);
        try {
            f.getRaw();
            FieldTest.fail((String)"Should have blown up");
        }
        catch (AccessPoemException e2) {
            e2 = null;
        }
        try {
            f.getRawString();
            FieldTest.fail((String)"Should have blown up");
        }
        catch (AccessPoemException e3) {
            e2 = null;
        }
        try {
            f.getCooked();
            FieldTest.fail((String)"Should have blown up");
        }
        catch (AccessPoemException e4) {
            e2 = null;
        }
        try {
            f.getCookedString(PoemLocale.HERE, 2);
            FieldTest.fail((String)"Should have blown up");
        }
        catch (AccessPoemException e5) {
            e2 = null;
        }
        try {
            f.sameRawAs(this.integerField);
            FieldTest.fail((String)"Should have blown up");
        }
        catch (AccessPoemException e6) {
            Object var2_8 = null;
        }
    }

    public void testClone() {
        Field s2 = (Field)this.stringField.clone();
        FieldTest.assertFalse((boolean)s2.equals(this.stringField));
        FieldTest.assertEquals((String)this.stringField.getName(), (String)s2.getName());
        Field i2 = (Field)this.integerField.clone();
        FieldTest.assertFalse((boolean)i2.equals(this.integerField));
        FieldTest.assertEquals((String)this.integerField.getName(), (String)i2.getName());
    }

    public void testGetName() {
        FieldTest.assertEquals((String)"stringName", (String)this.stringField.getName());
        FieldTest.assertEquals((String)"integerName", (String)this.integerField.getName());
    }

    public void testGetDisplayName() {
        FieldTest.assertEquals((String)"String Display Name", (String)this.stringField.getDisplayName());
        FieldTest.assertEquals((String)"Integer Display Name", (String)this.integerField.getDisplayName());
    }

    public void testGetDescription() {
        FieldTest.assertEquals((String)"String description", (String)this.stringField.getDescription());
        FieldTest.assertEquals((String)"Integer description", (String)this.integerField.getDescription());
    }

    public void testGetType() {
        FieldTest.assertEquals((Object)StringPoemType.nullableInstance, (Object)this.stringField.getType());
        FieldTest.assertEquals((Object)IntegerPoemType.nullableInstance, (Object)this.integerField.getType());
    }

    public void testGetIndexed() {
        FieldTest.assertFalse((boolean)this.stringField.getIndexed());
        FieldTest.assertFalse((boolean)this.integerField.getIndexed());
    }

    public void testGetUserEditable() {
        FieldTest.assertTrue((boolean)this.stringField.getUserEditable());
        FieldTest.assertTrue((boolean)this.integerField.getUserEditable());
    }

    public void testGetUserCreateable() {
        FieldTest.assertTrue((boolean)this.stringField.getUserCreateable());
        FieldTest.assertTrue((boolean)this.integerField.getUserCreateable());
    }

    public void testGetWidth() {
        FieldTest.assertEquals((int)20, (int)this.stringField.getWidth());
        FieldTest.assertEquals((int)20, (int)this.integerField.getWidth());
    }

    public void testGetHeight() {
        FieldTest.assertEquals((int)1, (int)this.stringField.getHeight());
        FieldTest.assertEquals((int)1, (int)this.integerField.getHeight());
    }

    public void testGetRenderInfo() {
        FieldTest.assertNull((Object)this.stringField.getRenderInfo());
        FieldTest.assertNull((Object)this.integerField.getRenderInfo());
    }

    public void testGetRaw() {
        FieldTest.assertEquals((String)"stringfield", (String)((String)this.stringField.getRaw()));
        FieldTest.assertEquals((Object)new Integer(1), (Object)this.integerField.getRaw());
    }

    public void testGetRawString() {
        FieldTest.assertEquals((Object)"stringfield", (Object)this.stringField.getRawString());
        FieldTest.assertEquals((Object)"1", (Object)this.integerField.getRawString());
    }

    public void testGetCooked() {
        FieldTest.assertEquals((Object)"stringfield", (Object)this.stringField.getCooked());
        FieldTest.assertEquals((Object)new Integer(1), (Object)this.integerField.getCooked());
    }

    public void testGetCookedString() {
        FieldTest.assertEquals((String)"stringfield", (String)this.stringField.getCookedString(PoemLocale.HERE, 2));
        FieldTest.assertEquals((String)"1", (String)this.integerField.getCookedString(PoemLocale.HERE, 2));
    }

    public void testWithRaw() {
        Field stringField2 = this.stringField.withRaw((Object)"stringField2");
        FieldTest.assertEquals((String)"stringField2", (String)((String)stringField2.getRaw()));
        Field integerField2 = this.integerField.withRaw((Object)new Integer(2));
        FieldTest.assertEquals((Object)new Integer(2), (Object)integerField2.getRaw());
    }

    public void testWithNullable() {
        FieldTest.assertTrue((boolean)this.stringField.getType().getNullable());
        Field stringField2 = this.stringField.withNullable(false);
        FieldTest.assertFalse((boolean)stringField2.getType().getNullable());
        FieldTest.assertTrue((boolean)this.integerField.getType().getNullable());
        Field integerField2 = this.integerField.withNullable(false);
        FieldTest.assertFalse((boolean)integerField2.getType().getNullable());
    }

    public void testWithName() {
        Field stringField2 = this.stringField.withName("stringField2");
        FieldTest.assertEquals((String)"stringField2", (String)stringField2.getName());
        Field integerField2 = this.integerField.withName("integerField2");
        FieldTest.assertEquals((String)"integerField2", (String)integerField2.getName());
    }

    public void testWithDescription() {
        Field stringField2 = this.stringField.withDescription("stringField2");
        FieldTest.assertEquals((String)"stringField2", (String)stringField2.getDescription());
        Field integerField2 = this.integerField.withDescription("integerField2");
        FieldTest.assertEquals((String)"integerField2", (String)integerField2.getDescription());
    }

    public void testGetPossibilities() {
        Enumeration en = this.stringField.getPossibilities();
        FieldTest.assertNull((Object)en);
        en = this.integerField.getPossibilities();
        FieldTest.assertNull((Object)en);
    }

    public void testGetFirst1000Possibilities() {
        Enumeration en = this.stringField.getFirst1000Possibilities();
        FieldTest.assertNull((Object)en);
        en = this.integerField.getFirst1000Possibilities();
        FieldTest.assertNull((Object)en);
        Field tableCategoryField = this.getDb().getTableInfoTable().getCategoryColumn().asEmptyField();
        Enumeration possibleCategories = tableCategoryField.getFirst1000Possibilities();
        int counter = 0;
        while (possibleCategories.hasMoreElements()) {
            ++counter;
            possibleCategories.nextElement();
        }
        FieldTest.assertEquals((int)3, (int)counter);
    }

    public void testSameRawAs() {
        Field stringField2 = this.stringField.withRaw((Object)"stringField2");
        FieldTest.assertFalse((boolean)this.stringField.sameRawAs(stringField2));
        stringField2 = stringField2.withRaw((Object)"stringfield");
        FieldTest.assertTrue((boolean)this.stringField.sameRawAs(stringField2));
        Field integerField2 = this.integerField.withRaw((Object)new Integer(2));
        FieldTest.assertFalse((boolean)this.integerField.sameRawAs(integerField2));
        integerField2 = integerField2.withRaw((Object)new Integer(1));
        FieldTest.assertTrue((boolean)this.integerField.sameRawAs(integerField2));
    }

    public void testDump() {
    }

    public void testToString() {
    }

    public void testBasic() {
        Field f1 = Field.basic((Object)"basicField", (String)"basicField", (PoemType)StringPoemType.nullableInstance);
        Field f2 = Field.string((String)"basicField", (String)"basicField");
        FieldTest.assertTrue((boolean)f1.sameRawAs(f2));
    }

    public void testString() {
    }

    public void testInteger() {
        Field f1 = Field.basic((Object)new Integer(13), (String)"integerField", (PoemType)IntegerPoemType.nullableInstance);
        Field f2 = Field.integer((Integer)new Integer(13), (String)"integerField");
        FieldTest.assertTrue((boolean)f1.sameRawAs(f2));
    }

    public void testReferencePersistentString() {
        User u = this.getDb().guestUser();
        Field f1 = Field.basic((Object)u.getTroid(), (String)"referenceField", (PoemType)new ReferencePoemType((Table)this.getDb().getUserTable(), true));
        Field f2 = Field.reference((Persistent)u, (String)"referenceField");
        FieldTest.assertTrue((boolean)f1.sameRawAs(f2));
    }

    public void testReferenceTableString() {
        Field f1 = Field.basic(null, (String)"referenceField", (PoemType)new ReferencePoemType((Table)this.getDb().getUserTable(), true));
        Field f2 = Field.reference((Table)this.getDb().getUserTable(), (String)"referenceField");
        FieldTest.assertTrue((boolean)f1.sameRawAs(f2));
    }

    public void testHashCode() {
    }

    public void testEquals() {
    }
}

