/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.util.test;

import junit.framework.TestCase;
import org.melati.poem.util.StringUtils;

public class StringUtilsTest
extends TestCase {
    public void testSplit() {
        String them = "one,two,three";
        StringUtilsTest.assertEquals((int)3, (int)StringUtils.split((String)them, (char)',').length);
        StringUtilsTest.assertEquals((String)"two", (String)StringUtils.split((String)them, (char)',')[1]);
    }

    public void testAppendEscaped() {
        StringBuffer buff = new StringBuffer();
        StringUtilsTest.assertEquals((String)"", (String)buff.toString());
        StringUtils.appendEscaped((StringBuffer)buff, (String)"a$b", (char)'$');
        StringUtilsTest.assertEquals((String)"a\\$b", (String)buff.toString());
        StringUtils.appendEscaped((StringBuffer)buff, (String)"a$a$a$a", (char)'$');
        StringUtilsTest.assertEquals((String)"a\\$ba\\$a\\$a\\$a", (String)buff.toString());
        StringUtils.appendEscaped((StringBuffer)buff, (String)"c\\d", (char)'$');
        StringUtilsTest.assertEquals((String)"a\\$ba\\$a\\$a\\$ac\\\\d", (String)buff.toString());
    }

    public void testAppendQuoted() {
        StringBuffer buff = new StringBuffer();
        StringUtilsTest.assertEquals((String)"", (String)buff.toString());
        StringUtils.appendQuoted((StringBuffer)buff, (String)"a$b", (char)'$');
        StringUtilsTest.assertEquals((String)"$a\\$b$", (String)buff.toString());
        StringUtils.appendQuoted((StringBuffer)buff, (String)"c\\d", (char)'$');
        StringUtilsTest.assertEquals((String)"$a\\$b$$c\\\\d$", (String)buff.toString());
    }

    public void testQuoted() {
        StringUtilsTest.assertEquals((String)"\"a\"", (String)StringUtils.quoted((String)"a", (char)'\"'));
        StringUtilsTest.assertEquals((String)"'a'", (String)StringUtils.quoted((String)"a", (char)'\''));
    }

    public void testEscaped() {
    }

    public void testCapitalised() {
        StringUtilsTest.assertEquals((String)"Capitalised", (String)StringUtils.capitalised((String)"capitalised"));
    }

    public void testUncapitalised() {
        StringUtilsTest.assertEquals((String)"capitalised", (String)StringUtils.uncapitalised((String)"Capitalised"));
    }

    public void testTrStringStringString() {
        StringUtilsTest.assertEquals((String)"Muther", (String)StringUtils.tr((String)"Mother", (String)"o", (String)"u"));
    }

    public void testTrStringCharChar() {
        StringUtilsTest.assertEquals((String)"Muther", (String)StringUtils.tr((String)"Mother", (char)'o', (char)'u'));
    }

    public void testConcatenated() {
        String[] them = new String[]{"one", "two", "three"};
        StringUtilsTest.assertEquals((String)"one,two,three", (String)StringUtils.concatenated((String)",", (String[])them));
        StringUtilsTest.assertEquals((String)"onetwothree", (String)StringUtils.concatenated(null, (String[])them));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.concatenated(null, (String[])new String[0]));
    }

    public void testRandomString() {
        StringUtilsTest.assertEquals((int)5, (int)StringUtils.randomString((int)5).length());
    }

    public void testNulled() {
        StringUtilsTest.assertEquals(null, (String)StringUtils.nulled((String)""));
        StringUtilsTest.assertEquals((String)"null", (String)StringUtils.nulled((String)"null"));
    }

    public void testUnNulled() {
        String expected = "a";
        String actual = StringUtils.unNulled((String)"a");
        StringUtilsTest.assertEquals((String)expected, (String)actual);
    }

    public void testUnNulledNull() {
        String expected = "";
        String actual = StringUtils.unNulled(null);
        StringUtilsTest.assertEquals((String)expected, (String)actual);
    }

    public void testHexEncoding() {
        String[] strings = new String[]{"01234567", "abcdef", "f1234bcd"};
        for (int i = 0; i < strings.length; ++i) {
            StringUtilsTest.assertEquals((String)new String(StringUtils.hexDecoding((String)StringUtils.hexEncoding((byte[])strings[i].getBytes()))), (String)strings[i]);
        }
    }

    public void testHexDecodingChar() {
        StringUtilsTest.assertEquals((Object)new Integer(10), (Object)new Integer(StringUtils.hexDecoding((char)'A')));
        StringUtilsTest.assertEquals((Object)new Integer(10), (Object)new Integer(StringUtils.hexDecoding((char)'a')));
        StringUtilsTest.assertEquals((Object)new Integer(15), (Object)new Integer(StringUtils.hexDecoding((char)'F')));
        StringUtilsTest.assertEquals((Object)new Integer(15), (Object)new Integer(StringUtils.hexDecoding((char)'f')));
        try {
            StringUtils.hexDecoding((char)'g');
            StringUtilsTest.fail((String)"should have bombed");
        }
        catch (IllegalArgumentException e) {
            Object var1_2 = null;
        }
    }

    public void testHexDecodingString() {
        byte[] b = StringUtils.hexDecoding((String)"41");
        StringUtilsTest.assertEquals((Object)new Integer(65), (Object)new Integer(b[0]));
        try {
            StringUtils.hexDecoding((String)"411");
            StringUtilsTest.fail((String)"should have bombed");
        }
        catch (IllegalArgumentException e) {
            Object var2_3 = null;
        }
    }

    public void testIsQuoted() {
        StringUtilsTest.assertTrue((boolean)StringUtils.isQuoted((String)"\"a\""));
    }

    public void testIsQuotedNull() {
        StringUtilsTest.assertTrue((!StringUtils.isQuoted(null) ? 1 : 0) != 0);
    }

    public void testIsQuotedBlank() {
        StringUtilsTest.assertTrue((!StringUtils.isQuoted((String)"") ? 1 : 0) != 0);
    }

    public void testIsQuotedNot() {
        StringUtilsTest.assertTrue((!StringUtils.isQuoted((String)"a") ? 1 : 0) != 0);
    }

    public void testIsQuotedDouble() {
        StringUtilsTest.assertTrue((boolean)StringUtils.isQuoted((String)"\"a\""));
    }

    public void testIsQuotedSingle() {
        StringUtilsTest.assertTrue((boolean)StringUtils.isQuoted((String)"'a'"));
    }
}

