/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.melati.poem.AccessToken;
import org.melati.poem.Column;
import org.melati.poem.ColumnInfo;
import org.melati.poem.Database;
import org.melati.poem.NoSuchTablePoemException;
import org.melati.poem.Persistent;
import org.melati.poem.PoemDatabaseFactory;
import org.melati.poem.PoemTask;
import org.melati.poem.Table;

public class PoemTestCase
extends TestCase
implements Test {
    private String fName;
    protected int maxTrans = 0;
    private String databaseName = "melatijunit";
    private AccessToken userToRunAs;
    boolean problem = false;
    String dbUrl = null;
    private static String propertiesFileName = "org.melati.poem.test.PoemTestCase.properties";
    protected static TestResult result;

    public PoemTestCase() {
        this.fName = null;
    }

    public PoemTestCase(String name) {
        super(name);
        this.fName = name;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.problem = false;
        int freeTrans = this.getDb().getFreeTransactionsCount();
        PoemTestCase.assertEquals("Not all transactions free", this.maxTrans, freeTrans);
    }

    protected void tearDown() throws Exception {
        if (!this.problem) {
            this.checkDbUnchanged();
            PoemTestCase.assertEquals("Not all transactions free", this.maxTrans, this.getDb().getFreeTransactionsCount());
        }
    }

    public void run(TestResult resultIn) {
        result = resultIn;
        super.run(resultIn);
    }

    public static void assertEquals(String message, int expected, int actual) {
        try {
            Assert.assertEquals((String)message, (int)expected, (int)actual);
        }
        catch (Error e) {
            result.stop();
            throw e;
        }
    }

    protected void runTest() throws Throwable {
        PoemTestCase.assertNotNull((Object)this.fName);
        try {
            final Method runMethod = ((Object)((Object)this)).getClass().getMethod(this.fName, null);
            if (!Modifier.isPublic(runMethod.getModifiers())) {
                PoemTestCase.fail((String)("Method \"" + this.fName + "\" should be public"));
            }
            PoemTestCase _this = this;
            this.getDb().inSession(this.getUserToRunAs(), new PoemTask((Object)_this){
                final /* synthetic */ Object val$_this;
                {
                    this.val$_this = object;
                }

                public void run() {
                    try {
                        runMethod.invoke(this.val$_this, new Object[0]);
                    }
                    catch (Throwable e) {
                        PoemTestCase.this.problem = true;
                        e.fillInStackTrace();
                        throw new RuntimeException(e);
                    }
                }

                public String toString() {
                    return "PoemTestCase:" + PoemTestCase.this.fName;
                }
            });
        }
        catch (NoSuchMethodException e) {
            PoemTestCase.fail((String)("Method \"" + this.fName + "\" not found"));
        }
    }

    protected void checkDbUnchanged() {
        this.getDb().inSession(AccessToken.root, new PoemTask(){

            public void run() {
                PoemTestCase.this.databaseUnchanged();
            }
        });
    }

    protected void databaseUnchanged() {
        PoemTestCase.assertEquals("Group changed", 1, this.getDb().getGroupTable().count());
        PoemTestCase.assertEquals("GroupMembership changed", 1, this.getDb().getGroupMembershipTable().count());
        PoemTestCase.assertEquals("Capability changed", 5, this.getDb().getCapabilityTable().count());
        PoemTestCase.assertEquals("GroupCapability changed", 1, this.getDb().getGroupCapabilityTable().count());
        PoemTestCase.assertEquals("TableCategory changed", 3, this.getDb().getTableCategoryTable().count());
        PoemTestCase.assertEquals("User changed", 2, this.getDb().getUserTable().count());
        ColumnInfo newOne = null;
        try {
            newOne = (ColumnInfo)this.getDb().getColumnInfoTable().getObject(69);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (newOne != null) {
            String errStr = "Extra column in " + this.getDb() + " " + newOne.getName() + " " + newOne.getTableinfo().getName();
            newOne.delete();
            PoemTestCase.fail((String)errStr);
        } else if (this.getDb().getDbms().canDropColumns()) {
            PoemTestCase.assertEquals("ColumnInfo changed", 69, this.getDb().getColumnInfoTable().count());
            PoemTestCase.assertEquals("TableInfo changed", 9, this.getDb().getTableInfoTable().count());
            this.checkTablesAndColumns(9, 69);
        }
    }

    protected void dropTable(String tableName) {
        Connection c = this.getDb().getCommittedConnection();
        Table table = null;
        try {
            table = this.getDb().getTable(tableName);
            Statement s = c.createStatement();
            if (table != null && table.getTableInfo().statusExistent()) {
                s.executeUpdate("DROP TABLE " + this.getDb().getDbms().getQuotedName(tableName));
            }
            s.close();
            c.commit();
        }
        catch (NoSuchTablePoemException e2) {
            Object e2 = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            PoemTestCase.fail((String)"Something bombed");
        }
    }

    protected void checkTablesAndColumns(int tableCount, int columnCount) {
        this.checkTables(tableCount);
        this.checkColumns(columnCount);
    }

    protected void checkTables(int tableCount) {
        Table t;
        Enumeration e = this.getDb().tables();
        int count = 0;
        while (e.hasMoreElements()) {
            t = (Table)e.nextElement();
            if (!t.getTableInfo().statusExistent()) continue;
            ++count;
        }
        if (count != tableCount) {
            System.out.println(this.fName + " Additional tables - expected:" + tableCount + " found:" + count);
            e = this.getDb().tables();
            while (e.hasMoreElements()) {
                t = (Table)e.nextElement();
                System.out.println(t.getTableInfo().getTroid() + " " + t.getTableInfo().statusExistent() + " " + t);
            }
        }
        PoemTestCase.assertEquals((int)tableCount, (int)count);
    }

    protected void checkColumns(int columnCount) {
        Enumeration e = this.getDb().columns();
        int count = 0;
        while (e.hasMoreElements()) {
            Column c = (Column)e.nextElement();
            if (!c.getColumnInfo().statusExistent()) continue;
            ++count;
        }
        if (count != columnCount) {
            System.out.println(this.fName + " Additional columns - expected:" + columnCount + " found:" + count);
            e = this.getDb().columns();
            while (e.hasMoreElements()) {
                System.out.println(e.nextElement());
            }
        }
        PoemTestCase.assertEquals((int)columnCount, (int)count);
    }

    protected <P extends Persistent> void dumpTable(Table<P> t) {
        Enumeration them = t.selection();
        while (them.hasMoreElements()) {
            Persistent it = (Persistent)them.nextElement();
            System.err.println(it.getTroid() + " " + it.getCooked("name") + " " + it.getTable().getName());
        }
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public Database getDb() {
        return this.getDb(this.getDatabaseName());
    }

    public Database getDb(String dbNameP) {
        if (dbNameP == null) {
            throw new NullPointerException();
        }
        return this.getDatabase(dbNameP);
    }

    public Database getDatabase(String name) {
        Properties defs = this.getProperties();
        String pref = "org.melati.poem.test.PoemTestCase." + name + ".";
        this.maxTrans = new Integer(PoemTestCase.getOrDie(defs, pref + "maxtransactions"));
        String url = PoemTestCase.getOrDie(defs, pref + "url");
        return PoemDatabaseFactory.getDatabase((String)name, (String)url, (String)PoemTestCase.getOrDie(defs, pref + "user"), (String)PoemTestCase.getOrDie(defs, pref + "password"), (String)PoemTestCase.getOrDie(defs, pref + "class"), (String)PoemTestCase.getOrDie(defs, pref + "dbmsclass"), (boolean)new Boolean(PoemTestCase.getOrDie(defs, pref + "addconstraints")), (boolean)new Boolean(PoemTestCase.getOrDie(defs, pref + "logsql")), (boolean)new Boolean(PoemTestCase.getOrDie(defs, pref + "logcommits")), (int)this.maxTrans);
    }

    public AccessToken getUserToRunAs() {
        if (this.userToRunAs == null) {
            return AccessToken.root;
        }
        return this.userToRunAs;
    }

    public void setUserToRunAs(AccessToken userToRunAs) {
        this.userToRunAs = userToRunAs == null ? AccessToken.root : userToRunAs;
    }

    public Properties getProperties() {
        InputStream is = PoemTestCase.class.getResourceAsStream(this.getPropertiesFileName());
        if (is == null) {
            throw new RuntimeException(new FileNotFoundException(this.getPropertiesFileName() + ": is it in CLASSPATH?"));
        }
        Properties them = new Properties();
        try {
            them.load(is);
            is.close();
        }
        catch (IOException e) {
            throw new RuntimeException(new IOException("Corrupt properties file `" + this.getPropertiesFileName() + "': " + e.getMessage()));
        }
        return them;
    }

    public static String getOrDie(Properties properties, String propertyName) {
        String value = properties.getProperty(propertyName);
        if (value == null) {
            throw new RuntimeException("Property " + propertyName + " not found in " + properties);
        }
        return value;
    }

    public String getPropertiesFileName() {
        return propertiesFileName;
    }

    public void setPropertiesFileName(String propertiesFileNameIn) {
        propertiesFileName = propertiesFileNameIn;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertEquals(String message, File expected, File actual) {
        Assert.assertNotNull((Object)expected);
        Assert.assertNotNull((Object)actual);
        Assert.assertTrue((String)("File does not exist [" + expected.getAbsolutePath() + "]"), (boolean)expected.exists());
        Assert.assertTrue((String)("File does not exist [" + actual.getAbsolutePath() + "]"), (boolean)actual.exists());
        Assert.assertTrue((String)"Expected file not readable", (boolean)expected.canRead());
        Assert.assertTrue((String)"Actual file not readable", (boolean)actual.canRead());
        FileInputStream eis = null;
        FileInputStream ais = null;
        try {
            try {
                eis = new FileInputStream(expected);
                ais = new FileInputStream(actual);
                BufferedReader expData = new BufferedReader(new InputStreamReader(eis));
                BufferedReader actData = new BufferedReader(new InputStreamReader(ais));
                Assert.assertNotNull((String)message, (Object)expData);
                Assert.assertNotNull((String)message, (Object)actData);
                PoemTestCase.assertEquals((String)message, (Object)expData, (Object)actData);
            }
            finally {
                if (eis != null) {
                    eis.close();
                }
                if (ais != null) {
                    ais.close();
                }
            }
        }
        catch (IOException e) {
            throw new AssertionFailedError(e.toString());
        }
    }

    public static void assertEquals(File expected, File actual) {
        PoemTestCase.assertEquals(null, expected, actual);
    }

    public void testNothing() {
    }
}

