/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.test.throwing;

import java.sql.Connection;
import java.sql.ResultSet;
import org.melati.poem.AccessToken;
import org.melati.poem.Database;
import org.melati.poem.PoemDatabase;
import org.melati.poem.PoemThread;
import org.melati.poem.ReconnectionPoemException;
import org.melati.poem.SQLPoemException;
import org.melati.poem.SQLSeriousPoemException;
import org.melati.poem.TableInfo;
import org.melati.poem.UnexpectedExceptionPoemException;
import org.melati.poem.UnificationPoemException;
import org.melati.poem.dbms.test.sql.Thrower;

public class DatabaseTest
extends org.melati.poem.test.DatabaseTest {
    private static Database db;

    public DatabaseTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        db = null;
    }

    private static Database getDb() {
        db = new PoemDatabase();
        db.connect("m2", "org.melati.poem.dbms.test.HsqldbThrower", "jdbc:hsqldb:mem:m2", "sa", "", 8);
        DatabaseTest.assertTrue((db.getClass().getName() == "org.melati.poem.PoemDatabase" ? 1 : 0) != 0);
        DatabaseTest.assertEquals((int)8, (int)db.getFreeTransactionsCount());
        return db;
    }

    @Override
    public void testAddConstraints() {
    }

    @Override
    public void testAddTableAndCommit() {
    }

    public void testAddTableAndCommitThrowing() {
        db = DatabaseTest.getDb();
        db.beginSession(AccessToken.root);
        TableInfo info = (TableInfo)db.getTableInfoTable().newPersistent();
        info.setName("addedtable");
        info.setDisplayname("Junit created table");
        info.setDisplayorder(13);
        info.setSeqcached(new Boolean(false));
        info.setCategory_unsafe(new Integer(1));
        info.setCachelimit(0);
        info.makePersistent();
        PoemThread.commit();
        Thrower.startThrowing(Connection.class, (String)"getMetaData");
        try {
            db.addTableAndCommit(info, "id");
            DatabaseTest.fail((String)"Should have blown up");
        }
        catch (SQLSeriousPoemException e) {
            DatabaseTest.assertEquals((String)"Connection bombed", (String)e.innermostException().getMessage());
        }
        Thrower.stopThrowing(Connection.class, (String)"getMetaData");
        db.sqlUpdate("DROP TABLE " + db.getDbms().getQuotedName("addedtable"));
        db.sqlUpdate("DROP TABLE " + db.getDbms().getQuotedName("columninfo"));
        db.sqlUpdate("DROP TABLE " + db.getDbms().getQuotedName("tableinfo"));
        PoemThread.commit();
        db.endSession();
    }

    @Override
    public void testAdministerCapability() {
    }

    @Override
    public void testAdministratorUser() {
    }

    @Override
    public void testBeginExclusiveLock() {
    }

    @Override
    public void testBeginSession() {
    }

    @Override
    public void testColumns() {
    }

    @Override
    public void testConnect() {
        try {
            DatabaseTest.getDb().connect("m2", "org.melati.poem.dbms.test.HsqldbThrower", "jdbc:hsqldb:mem:m2", "sa", "", 8);
            DatabaseTest.fail((String)"Should have blown up");
        }
        catch (ReconnectionPoemException e2) {
            Object e2 = null;
        }
        Thrower.startThrowing(ResultSet.class, (String)"close");
        try {
            DatabaseTest.getDb();
            DatabaseTest.fail((String)"Should have blown up");
        }
        catch (SQLSeriousPoemException e) {
            DatabaseTest.assertEquals((String)"ResultSet bombed", (String)e.innermostException().getMessage());
        }
        Thrower.stopThrowing(ResultSet.class, (String)"close");
    }

    public void testConnect2() {
        db = new PoemDatabase();
        Thrower.startThrowingAfter(Connection.class, (String)"getMetaData", (int)1);
        try {
            db.connect("m2", "org.melati.poem.dbms.test.HsqldbThrower", "jdbc:hsqldb:mem:m2", "sa", "", 4);
            DatabaseTest.fail((String)"Should have blown up");
        }
        catch (SQLPoemException e) {
            DatabaseTest.assertEquals((String)"Connection bombed", (String)e.innermostException().getMessage());
        }
        DatabaseTest.assertEquals((int)0, (int)db.getFreeTransactionsCount());
        db = null;
        Thrower.stopThrowing(Connection.class, (String)"getMetaData");
    }

    public void testConnectThrowing3() {
        db = DatabaseTest.getDb();
        db.disconnect();
        Thrower.startThrowing(Connection.class, (String)"getMetaData");
        try {
            db.connect("m2", "org.melati.poem.dbms.test.HsqldbThrower", "jdbc:hsqldb:mem:m2", "sa", "", 4);
            DatabaseTest.fail((String)"Should have blown up");
        }
        catch (UnificationPoemException e) {
            DatabaseTest.assertEquals((String)"Connection bombed", (String)e.innermostException().getMessage());
        }
        DatabaseTest.assertEquals((int)0, (int)db.getFreeTransactionsCount());
        db = null;
        Thrower.stopThrowing(Connection.class, (String)"getMetaData");
    }

    @Override
    public void testDatabase() {
    }

    @Override
    public void testDisconnect() {
        db = DatabaseTest.getDb();
        Thrower.startThrowing(Connection.class, (String)"close");
        try {
            db.disconnect();
            DatabaseTest.fail((String)"Should have blown up");
        }
        catch (SQLPoemException e) {
            DatabaseTest.assertEquals((String)"Connection bombed", (String)e.innermostException().getMessage());
        }
        Thrower.stopThrowing(Connection.class, (String)"close");
        db.disconnect();
        DatabaseTest.assertEquals((int)0, (int)db.getFreeTransactionsCount());
        db = null;
    }

    @Override
    public void testDump() {
    }

    @Override
    public void testDumpCacheAnalysis() {
    }

    @Override
    public void testEndExclusiveLock() {
    }

    @Override
    public void testEndSession() {
    }

    @Override
    public void testGetCanAdminister() {
    }

    @Override
    public void testGetCapabilityTable() {
    }

    @Override
    public void testGetColumnInfoTable() {
    }

    @Override
    public void testGetCommittedConnection() {
    }

    @Override
    public void testGetDbms() {
    }

    @Override
    public void testGetDisplayTables() {
    }

    @Override
    public void testGetFreeTransactionsCount() {
    }

    @Override
    public void testGetGroupCapabilityTable() {
    }

    @Override
    public void testGetGroupMembershipTable() {
    }

    @Override
    public void testGetGroupTable() {
    }

    @Override
    public void testGetQueryCount() {
    }

    @Override
    public void testGetSettingTable() {
    }

    @Override
    public void testGetTable() {
    }

    @Override
    public void testGetTableCategoryTable() {
    }

    @Override
    public void testGetTableInfoTable() {
    }

    @Override
    public void testGetTransactionsCount() {
    }

    @Override
    public void testGetUserTable() {
    }

    @Override
    public void testGivesCapabilitySQL() {
    }

    @Override
    public void testGuestAccessToken() {
    }

    @Override
    public void testGuestUser() {
    }

    @Override
    public void testHasCapability() {
    }

    public void testHasCapabilityThrowing() {
        db = DatabaseTest.getDb();
        db.beginSession(AccessToken.root);
        Thrower.startThrowing(ResultSet.class, (String)"next");
        try {
            DatabaseTest.assertFalse((boolean)db.hasCapability(db.guestUser(), db.administerCapability()));
            DatabaseTest.fail((String)"Should have bombed");
        }
        catch (SQLSeriousPoemException e) {
            DatabaseTest.assertEquals((String)"ResultSet bombed", (String)e.innermostException().getMessage());
        }
        Thrower.stopThrowing(ResultSet.class, (String)"next");
        Thrower.startThrowing(Connection.class, (String)"createStatement");
        try {
            DatabaseTest.assertFalse((boolean)db.hasCapability(db.guestUser(), db.administerCapability()));
            DatabaseTest.fail((String)"Should have bombed");
        }
        catch (UnexpectedExceptionPoemException e) {
            DatabaseTest.assertEquals((String)"Connection bombed", (String)e.innermostException().getMessage());
        }
        Thrower.stopThrowing(Connection.class, (String)"createStatement");
        db.endSession();
    }

    @Override
    public void testInCommittedTransaction() {
    }

    @Override
    public void testIncrementQueryCount() {
    }

    @Override
    public void testInSession() {
    }

    @Override
    public void testIsFree() {
    }

    @Override
    public void testLogCommits() {
    }

    @Override
    public void testLogSQL() {
    }

    @Override
    public void testPoemTransaction() {
    }

    @Override
    public void testQuotedName() {
    }

    @Override
    public void testReferencesToPersistent() {
    }

    @Override
    public void testReferencesToTable() {
    }

    @Override
    public void testSetCanAdminister() {
        super.testSetCanAdminister();
    }

    @Override
    public void testSetCanAdministerString() {
    }

    @Override
    public void testSetLogCommits() {
    }

    @Override
    public void testSetLogSQL() {
    }

    @Override
    public void testSetTransactionsMax() {
    }

    @Override
    public void testSqlQuery() {
    }

    @Override
    public void testSqlUpdate() {
    }

    @Override
    public void testTables() {
    }

    @Override
    public void testToString() {
    }

    @Override
    public void testTransaction() {
    }

    @Override
    public void testTransactionsMax() {
    }

    @Override
    public void testTrimCache() {
    }

    @Override
    public void testUncacheContents() {
    }
}

