/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.util.test;

import java.util.Enumeration;
import junit.framework.TestCase;
import org.melati.poem.util.Cache;
import org.melati.poem.util.CacheDuplicationException;
import org.melati.poem.util.EnumUtils;

public class CacheTest
extends TestCase {
    Cache c = null;

    public CacheTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.c = new Cache(12);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testCache() {
    }

    public void testSetSize() {
        CacheTest.assertEquals((int)12, (int)this.c.getSize());
        this.c.setSize(100);
        CacheTest.assertEquals((int)100, (int)this.c.getSize());
        this.c.setSize(12);
        try {
            this.c.setSize(-1);
            CacheTest.fail((String)"Should have bombed");
        }
        catch (IllegalArgumentException e) {
            Object var1_2 = null;
        }
    }

    public void testTrim() {
        this.c.setSize(4);
        CacheTest.assertEquals((int)4, (int)this.c.getSize());
        CacheTest.assertFalse((boolean)this.c.getInfo().getHeldElements().hasMoreElements());
        CacheTest.assertFalse((boolean)this.c.getInfo().getDroppedElements().hasMoreElements());
        this.c.put((Object)"a", (Object)"a1");
        this.c.put((Object)"b", (Object)"a1");
        this.c.put((Object)"c", (Object)"a1");
        this.c.put((Object)"d", (Object)"a1");
        CacheTest.assertTrue((boolean)this.c.getInfo().getHeldElements().hasMoreElements());
        CacheTest.assertFalse((boolean)this.c.getInfo().getDroppedElements().hasMoreElements());
        this.c.put((Object)"e", (Object)"a1");
        CacheTest.assertFalse((boolean)this.c.getInfo().getDroppedElements().hasMoreElements());
        this.c.put((Object)"f", (Object)"a1");
        CacheTest.assertTrue((boolean)this.c.getInfo().getDroppedElements().hasMoreElements());
        this.c.trim(3);
        CacheTest.assertTrue((boolean)this.c.getInfo().getDroppedElements().hasMoreElements());
        CacheTest.assertEquals((int)4, (int)this.c.getSize());
    }

    public void testDelete() {
        this.c.delete((Object)"not in cache");
        this.c.put((Object)"key", (Object)"value");
        this.c.delete((Object)"key");
        CacheTest.assertNull((Object)this.c.get((Object)"key"));
    }

    public void testPut() {
        this.c.put((Object)"a", (Object)"a1");
        try {
            this.c.put((Object)"a", (Object)"a1");
            CacheTest.fail((String)"Should have bombed");
        }
        catch (CacheDuplicationException e) {
            Object var1_2 = null;
        }
    }

    public void testPutNullKey() {
        try {
            this.c.put(null, (Object)"null");
            CacheTest.fail((String)"Should have bombed");
        }
        catch (NullPointerException e) {
            Object var1_2 = null;
        }
    }

    public void testPutNullValue() {
        try {
            this.c.put((Object)"null", null);
            CacheTest.fail((String)"Should have bombed");
        }
        catch (NullPointerException e) {
            Object var1_2 = null;
        }
    }

    public void testGet() {
        this.c.setSize(2);
        this.c.put((Object)"key1", (Object)"1");
        CacheTest.assertEquals((Object)"1", (Object)this.c.get((Object)"key1"));
        this.c.put((Object)"key2", (Object)"2");
        CacheTest.assertEquals((Object)"1", (Object)this.c.get((Object)"key1"));
        CacheTest.assertEquals((Object)"2", (Object)this.c.get((Object)"key2"));
        this.c.put((Object)"key3", (Object)"3");
        CacheTest.assertEquals((Object)"1", (Object)this.c.get((Object)"key1"));
        CacheTest.assertEquals((Object)"2", (Object)this.c.get((Object)"key2"));
        CacheTest.assertEquals((Object)"3", (Object)this.c.get((Object)"key3"));
        this.c.put((Object)"key4", (Object)"4");
        CacheTest.assertEquals((Object)"1", (Object)this.c.get((Object)"key1"));
        CacheTest.assertEquals((Object)"2", (Object)this.c.get((Object)"key2"));
        CacheTest.assertEquals((Object)"3", (Object)this.c.get((Object)"key3"));
        CacheTest.assertEquals((Object)"4", (Object)this.c.get((Object)"key4"));
        this.c.put((Object)"key5", (Object)"5");
        CacheTest.assertEquals((Object)"1", (Object)this.c.get((Object)"key1"));
        CacheTest.assertEquals((Object)"2", (Object)this.c.get((Object)"key2"));
        CacheTest.assertEquals((Object)"3", (Object)this.c.get((Object)"key3"));
        CacheTest.assertEquals((Object)"4", (Object)this.c.get((Object)"key4"));
        CacheTest.assertEquals((Object)"5", (Object)this.c.get((Object)"key5"));
        this.c.trim(2);
        CacheTest.assertEquals((Object)"1", (Object)this.c.get((Object)"key1"));
        CacheTest.assertEquals((Object)"2", (Object)this.c.get((Object)"key2"));
        CacheTest.assertEquals((Object)"3", (Object)this.c.get((Object)"key3"));
        CacheTest.assertEquals((Object)"4", (Object)this.c.get((Object)"key4"));
        CacheTest.assertEquals((Object)"5", (Object)this.c.get((Object)"key5"));
        CacheTest.assertNull((Object)this.c.get((Object)"not in cache"));
    }

    public void testIterate() {
    }

    public void testGetReport() {
        this.c.setSize(1);
        Enumeration report = this.c.getReport();
        CacheTest.assertTrue((boolean)report.hasMoreElements());
        CacheTest.assertEquals((Object)"1 maxSize, null theMRU, null theLRU, 0 collectedEver", report.nextElement());
        CacheTest.assertEquals((Object)"0 held, 0 total ", report.nextElement());
        CacheTest.assertFalse((boolean)report.hasMoreElements());
        this.c.put((Object)"key1", (Object)"value1");
        report = this.c.getReport();
        CacheTest.assertTrue((boolean)report.hasMoreElements());
        CacheTest.assertEquals((Object)"1 maxSize, null>>key1=value1>>null theMRU, null>>key1=value1>>null theLRU, 0 collectedEver", report.nextElement());
        CacheTest.assertEquals((Object)"1 held, 1 total ", report.nextElement());
        CacheTest.assertFalse((boolean)report.hasMoreElements());
        this.c.put((Object)"key2", (Object)"value2");
        report = this.c.getReport();
        CacheTest.assertTrue((boolean)report.hasMoreElements());
        CacheTest.assertEquals((Object)"1 maxSize, null>>key2=value2>>key1 theMRU, key2>>key1=value1>>null theLRU, 0 collectedEver", report.nextElement());
        CacheTest.assertEquals((Object)"2 held, 2 total ", report.nextElement());
        CacheTest.assertFalse((boolean)report.hasMoreElements());
        this.c.put((Object)"key3", (Object)"value3");
        report = this.c.getReport();
        CacheTest.assertTrue((boolean)report.hasMoreElements());
        CacheTest.assertEquals((Object)"1 maxSize, null>>key3=value3>>key2 theMRU, key3>>key2=value2>>null theLRU, 0 collectedEver", report.nextElement());
        CacheTest.assertEquals((Object)"2 held, 3 total ", report.nextElement());
        CacheTest.assertFalse((boolean)report.hasMoreElements());
    }

    public void testGetInfo() {
        Enumeration report = this.c.getInfo().getReport();
        CacheTest.assertTrue((boolean)report.hasMoreElements());
        CacheTest.assertEquals(this.c.getReport().nextElement(), report.nextElement());
        CacheTest.assertFalse((boolean)this.c.getInfo().getDroppedElements().hasMoreElements());
        this.c.put((Object)"key", (Object)"value");
        this.c.delete((Object)"key");
        CacheTest.assertFalse((boolean)this.c.getInfo().getDroppedElements().hasMoreElements());
        this.c.setSize(1);
        this.c.put((Object)"key1", (Object)"value1");
        CacheTest.assertFalse((boolean)this.c.getInfo().getDroppedElements().hasMoreElements());
        this.c.put((Object)"key2", (Object)"value2");
        CacheTest.assertFalse((boolean)this.c.getInfo().getDroppedElements().hasMoreElements());
        this.c.put((Object)"key3", (Object)"value3");
        CacheTest.assertEquals((int)1, (int)EnumUtils.vectorOf((Enumeration)this.c.getInfo().getDroppedElements()).size());
    }

    public void testDumpAnalysis() {
        this.c.dumpAnalysis();
    }

    public void testFillingToBeyondCapacity() {
        int i;
        for (i = 5; i < 12; ++i) {
            this.c.setSize(i);
            this.c.delete((Object)"01");
            this.c.put((Object)"01", (Object)"a");
            this.c.dumpAnalysis();
            this.c.delete((Object)"02");
            this.c.put((Object)"02", (Object)"b");
            this.c.dumpAnalysis();
            this.c.delete((Object)"03");
            this.c.put((Object)"03", (Object)"c");
            this.c.dumpAnalysis();
            this.c.delete((Object)"04");
            this.c.put((Object)"04", (Object)"d");
            this.c.dumpAnalysis();
            this.c.delete((Object)"05");
            this.c.put((Object)"05", (Object)"e");
            this.c.dumpAnalysis();
            this.c.delete((Object)"06");
            this.c.put((Object)"06", (Object)"f");
            this.c.dumpAnalysis();
            this.c.delete((Object)"07");
            this.c.put((Object)"07", (Object)"g");
            this.c.dumpAnalysis();
            this.c.delete((Object)"08");
            this.c.put((Object)"08", (Object)"h");
            this.c.dumpAnalysis();
            this.c.delete((Object)"09");
            this.c.put((Object)"09", (Object)"i");
            this.c.dumpAnalysis();
            this.c.delete((Object)"10");
            this.c.put((Object)"10", (Object)"j");
            this.c.dumpAnalysis();
            this.c.delete((Object)"11");
            this.c.put((Object)"11", (Object)"k");
            this.c.dumpAnalysis();
            this.c.delete((Object)"12");
            this.c.put((Object)"12", (Object)"l");
            this.c.dumpAnalysis();
            this.c.delete((Object)"13");
            this.c.put((Object)"13", (Object)"m");
            this.c.dumpAnalysis();
            this.c.delete((Object)"14");
            this.c.put((Object)"14", (Object)"n");
            this.c.dumpAnalysis();
            this.c.delete((Object)"15");
            this.c.put((Object)"15", (Object)"o");
            this.c.dumpAnalysis();
        }
        System.err.println("--");
        for (i = 12; i > 4; --i) {
            this.c.trim(i);
            this.c.delete((Object)"01");
            this.c.put((Object)"01", (Object)"a");
            this.c.dumpAnalysis();
            this.c.delete((Object)"02");
            this.c.put((Object)"02", (Object)"b");
            this.c.dumpAnalysis();
            this.c.delete((Object)"03");
            this.c.put((Object)"03", (Object)"c");
            this.c.dumpAnalysis();
            this.c.delete((Object)"04");
            this.c.put((Object)"04", (Object)"d");
            this.c.dumpAnalysis();
            this.c.delete((Object)"05");
            this.c.put((Object)"05", (Object)"e");
            this.c.dumpAnalysis();
            this.c.delete((Object)"06");
            this.c.put((Object)"06", (Object)"f");
            this.c.dumpAnalysis();
            this.c.delete((Object)"07");
            this.c.put((Object)"07", (Object)"g");
            this.c.dumpAnalysis();
            this.c.delete((Object)"08");
            this.c.put((Object)"08", (Object)"h");
            this.c.dumpAnalysis();
            this.c.delete((Object)"09");
            this.c.put((Object)"09", (Object)"i");
            this.c.dumpAnalysis();
            this.c.delete((Object)"10");
            this.c.put((Object)"10", (Object)"j");
            this.c.dumpAnalysis();
            this.c.delete((Object)"11");
            this.c.put((Object)"11", (Object)"k");
            this.c.dumpAnalysis();
            this.c.delete((Object)"12");
            this.c.put((Object)"12", (Object)"l");
            this.c.dumpAnalysis();
            this.c.delete((Object)"13");
            this.c.put((Object)"13", (Object)"m");
            this.c.dumpAnalysis();
            this.c.delete((Object)"14");
            this.c.put((Object)"14", (Object)"n");
            this.c.dumpAnalysis();
            this.c.delete((Object)"15");
            this.c.put((Object)"15", (Object)"o");
            this.c.dumpAnalysis();
        }
        System.err.println("--");
        this.c.dump();
    }

    public void testZeroSizedCache() {
        Cache z = new Cache(0);
        CacheTest.assertNull((Object)z.get((Object)"a"));
        z.put((Object)"a", (Object)"A");
        CacheTest.assertEquals((Object)"A", (Object)z.get((Object)"a"));
        CacheTest.assertFalse((boolean)this.c.getInfo().getDroppedElements().hasMoreElements());
    }

    public void testGCHandling() {
        char[] ballast = new char[4000000];
        try {
            ballast[0] = 101;
            for (int i = 0; i < 1000; ++i) {
                this.c.put((Object)new Integer(i), (Object)new StringBuffer(1000000));
            }
        }
        catch (OutOfMemoryError m) {
            ballast = null;
            Runtime r = Runtime.getRuntime();
            r.gc();
        }
        this.c.dump();
    }
}

