// Do not edit this file!  It was generated by Melati POEM's DSD preprocessor.

package org.melati.poem.generated;


import org.melati.poem.AccessPoemException;
import org.melati.poem.BooleanPoemType;
import org.melati.poem.Capability;
import org.melati.poem.Column;
import org.melati.poem.Database;
import org.melati.poem.DefinitionSource;
import org.melati.poem.DisplayLevel;
import org.melati.poem.Field;
import org.melati.poem.IntegerPoemType;
import org.melati.poem.JdbcPersistent;
import org.melati.poem.Persistent;
import org.melati.poem.PoemDatabaseTables;
import org.melati.poem.PoemException;
import org.melati.poem.PoemTable;
import org.melati.poem.ReferencePoemType;
import org.melati.poem.Searchability;
import org.melati.poem.StandardIntegrityFix;
import org.melati.poem.StringPoemType;
import org.melati.poem.TableCategory;
import org.melati.poem.TableInfo;
import org.melati.poem.TroidPoemType;
import org.melati.poem.ValidationPoemException;


/**
 * Melati POEM generated base class for <code>Table</code> <code>tableInfo</code>.
 *
 * See org.melati.poem.prepro.TableDef#generateTableBaseJava 
 */

public class TableInfoTableBase<T extends TableInfo> extends PoemTable<T> {

  private Column<Integer> col_id = null;
  private Column<String> col_name = null;
  private Column<String> col_displayname = null;
  private Column<String> col_description = null;
  private Column<Integer> col_displayorder = null;
  private Column<Integer> col_defaultcanread = null;
  private Column<Integer> col_defaultcanwrite = null;
  private Column<Integer> col_defaultcandelete = null;
  private Column<Integer> col_cancreate = null;
  private Column<Integer> col_cachelimit = null;
  private Column<Boolean> col_seqcached = null;
  private Column<Integer> col_category = null;

 /**
  * Constructor. 
  * 
  * See org.melati.poem.prepro.TableDef#generateTableBaseJava 
  * @param database          the POEM database we are using
  * @param name              the name of this <code>Table</code>
  * @param definitionSource  which definition is being used
  * @throws PoemException    if anything goes wrong
  */

  public TableInfoTableBase(
      Database database, String name,
      DefinitionSource definitionSource) throws PoemException {
    super(database, name, definitionSource);
  }


 /**
  * Get the database tables.
  *
  * See org.melati.poem.prepro.TableDef#generateTableBaseJava 
  * @return the database tables
  */
  public PoemDatabaseTables getPoemDatabaseTables() {
    return (PoemDatabaseTables)getDatabase();
  }


 /**
  * Initialise this table by defining its columns.
  *
  * See org.melati.poem.prepro.TableDef#generateTableBaseJava 
  */
  public void init() throws PoemException {
    super.init();
    defineColumn(col_id =
        new Column<Integer>(this, "id",
                   new TroidPoemType(),
                   DefinitionSource.dsd) { 
          public Object getCooked(Persistent g)
              throws AccessPoemException, PoemException {
            return ((TableInfo)g).getId();
          }

          public void setCooked(Persistent g, Object cooked)
              throws AccessPoemException, ValidationPoemException {
            ((TableInfo)g).setId((Integer)cooked);
          }

          public Field<Integer> asField(Persistent g) {
            return ((TableInfo)g).getIdField();
          }

          public boolean defaultUserEditable() {
            return false;
          }

          public boolean defaultUserCreateable() {
            return false;
          }

          public DisplayLevel defaultDisplayLevel() {
            return DisplayLevel.detail;
          }

          public int defaultDisplayOrder() {
            return 0;
          }

          public String defaultDescription() {
            return "The Table Row Object ID";
          }

          public Object getRaw_unsafe(Persistent g)
              throws AccessPoemException {
            return ((TableInfo)g).getId_unsafe();
          }

          public void setRaw_unsafe(Persistent g, Object raw)
              throws AccessPoemException {
            ((TableInfo)g).setId_unsafe((Integer)raw);
          }

          public Object getRaw(Persistent g)
              throws AccessPoemException {
            return ((TableInfo)g).getId();
          }

          public void setRaw(Persistent g, Object raw)
              throws AccessPoemException {
            ((TableInfo)g).setId((Integer)raw);
          }
        });

    defineColumn(col_name =
        new Column<String>(this, "name",
                   new StringPoemType(false, 50),
                   DefinitionSource.dsd) { 
          public Object getCooked(Persistent g)
              throws AccessPoemException, PoemException {
            return ((TableInfo)g).getName();
          }

          public void setCooked(Persistent g, Object cooked)
              throws AccessPoemException, ValidationPoemException {
            ((TableInfo)g).setName((String)cooked);
          }

          public Field<String> asField(Persistent g) {
            return ((TableInfo)g).getNameField();
          }

          public boolean defaultUserEditable() {
            return false;
          }

          public DisplayLevel defaultDisplayLevel() {
            return DisplayLevel.record;
          }

          public Searchability defaultSearchability() {
            return Searchability.no;
          }

          public int defaultDisplayOrder() {
            return 1;
          }

          public String defaultDescription() {
            return "A code-name for the table";
          }

          public boolean defaultUnique() {
            return true;
          }

          public Object getRaw_unsafe(Persistent g)
              throws AccessPoemException {
            return ((TableInfo)g).getName_unsafe();
          }

          public void setRaw_unsafe(Persistent g, Object raw)
              throws AccessPoemException {
            ((TableInfo)g).setName_unsafe((String)raw);
          }

          public Object getRaw(Persistent g)
              throws AccessPoemException {
            return ((TableInfo)g).getName();
          }

          public void setRaw(Persistent g, Object raw)
              throws AccessPoemException {
            ((TableInfo)g).setName((String)raw);
          }
        });

    defineColumn(col_displayname =
        new Column<String>(this, "displayname",
                   new StringPoemType(false, 60),
                   DefinitionSource.dsd) { 
          public Object getCooked(Persistent g)
              throws AccessPoemException, PoemException {
            return ((TableInfo)g).getDisplayname();
          }

          public void setCooked(Persistent g, Object cooked)
              throws AccessPoemException, ValidationPoemException {
            ((TableInfo)g).setDisplayname((String)cooked);
          }

          public Field<String> asField(Persistent g) {
            return ((TableInfo)g).getDisplaynameField();
          }

          public DisplayLevel defaultDisplayLevel() {
            return DisplayLevel.primary;
          }

          public Integer defaultDisplayOrderPriority() {
            return new Integer(1);
          }

          public String defaultDisplayName() {
            return "Display name";
          }

          public int defaultDisplayOrder() {
            return 2;
          }

          public String defaultDescription() {
            return "A user-friendly name for the table";
          }

          public Object getRaw_unsafe(Persistent g)
              throws AccessPoemException {
            return ((TableInfo)g).getDisplayname_unsafe();
          }

          public void setRaw_unsafe(Persistent g, Object raw)
              throws AccessPoemException {
            ((TableInfo)g).setDisplayname_unsafe((String)raw);
          }

          public Object getRaw(Persistent g)
              throws AccessPoemException {
            return ((TableInfo)g).getDisplayname();
          }

          public void setRaw(Persistent g, Object raw)
              throws AccessPoemException {
            ((TableInfo)g).setDisplayname((String)raw);
          }
        });

    defineColumn(col_description =
        new Column<String>(this, "description",
                   new StringPoemType(true, -1),
                   DefinitionSource.dsd) { 
          public Object getCooked(Persistent g)
              throws AccessPoemException, PoemException {
            return ((TableInfo)g).getDescription();
          }

          public void setCooked(Persistent g, Object cooked)
              throws AccessPoemException, ValidationPoemException {
            ((TableInfo)g).setDescription((String)cooked);
          }

          public Field<String> asField(Persistent g) {
            return ((TableInfo)g).getDescriptionField();
          }

          public DisplayLevel defaultDisplayLevel() {
            return DisplayLevel.record;
          }

          public Searchability defaultSearchability() {
            return Searchability.no;
          }

          public int defaultDisplayOrder() {
            return 3;
          }

          public String defaultDescription() {
            return "A brief description of the table's function";
          }

          public int defaultWidth() {
            return 50;
          }

          public Object getRaw_unsafe(Persistent g)
              throws AccessPoemException {
            return ((TableInfo)g).getDescription_unsafe();
          }

          public void setRaw_unsafe(Persistent g, Object raw)
              throws AccessPoemException {
            ((TableInfo)g).setDescription_unsafe((String)raw);
          }

          public Object getRaw(Persistent g)
              throws AccessPoemException {
            return ((TableInfo)g).getDescription();
          }

          public void setRaw(Persistent g, Object raw)
              throws AccessPoemException {
            ((TableInfo)g).setDescription((String)raw);
          }
        });

    defineColumn(col_displayorder =
        new Column<Integer>(this, "displayorder",
                   new IntegerPoemType(false),
                   DefinitionSource.dsd) { 
          public Object getCooked(Persistent g)
              throws AccessPoemException, PoemException {
            return ((TableInfo)g).getDisplayorder();
          }

          public void setCooked(Persistent g, Object cooked)
              throws AccessPoemException, ValidationPoemException {
            ((TableInfo)g).setDisplayorder((Integer)cooked);
          }

          public Field<Integer> asField(Persistent g) {
            return ((TableInfo)g).getDisplayorderField();
          }

          public DisplayLevel defaultDisplayLevel() {
            return DisplayLevel.summary;
          }

          public Integer defaultDisplayOrderPriority() {
            return new Integer(0);
          }

          public String defaultDisplayName() {
            return "Display order";
          }

          public int defaultDisplayOrder() {
            return 4;
          }

          public String defaultDescription() {
            return "A rank determining where the table appears in the list of all tables";
          }

          public Object getRaw_unsafe(Persistent g)
              throws AccessPoemException {
            return ((TableInfo)g).getDisplayorder_unsafe();
          }

          public void setRaw_unsafe(Persistent g, Object raw)
              throws AccessPoemException {
            ((TableInfo)g).setDisplayorder_unsafe((Integer)raw);
          }

          public Object getRaw(Persistent g)
              throws AccessPoemException {
            return ((TableInfo)g).getDisplayorder();
          }

          public void setRaw(Persistent g, Object raw)
              throws AccessPoemException {
            ((TableInfo)g).setDisplayorder((Integer)raw);
          }
        });

    defineColumn(col_defaultcanread =
        new Column<Integer>(this, "defaultcanread",
                   new ReferencePoemType(getPoemDatabaseTables().
                                             getCapabilityTable(), true),
                   DefinitionSource.dsd) { 
          public Object getCooked(Persistent g)
              throws AccessPoemException, PoemException {
            return ((TableInfo)g).getDefaultcanread();
          }

          public void setCooked(Persistent g, Object cooked)
              throws AccessPoemException, ValidationPoemException {
            ((TableInfo)g).setDefaultcanread((Capability)cooked);
          }

          public Field<Integer> asField(Persistent g) {
            return ((TableInfo)g).getDefaultcanreadField();
          }

          public DisplayLevel defaultDisplayLevel() {
            return DisplayLevel.record;
          }

          public Searchability defaultSearchability() {
            return Searchability.no;
          }

          public String defaultDisplayName() {
            return "Default `read' capability";
          }

          public int defaultDisplayOrder() {
            return 5;
          }

          public String defaultDescription() {
            return "The capability required, by default, for reading the table's records";
          }

          public Object getRaw_unsafe(Persistent g)
              throws AccessPoemException {
            return ((TableInfo)g).getDefaultcanread_unsafe();
          }

          public void setRaw_unsafe(Persistent g, Object raw)
              throws AccessPoemException {
            ((TableInfo)g).setDefaultcanread_unsafe((Integer)raw);
          }

          public Object getRaw(Persistent g)
              throws AccessPoemException {
            return ((TableInfo)g).getDefaultcanreadTroid();
          }

          public void setRaw(Persistent g, Object raw)
              throws AccessPoemException {
            ((TableInfo)g).setDefaultcanreadTroid((Integer)raw);
          }

          public StandardIntegrityFix defaultIntegrityFix() {
            return StandardIntegrityFix.clear;
          }
        });

    defineColumn(col_defaultcanwrite =
        new Column<Integer>(this, "defaultcanwrite",
                   new ReferencePoemType(getPoemDatabaseTables().
                                             getCapabilityTable(), true),
                   DefinitionSource.dsd) { 
          public Object getCooked(Persistent g)
              throws AccessPoemException, PoemException {
            return ((TableInfo)g).getDefaultcanwrite();
          }

          public void setCooked(Persistent g, Object cooked)
              throws AccessPoemException, ValidationPoemException {
            ((TableInfo)g).setDefaultcanwrite((Capability)cooked);
          }

          public Field<Integer> asField(Persistent g) {
            return ((TableInfo)g).getDefaultcanwriteField();
          }

          public DisplayLevel defaultDisplayLevel() {
            return DisplayLevel.record;
          }

          public Searchability defaultSearchability() {
            return Searchability.no;
          }

          public String defaultDisplayName() {
            return "Default `write' capability";
          }

          public int defaultDisplayOrder() {
            return 6;
          }

          public String defaultDescription() {
            return "The capability required, by default, for updating the table's records";
          }

          public Object getRaw_unsafe(Persistent g)
              throws AccessPoemException {
            return ((TableInfo)g).getDefaultcanwrite_unsafe();
          }

          public void setRaw_unsafe(Persistent g, Object raw)
              throws AccessPoemException {
            ((TableInfo)g).setDefaultcanwrite_unsafe((Integer)raw);
          }

          public Object getRaw(Persistent g)
              throws AccessPoemException {
            return ((TableInfo)g).getDefaultcanwriteTroid();
          }

          public void setRaw(Persistent g, Object raw)
              throws AccessPoemException {
            ((TableInfo)g).setDefaultcanwriteTroid((Integer)raw);
          }

          public StandardIntegrityFix defaultIntegrityFix() {
            return StandardIntegrityFix.clear;
          }
        });

    defineColumn(col_defaultcandelete =
        new Column<Integer>(this, "defaultcandelete",
                   new ReferencePoemType(getPoemDatabaseTables().
                                             getCapabilityTable(), true),
                   DefinitionSource.dsd) { 
          public Object getCooked(Persistent g)
              throws AccessPoemException, PoemException {
            return ((TableInfo)g).getDefaultcandelete();
          }

          public void setCooked(Persistent g, Object cooked)
              throws AccessPoemException, ValidationPoemException {
            ((TableInfo)g).setDefaultcandelete((Capability)cooked);
          }

          public Field<Integer> asField(Persistent g) {
            return ((TableInfo)g).getDefaultcandeleteField();
          }

          public DisplayLevel defaultDisplayLevel() {
            return DisplayLevel.record;
          }

          public Searchability defaultSearchability() {
            return Searchability.no;
          }

          public String defaultDisplayName() {
            return "Default `delete' capability";
          }

          public int defaultDisplayOrder() {
            return 7;
          }

          public String defaultDescription() {
            return "The capability required, by default, for deleting the table's records";
          }

          public Object getRaw_unsafe(Persistent g)
              throws AccessPoemException {
            return ((TableInfo)g).getDefaultcandelete_unsafe();
          }

          public void setRaw_unsafe(Persistent g, Object raw)
              throws AccessPoemException {
            ((TableInfo)g).setDefaultcandelete_unsafe((Integer)raw);
          }

          public Object getRaw(Persistent g)
              throws AccessPoemException {
            return ((TableInfo)g).getDefaultcandeleteTroid();
          }

          public void setRaw(Persistent g, Object raw)
              throws AccessPoemException {
            ((TableInfo)g).setDefaultcandeleteTroid((Integer)raw);
          }

          public StandardIntegrityFix defaultIntegrityFix() {
            return StandardIntegrityFix.clear;
          }
        });

    defineColumn(col_cancreate =
        new Column<Integer>(this, "cancreate",
                   new ReferencePoemType(getPoemDatabaseTables().
                                             getCapabilityTable(), true),
                   DefinitionSource.dsd) { 
          public Object getCooked(Persistent g)
              throws AccessPoemException, PoemException {
            return ((TableInfo)g).getCancreate();
          }

          public void setCooked(Persistent g, Object cooked)
              throws AccessPoemException, ValidationPoemException {
            ((TableInfo)g).setCancreate((Capability)cooked);
          }

          public Field<Integer> asField(Persistent g) {
            return ((TableInfo)g).getCancreateField();
          }

          public DisplayLevel defaultDisplayLevel() {
            return DisplayLevel.record;
          }

          public Searchability defaultSearchability() {
            return Searchability.no;
          }

          public String defaultDisplayName() {
            return "Default `create' capability";
          }

          public int defaultDisplayOrder() {
            return 8;
          }

          public String defaultDescription() {
            return "The capability required, by default, for creating records in the table";
          }

          public Object getRaw_unsafe(Persistent g)
              throws AccessPoemException {
            return ((TableInfo)g).getCancreate_unsafe();
          }

          public void setRaw_unsafe(Persistent g, Object raw)
              throws AccessPoemException {
            ((TableInfo)g).setCancreate_unsafe((Integer)raw);
          }

          public Object getRaw(Persistent g)
              throws AccessPoemException {
            return ((TableInfo)g).getCancreateTroid();
          }

          public void setRaw(Persistent g, Object raw)
              throws AccessPoemException {
            ((TableInfo)g).setCancreateTroid((Integer)raw);
          }

          public StandardIntegrityFix defaultIntegrityFix() {
            return StandardIntegrityFix.clear;
          }
        });

    defineColumn(col_cachelimit =
        new Column<Integer>(this, "cachelimit",
                   new IntegerPoemType(true),
                   DefinitionSource.dsd) { 
          public Object getCooked(Persistent g)
              throws AccessPoemException, PoemException {
            return ((TableInfo)g).getCachelimit();
          }

          public void setCooked(Persistent g, Object cooked)
              throws AccessPoemException, ValidationPoemException {
            ((TableInfo)g).setCachelimit((Integer)cooked);
          }

          public Field<Integer> asField(Persistent g) {
            return ((TableInfo)g).getCachelimitField();
          }

          public DisplayLevel defaultDisplayLevel() {
            return DisplayLevel.record;
          }

          public Searchability defaultSearchability() {
            return Searchability.no;
          }

          public String defaultDisplayName() {
            return "Cache size limit";
          }

          public int defaultDisplayOrder() {
            return 9;
          }

          public String defaultDescription() {
            return "The maximum number of records from the table to keep in the cache";
          }

          public Object getRaw_unsafe(Persistent g)
              throws AccessPoemException {
            return ((TableInfo)g).getCachelimit_unsafe();
          }

          public void setRaw_unsafe(Persistent g, Object raw)
              throws AccessPoemException {
            ((TableInfo)g).setCachelimit_unsafe((Integer)raw);
          }

          public Object getRaw(Persistent g)
              throws AccessPoemException {
            return ((TableInfo)g).getCachelimit();
          }

          public void setRaw(Persistent g, Object raw)
              throws AccessPoemException {
            ((TableInfo)g).setCachelimit((Integer)raw);
          }
        });

    defineColumn(col_seqcached =
        new Column<Boolean>(this, "seqcached",
                   new BooleanPoemType(false),
                   DefinitionSource.dsd) { 
          public Object getCooked(Persistent g)
              throws AccessPoemException, PoemException {
            return ((TableInfo)g).getSeqcached();
          }

          public void setCooked(Persistent g, Object cooked)
              throws AccessPoemException, ValidationPoemException {
            ((TableInfo)g).setSeqcached((Boolean)cooked);
          }

          public Field<Boolean> asField(Persistent g) {
            return ((TableInfo)g).getSeqcachedField();
          }

          public DisplayLevel defaultDisplayLevel() {
            return DisplayLevel.record;
          }

          public Searchability defaultSearchability() {
            return Searchability.no;
          }

          public String defaultDisplayName() {
            return "Record sequence cached";
          }

          public int defaultDisplayOrder() {
            return 10;
          }

          public String defaultDescription() {
            return "Whether the display sequence for the table's records is cached";
          }

          public Object getRaw_unsafe(Persistent g)
              throws AccessPoemException {
            return ((TableInfo)g).getSeqcached_unsafe();
          }

          public void setRaw_unsafe(Persistent g, Object raw)
              throws AccessPoemException {
            ((TableInfo)g).setSeqcached_unsafe((Boolean)raw);
          }

          public Object getRaw(Persistent g)
              throws AccessPoemException {
            return ((TableInfo)g).getSeqcached();
          }

          public void setRaw(Persistent g, Object raw)
              throws AccessPoemException {
            ((TableInfo)g).setSeqcached((Boolean)raw);
          }
        });

    defineColumn(col_category =
        new Column<Integer>(this, "category",
                   new ReferencePoemType(getPoemDatabaseTables().
                                             getTableCategoryTable(), false),
                   DefinitionSource.dsd) { 
          public Object getCooked(Persistent g)
              throws AccessPoemException, PoemException {
            return ((TableInfo)g).getCategory();
          }

          public void setCooked(Persistent g, Object cooked)
              throws AccessPoemException, ValidationPoemException {
            ((TableInfo)g).setCategory((TableCategory)cooked);
          }

          public Field<Integer> asField(Persistent g) {
            return ((TableInfo)g).getCategoryField();
          }

          public DisplayLevel defaultDisplayLevel() {
            return DisplayLevel.record;
          }

          public Searchability defaultSearchability() {
            return Searchability.primary;
          }

          public int defaultDisplayOrder() {
            return 11;
          }

          public String defaultDescription() {
            return "Which category the table falls into";
          }

          public Object getRaw_unsafe(Persistent g)
              throws AccessPoemException {
            return ((TableInfo)g).getCategory_unsafe();
          }

          public void setRaw_unsafe(Persistent g, Object raw)
              throws AccessPoemException {
            ((TableInfo)g).setCategory_unsafe((Integer)raw);
          }

          public Object getRaw(Persistent g)
              throws AccessPoemException {
            return ((TableInfo)g).getCategoryTroid();
          }

          public void setRaw(Persistent g, Object raw)
              throws AccessPoemException {
            ((TableInfo)g).setCategoryTroid((Integer)raw);
          }
        });
  }


 /**
  * Retrieves the <code>Id</code> <code>Column</code> for this 
  * <code>tableInfo</code> <code>Table</code>.
  * 
  * see org.melati.poem.prepro.FieldDef#generateColAccessor 
  * @return the id <code>Column</code>
  */
  public final Column<Integer> getIdColumn() {
    return col_id;
  }


 /**
  * Retrieves the <code>Name</code> <code>Column</code> for this 
  * <code>tableInfo</code> <code>Table</code>.
  * 
  * see org.melati.poem.prepro.FieldDef#generateColAccessor 
  * @return the name <code>Column</code>
  */
  public final Column<String> getNameColumn() {
    return col_name;
  }


 /**
  * Retrieves the <code>Displayname</code> <code>Column</code> for this 
  * <code>tableInfo</code> <code>Table</code>.
  * 
  * see org.melati.poem.prepro.FieldDef#generateColAccessor 
  * @return the displayname <code>Column</code>
  */
  public final Column<String> getDisplaynameColumn() {
    return col_displayname;
  }


 /**
  * Retrieves the <code>Description</code> <code>Column</code> for this 
  * <code>tableInfo</code> <code>Table</code>.
  * 
  * see org.melati.poem.prepro.FieldDef#generateColAccessor 
  * @return the description <code>Column</code>
  */
  public final Column<String> getDescriptionColumn() {
    return col_description;
  }


 /**
  * Retrieves the <code>Displayorder</code> <code>Column</code> for this 
  * <code>tableInfo</code> <code>Table</code>.
  * 
  * see org.melati.poem.prepro.FieldDef#generateColAccessor 
  * @return the displayorder <code>Column</code>
  */
  public final Column<Integer> getDisplayorderColumn() {
    return col_displayorder;
  }


 /**
  * Retrieves the <code>Defaultcanread</code> <code>Column</code> for this 
  * <code>tableInfo</code> <code>Table</code>.
  * 
  * see org.melati.poem.prepro.FieldDef#generateColAccessor 
  * @return the defaultcanread <code>Column</code>
  */
  public final Column<Integer> getDefaultcanreadColumn() {
    return col_defaultcanread;
  }


 /**
  * Retrieves the <code>Defaultcanwrite</code> <code>Column</code> for this 
  * <code>tableInfo</code> <code>Table</code>.
  * 
  * see org.melati.poem.prepro.FieldDef#generateColAccessor 
  * @return the defaultcanwrite <code>Column</code>
  */
  public final Column<Integer> getDefaultcanwriteColumn() {
    return col_defaultcanwrite;
  }


 /**
  * Retrieves the <code>Defaultcandelete</code> <code>Column</code> for this 
  * <code>tableInfo</code> <code>Table</code>.
  * 
  * see org.melati.poem.prepro.FieldDef#generateColAccessor 
  * @return the defaultcandelete <code>Column</code>
  */
  public final Column<Integer> getDefaultcandeleteColumn() {
    return col_defaultcandelete;
  }


 /**
  * Retrieves the <code>Cancreate</code> <code>Column</code> for this 
  * <code>tableInfo</code> <code>Table</code>.
  * 
  * see org.melati.poem.prepro.FieldDef#generateColAccessor 
  * @return the cancreate <code>Column</code>
  */
  public final Column<Integer> getCancreateColumn() {
    return col_cancreate;
  }


 /**
  * Retrieves the <code>Cachelimit</code> <code>Column</code> for this 
  * <code>tableInfo</code> <code>Table</code>.
  * 
  * see org.melati.poem.prepro.FieldDef#generateColAccessor 
  * @return the cachelimit <code>Column</code>
  */
  public final Column<Integer> getCachelimitColumn() {
    return col_cachelimit;
  }


 /**
  * Retrieves the <code>Seqcached</code> <code>Column</code> for this 
  * <code>tableInfo</code> <code>Table</code>.
  * 
  * see org.melati.poem.prepro.FieldDef#generateColAccessor 
  * @return the seqcached <code>Column</code>
  */
  public final Column<Boolean> getSeqcachedColumn() {
    return col_seqcached;
  }


 /**
  * Retrieves the <code>Category</code> <code>Column</code> for this 
  * <code>tableInfo</code> <code>Table</code>.
  * 
  * see org.melati.poem.prepro.FieldDef#generateColAccessor 
  * @return the category <code>Column</code>
  */
  public final Column<Integer> getCategoryColumn() {
    return col_category;
  }


 /**
  * Retrieve the <code>TableInfo</code> as a <code>TableInfo</code>.
  *
  * See org.melati.poem.prepro.TableDef#generateTableBaseJava 
  * @param troid a Table Row Object ID
  * @return the <code>Persistent</code> identified by the <code>troid</code>
  */
  public TableInfo getTableInfoObject(Integer troid) {
    return (TableInfo)getObject(troid);
  }


 /**
  * Retrieve the <code>TableInfo</code> 
  * as a <code>TableInfo</code>.
  *
  * See org.melati.poem.prepro.TableDef#generateTableBaseJava 
  * @param troid a Table Row Object ID
  * @return the <code>Persistent</code> identified   */
  public TableInfo getTableInfoObject(int troid) {
    return (TableInfo)getObject(troid);
  }

  protected JdbcPersistent _newPersistent() {
    return new TableInfo();
  }
  public String defaultDisplayName() {
    return "Table";
  }

  public String defaultDescription() {
    return "Configuration information about a table in the database";
  }

  public boolean defaultRememberAllTroids() {
    return true;
  }

  public Integer defaultCacheLimit() {
    return new Integer(999999999);
  }

  public String defaultCategory() {
    return "System";
  }

  public int defaultDisplayOrder() {
    return 3010;
  }

  /**
   * @return a newly created or existing TableInfo
   **/
  public TableInfo ensure(String name, String displayname, Integer displayorder, Boolean seqcached, TableCategory category) {
    TableInfo p = (TableInfo)getNameColumn().firstWhereEq(name);
    if (p == null) {
      p = (TableInfo)newPersistent();
      p.setName(name);
      p.setDisplayname(displayname);
      p.setDisplayorder(displayorder);
      p.setSeqcached(seqcached);
      p.setCategory(category);
    }
    return (TableInfo)getNameColumn().ensure(p);
  }
}

