/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.test;

import java.util.Enumeration;
import org.melati.poem.BooleanPoemType;
import org.melati.poem.ParsingPoemException;
import org.melati.poem.SQLPoemType;
import org.melati.poem.test.SQLPoemTypeSpec;

public class NotNullableBooleanPoemTypeTest
extends SQLPoemTypeSpec<Boolean> {
    public NotNullableBooleanPoemTypeTest() {
    }

    public NotNullableBooleanPoemTypeTest(String name) {
        super(name);
    }

    @Override
    void setObjectUnderTest() {
        this.it = new BooleanPoemType(false);
    }

    @Override
    public void testRawOfString() {
        super.testRawOfString();
        NotNullableBooleanPoemTypeTest.assertEquals((Object)Boolean.TRUE, (Object)this.it.rawOfString("t"));
        NotNullableBooleanPoemTypeTest.assertEquals((Object)Boolean.TRUE, (Object)this.it.rawOfString("T"));
        NotNullableBooleanPoemTypeTest.assertEquals((Object)Boolean.TRUE, (Object)this.it.rawOfString("y"));
        NotNullableBooleanPoemTypeTest.assertEquals((Object)Boolean.TRUE, (Object)this.it.rawOfString("Y"));
        NotNullableBooleanPoemTypeTest.assertEquals((Object)Boolean.TRUE, (Object)this.it.rawOfString("1"));
        NotNullableBooleanPoemTypeTest.assertEquals((Object)Boolean.TRUE, (Object)this.it.rawOfString("true"));
        NotNullableBooleanPoemTypeTest.assertEquals((Object)Boolean.TRUE, (Object)this.it.rawOfString("yes"));
        NotNullableBooleanPoemTypeTest.assertEquals((Object)Boolean.FALSE, (Object)this.it.rawOfString("f"));
        NotNullableBooleanPoemTypeTest.assertEquals((Object)Boolean.FALSE, (Object)this.it.rawOfString("F"));
        NotNullableBooleanPoemTypeTest.assertEquals((Object)Boolean.FALSE, (Object)this.it.rawOfString("n"));
        NotNullableBooleanPoemTypeTest.assertEquals((Object)Boolean.FALSE, (Object)this.it.rawOfString("N"));
        NotNullableBooleanPoemTypeTest.assertEquals((Object)Boolean.FALSE, (Object)this.it.rawOfString("0"));
        NotNullableBooleanPoemTypeTest.assertEquals((Object)Boolean.FALSE, (Object)this.it.rawOfString("false"));
        NotNullableBooleanPoemTypeTest.assertEquals((Object)Boolean.FALSE, (Object)this.it.rawOfString("no"));
        try {
            this.it.rawOfString("9");
            NotNullableBooleanPoemTypeTest.fail((String)"Should have blown up");
        }
        catch (ParsingPoemException e2) {
            Object e2 = null;
        }
        try {
            this.it.rawOfString("frue");
            NotNullableBooleanPoemTypeTest.fail((String)"Should have blown up");
        }
        catch (ParsingPoemException e) {
            Object var1_4 = null;
        }
    }

    @Override
    public void testQuotedRaw() {
        NotNullableBooleanPoemTypeTest.assertEquals((String)"false", (String)((SQLPoemType)this.it).quotedRaw(((SQLPoemType)this.it).rawOfString(((SQLPoemType)this.it).sqlDefaultValue(this.getDb().getDbms()))));
    }

    @Override
    public void testPossibleRaws() {
        super.testPossibleRaws();
        Enumeration them = this.it.possibleRaws();
        int counter = 0;
        while (them.hasMoreElements()) {
            them.nextElement();
            ++counter;
        }
        if (this.it.getNullable()) {
            NotNullableBooleanPoemTypeTest.assertEquals((int)3, (int)counter);
        } else {
            NotNullableBooleanPoemTypeTest.assertEquals((int)2, (int)counter);
        }
    }

    @Override
    public void testGetRaw() {
        super.testGetRaw();
        Boolean nullable = this.getDb().getUserTable().getNameColumn().getColumnInfo().getNullable();
        NotNullableBooleanPoemTypeTest.assertEquals((Object)Boolean.FALSE, (Object)nullable);
    }

    @Override
    public void testSetRaw() {
        super.testSetRaw();
        Boolean nullable = this.getDb().getUserTable().getNameColumn().getColumnInfo().getNullable();
        NotNullableBooleanPoemTypeTest.assertEquals((Object)Boolean.FALSE, (Object)nullable);
        this.getDb().getUserTable().getNameColumn().getColumnInfo().setNullable(Boolean.TRUE);
        nullable = this.getDb().getUserTable().getNameColumn().getColumnInfo().getNullable();
        NotNullableBooleanPoemTypeTest.assertEquals((Object)Boolean.TRUE, (Object)nullable);
        this.getDb().getUserTable().getNameColumn().getColumnInfo().setNullable(Boolean.FALSE);
        nullable = this.getDb().getUserTable().getNameColumn().getColumnInfo().getNullable();
        NotNullableBooleanPoemTypeTest.assertEquals((Object)Boolean.FALSE, (Object)nullable);
        nullable = this.getDb().getUserTable().getNameColumn().getColumnInfo().getNullable();
        NotNullableBooleanPoemTypeTest.assertEquals((Object)Boolean.FALSE, (Object)nullable);
    }
}

