/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.test;

import java.util.Properties;
import org.melati.poem.Database;
import org.melati.poem.Persistent;
import org.melati.poem.PersistentFactory;
import org.melati.poem.PoemDatabaseFactory;
import org.melati.poem.User;
import org.melati.poem.test.PoemTestCase;
import org.melati.poem.test.pojo.ClassWithByteArrayMember;
import org.melati.poem.test.pojo.ClassWithId;
import org.melati.poem.test.pojo.ClassWithNoIdAndPrivateMembers;
import org.melati.poem.test.pojo.ClassWithNoIdAndPublicMembers;
import org.melati.poem.test.pojo.ClassWithStringId;

public class PersistentFactoryTest
extends PoemTestCase {
    public PersistentFactoryTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        this.getDb().disconnect();
        PoemDatabaseFactory.removeDatabase((String)this.getDatabaseName());
    }

    @Override
    protected void databaseUnchanged() {
        PersistentFactoryTest.assertEquals("Setting changed", 0, this.getDb().getSettingTable().count());
        PersistentFactoryTest.assertEquals("Group changed", 1, this.getDb().getGroupTable().count());
        PersistentFactoryTest.assertEquals("GroupMembership changed", 1, this.getDb().getGroupMembershipTable().count());
        PersistentFactoryTest.assertEquals("Capability changed", 5, this.getDb().getCapabilityTable().count());
        PersistentFactoryTest.assertEquals("GroupCapability changed", 1, this.getDb().getGroupCapabilityTable().count());
        PersistentFactoryTest.assertEquals("TableCategory changed", 3, this.getDb().getTableCategoryTable().count());
        PersistentFactoryTest.assertEquals("User changed", 2, this.getDb().getUserTable().count());
    }

    public void testFromKnownInstance() {
        PersistentFactoryTest.assertEquals((Object)this.getDb().getUserTable().administratorUser(), (Object)PersistentFactory.fromInstance((Database)this.getDb(), (Object)this.getDb().getUserTable().administratorUser()));
    }

    public void testFromFloatingPersistent() {
        User u = (User)this.getDb().getUserTable().newPersistent();
        u.setLogin("test");
        u.setName("Test");
        u.setPassword("test");
        User u2 = (User)PersistentFactory.fromInstance((Database)this.getDb(), (Object)u);
        PersistentFactoryTest.assertNotNull((Object)u2.getTroid());
        u2.delete();
    }

    public void testFromUnknownInstance() {
        if (!this.getDb().getDbms().canDropColumns()) {
            return;
        }
        ClassWithNoIdAndPublicMembers d1 = new ClassWithNoIdAndPublicMembers("Pepper");
        d1.setThoughts("Squirrels");
        ClassWithNoIdAndPublicMembers d2 = new ClassWithNoIdAndPublicMembers("Fido");
        d2.setThoughts("Food");
        d2.setClassWithNoIdAndPrivateMembers(new ClassWithNoIdAndPrivateMembers("Tiddles"));
        Persistent persistedDog2 = PersistentFactory.fromInstance((Database)this.getDb(), (Object)d2);
        PersistentFactoryTest.assertEquals((Object)"Food", (Object)persistedDog2.getRaw("thoughts"));
        PersistentFactoryTest.assertEquals((Object)"Tiddles", (Object)((Persistent)persistedDog2.getCooked("classWithNoIdAndPrivateMembers")).getRaw("name"));
        Persistent persistedDog3 = PersistentFactory.fromInstance((Database)this.getDb(), (Object)d2);
        PersistentFactoryTest.assertEquals((Object)"Food", (Object)persistedDog3.getRaw("thoughts"));
        PersistentFactoryTest.assertEquals((Object)"Tiddles", (Object)((Persistent)persistedDog3.getCooked("classWithNoIdAndPrivateMembers")).getRaw("name"));
        PersistentFactoryTest.assertTrue((boolean)persistedDog2.equals(persistedDog3));
    }

    public void testFrom() throws Exception {
        if (!this.getDb().getDbms().canDropColumns()) {
            return;
        }
        ClassWithNoIdAndPublicMembers pojo = new ClassWithNoIdAndPublicMembers("Fido");
        pojo.setThoughts("Food");
        pojo.setClassWithNoIdAndPrivateMembers(new ClassWithNoIdAndPrivateMembers("Tiddles"));
        Persistent persistedDog = PersistentFactory.fromInstance((Database)this.getDb(), (Object)pojo);
        ClassWithNoIdAndPublicMembers pojo2 = (ClassWithNoIdAndPublicMembers)PersistentFactory.from((Persistent)this.getDb().getTable("classWithNoIdAndPublicMembers").getObject(0), ClassWithNoIdAndPublicMembers.class);
        PersistentFactoryTest.assertEquals((Object)persistedDog, (Object)this.getDb().getTable("classWithNoIdAndPublicMembers").getObject(0));
        PersistentFactoryTest.assertEquals((String)pojo.getThoughts(), (String)pojo2.getThoughts());
        PersistentFactoryTest.assertEquals((String)pojo2.getClassWithNoIdAndPrivateMembers().getName(), (String)pojo.getClassWithNoIdAndPrivateMembers().getName());
        PersistentFactoryTest.assertEquals(pojo2.getClassWithNoIdAndPrivateMembers().getClass(), pojo.getClassWithNoIdAndPrivateMembers().getClass());
    }

    public void testFromBadInput() throws Exception {
        try {
            PersistentFactory.fromInstance((Database)this.getDb(), null);
            PersistentFactoryTest.fail((String)"Should have bombed");
        }
        catch (NullPointerException e2) {
            Object e2 = null;
        }
        ClassWithNoIdAndPublicMembers d = new ClassWithNoIdAndPublicMembers("Fido");
        try {
            PersistentFactory.fromInstance(null, (Object)d);
            PersistentFactoryTest.fail((String)"Should have bombed");
        }
        catch (NullPointerException e) {
            Object var2_4 = null;
        }
    }

    public void testPersistentFromPojoWithIdSet() throws Exception {
        if (!this.getDb().getDbms().canDropColumns()) {
            return;
        }
        ClassWithStringId pojo = new ClassWithStringId();
        pojo.setId("99");
        Persistent persisted = PersistentFactory.fromInstance((Database)this.getDb(), (Object)pojo);
        PersistentFactoryTest.assertEquals((Object)"99", (Object)persisted.getCooked("id"));
        ClassWithId withId = new ClassWithId();
        withId.setId(new Integer(99));
        persisted = PersistentFactory.fromInstance((Database)this.getDb(), (Object)withId);
        PersistentFactoryTest.assertEquals((Object)new Integer(0), (Object)persisted.getTroid());
        PersistentFactoryTest.assertEquals((Object)new Integer(0), (Object)persisted.getCooked("poemId"));
        PersistentFactoryTest.assertEquals((Object)new Integer(99), (Object)persisted.getCooked("id"));
    }

    public void testPersistentFromPojoWithBinaryField() {
        if (!this.getDb().getDbms().canDropColumns()) {
            return;
        }
        ClassWithByteArrayMember pojo = new ClassWithByteArrayMember();
        pojo.setBinaryField(new byte[]{34, 35, 36});
        Persistent persisted = PersistentFactory.fromInstance((Database)this.getDb(), (Object)pojo);
        PersistentFactoryTest.assertEquals((int)35, (int)((byte[])persisted.getCooked("binaryField"))[1]);
    }

    public void testPojoFromWrongPersistent() throws Exception {
        if (!this.getDb().getDbms().canDropColumns()) {
            return;
        }
        ClassWithNoIdAndPublicMembers pojo = new ClassWithNoIdAndPublicMembers("Fido");
        pojo.setThoughts("Food");
        Persistent persisted = PersistentFactory.fromInstance((Database)this.getDb(), (Object)pojo);
        try {
            PersistentFactory.from((Persistent)persisted, Properties.class);
            PersistentFactoryTest.fail((String)"Should have bombed");
        }
        catch (NoSuchMethodException e) {
            Object var3_4 = null;
        }
    }
}

