/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.csv;

import java.util.Vector;
import org.melati.poem.Persistent;
import org.melati.poem.PoemThread;
import org.melati.poem.Table;
import org.melati.poem.csv.CSVColumn;
import org.melati.poem.csv.CSVField;
import org.melati.poem.csv.CSVWriteDownException;
import org.melati.poem.csv.NoPrimaryKeyInCSVTableException;

public class CSVRecord {
    private Vector<CSVField> fields;
    String primaryKeyValue = null;
    Table<?> table = null;
    Persistent poemRecord = null;
    private int lineNo;
    private int recordNo;

    public CSVRecord(Table<?> table) {
        this.table = table;
        this.fields = new Vector();
    }

    public synchronized void addField(CSVField field) {
        if (field.column.isPrimaryKey) {
            this.primaryKeyValue = field.value;
        }
        this.fields.addElement(field);
    }

    private void createPersistent() throws NoPrimaryKeyInCSVTableException, CSVWriteDownException {
        if (this.poemRecord != null) {
            return;
        }
        Persistent newObj = this.table.newPersistent();
        for (int j = 0; j < this.fields.size(); ++j) {
            CSVColumn col = this.fields.elementAt((int)j).column;
            String csvValue = this.fields.elementAt((int)j).value;
            if (col.foreignTable == null) {
                if (col.poemName == null) continue;
                try {
                    if (csvValue == null || csvValue.equals("")) continue;
                    newObj.setRawString(col.poemName, csvValue);
                    continue;
                }
                catch (Exception e) {
                    throw new CSVWriteDownException(this.table.getName(), this.getLineNo(), new RuntimeException("Problem processing column " + col.poemName + " of table " + this.table.getName() + " on line " + this.getLineNo() + " value :" + csvValue + ": " + e.toString()));
                }
            }
            if (csvValue == null || csvValue.trim().equals("")) {
                if (newObj.getTable().getColumn(col.poemName).getColumnInfo().getNullable().booleanValue()) continue;
                throw new RuntimeException("CSV value missing for required column " + col.poemName + " of table " + this.table.getName() + " on line " + this.getLineNo());
            }
            Persistent lookup = col.foreignTable.getRecordWithID(csvValue);
            if (lookup == null) {
                throw new RuntimeException("No persistent found with primary key " + csvValue + " for column " + col.poemName + " of table " + this.table.getName() + " on line " + this.getLineNo());
            }
            newObj.setCooked(col.poemName, lookup);
        }
        this.poemRecord = newObj;
    }

    public Persistent getPersistent() throws NoPrimaryKeyInCSVTableException, CSVWriteDownException {
        if (this.poemRecord != null) {
            return this.poemRecord;
        }
        this.createPersistent();
        return this.poemRecord;
    }

    void makePersistent() throws NoPrimaryKeyInCSVTableException, CSVWriteDownException {
        try {
            this.getPersistent();
            this.poemRecord.makePersistent();
        }
        catch (NoPrimaryKeyInCSVTableException e1) {
            throw e1;
        }
        catch (CSVWriteDownException e2) {
            throw e2;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e.toString() + " in table " + this.table.getName() + " on line " + this.getLineNo());
        }
        if (PoemThread.inSession()) {
            PoemThread.writeDown();
        }
        PoemThread.commit();
    }

    public void setRecordNo(int recordNo) {
        this.recordNo = recordNo;
    }

    public int getRecordNo() {
        return this.recordNo;
    }

    public void setLineNo(int lineNo) {
        this.lineNo = lineNo;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public Vector<CSVField> getFields() {
        return this.fields;
    }
}

