/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.dbms.test;

import org.melati.poem.BigDecimalPoemType;
import org.melati.poem.BinaryPoemType;
import org.melati.poem.BooleanPoemType;
import org.melati.poem.DatePoemType;
import org.melati.poem.DoublePoemType;
import org.melati.poem.IntegerPoemType;
import org.melati.poem.LongPoemType;
import org.melati.poem.PoemType;
import org.melati.poem.StringPoemType;
import org.melati.poem.TimestampPoemType;
import org.melati.poem.dbms.DbmsFactory;
import org.melati.poem.dbms.test.DbmsSpec;

public class OracleTest
extends DbmsSpec {
    public OracleTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    protected void setObjectUnderTest() {
        this.it = DbmsFactory.getDbms((String)"org.melati.poem.dbms.Oracle");
    }

    @Override
    public void testGetStringSqlDefinition() throws Exception {
        OracleTest.assertEquals((String)"VARCHAR(0)", (String)this.it.getStringSqlDefinition(0));
        OracleTest.assertEquals((String)"CLOB", (String)this.it.getStringSqlDefinition(-1));
    }

    @Override
    public void testGetSqlDefinition() throws Exception {
        OracleTest.assertEquals((String)"CHAR(1)", (String)this.it.getSqlDefinition("BOOLEAN"));
        OracleTest.assertEquals((String)"DOUBLE PRECISION", (String)this.it.getSqlDefinition("DOUBLE PRECISION"));
        OracleTest.assertEquals((String)"INT8", (String)this.it.getSqlDefinition("INT8"));
        OracleTest.assertEquals((String)"Big Decimal", (String)this.it.getSqlDefinition("Big Decimal"));
    }

    @Override
    public void testGetLongSqlDefinition() {
        OracleTest.assertEquals((String)"NUMBER", (String)this.it.getLongSqlDefinition());
    }

    @Override
    public void testSqlBooleanValueOfRaw() {
        OracleTest.assertEquals((String)"0", (String)this.it.sqlBooleanValueOfRaw((Object)Boolean.FALSE));
        OracleTest.assertEquals((String)"1", (String)this.it.sqlBooleanValueOfRaw((Object)Boolean.TRUE));
    }

    @Override
    public void testGetBinarySqlDefinition() throws Exception {
        OracleTest.assertEquals((String)"BLOB", (String)this.it.getBinarySqlDefinition(0));
    }

    @Override
    public void testCanDropColumns() throws Exception {
        OracleTest.assertTrue((boolean)this.it.canDropColumns());
    }

    @Override
    public void testMelatiName() {
        OracleTest.assertEquals((String)"name", (String)this.it.melatiName("name"));
        OracleTest.assertEquals(null, (String)this.it.melatiName(null));
        OracleTest.assertEquals((String)"~special", (String)this.it.melatiName("~Special"));
    }

    @Override
    public void testUnreservedName() {
        OracleTest.assertEquals((String)"NAME", (String)this.it.unreservedName("name"));
    }

    @Override
    public void testCanRepresent() {
        OracleTest.assertNull((Object)this.it.canRepresent((PoemType)StringPoemType.nullableInstance, (PoemType)IntegerPoemType.nullableInstance));
        OracleTest.assertNull((Object)this.it.canRepresent((PoemType)IntegerPoemType.nullableInstance, (PoemType)StringPoemType.nullableInstance));
        OracleTest.assertNull((Object)this.it.canRepresent((PoemType)new BigDecimalPoemType(false), (PoemType)new BigDecimalPoemType(true)));
        OracleTest.assertTrue((boolean)(this.it.canRepresent((PoemType)new BigDecimalPoemType(true), (PoemType)new BigDecimalPoemType(false)) instanceof BigDecimalPoemType));
        OracleTest.assertNull((Object)this.it.canRepresent((PoemType)new StringPoemType(true, 255), (PoemType)new StringPoemType(true, -1)));
        OracleTest.assertTrue((boolean)(this.it.canRepresent((PoemType)new StringPoemType(true, -1), (PoemType)new StringPoemType(true, -1)) instanceof StringPoemType));
        OracleTest.assertNull((Object)this.it.canRepresent((PoemType)new TimestampPoemType(true), (PoemType)new DatePoemType(true)));
        OracleTest.assertTrue((boolean)(this.it.canRepresent((PoemType)new BooleanPoemType(true), (PoemType)new BooleanPoemType(false)) instanceof BooleanPoemType));
        OracleTest.assertNull((Object)this.it.canRepresent((PoemType)new DoublePoemType(false), (PoemType)new BigDecimalPoemType(true)));
        OracleTest.assertNull((Object)this.it.canRepresent((PoemType)new DoublePoemType(true), (PoemType)new BigDecimalPoemType(false)));
        OracleTest.assertNull((Object)this.it.canRepresent((PoemType)new IntegerPoemType(false), (PoemType)new LongPoemType(true)));
        OracleTest.assertTrue((boolean)(this.it.canRepresent((PoemType)new IntegerPoemType(true), (PoemType)new LongPoemType(false)) instanceof LongPoemType));
        OracleTest.assertTrue((boolean)(this.it.canRepresent((PoemType)new IntegerPoemType(true), (PoemType)new BigDecimalPoemType(false)) instanceof BigDecimalPoemType));
        OracleTest.assertNull((Object)this.it.canRepresent((PoemType)new BinaryPoemType(false, 10), (PoemType)new BinaryPoemType(true, 10)));
        OracleTest.assertNull((Object)this.it.canRepresent((PoemType)new BinaryPoemType(true, 10), (PoemType)new BinaryPoemType(true, 11)));
        OracleTest.assertTrue((boolean)(this.it.canRepresent((PoemType)new BinaryPoemType(true, -1), (PoemType)new BinaryPoemType(true, -1)) instanceof BinaryPoemType));
        OracleTest.assertTrue((boolean)(this.it.canRepresent((PoemType)new BinaryPoemType(true, 2500), (PoemType)new BinaryPoemType(true, 10)) instanceof BinaryPoemType));
    }

    @Override
    public void testGetForeignKeyDefinition() {
        OracleTest.assertEquals((String)" ADD (CONSTRAINT FK_test_user) FOREIGN KEY (\"MELATI_USER\") REFERENCES \"MELATI_USER\"(\"ID\") ON DELETE CASCADE", (String)this.it.getForeignKeyDefinition("test", "user", "user", "id", "delete"));
        OracleTest.assertEquals((String)" ADD (CONSTRAINT FK_test_user) FOREIGN KEY (\"MELATI_USER\") REFERENCES \"MELATI_USER\"(\"ID\") ON DELETE SET NULL", (String)this.it.getForeignKeyDefinition("test", "user", "user", "id", "clear"));
    }

    @Override
    public void testGetPrimaryKeyDefinition() {
        OracleTest.assertEquals((String)" ADD (CONSTRAINT PK_name PRIMARY KEY(\"NAME\"))", (String)this.it.getPrimaryKeyDefinition("name"));
    }
}

