/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.test;

import java.util.Enumeration;
import org.melati.poem.AppBugPoemException;
import org.melati.poem.CachedSelection;
import org.melati.poem.Column;
import org.melati.poem.DisplayLevel;
import org.melati.poem.Field;
import org.melati.poem.NullTypeMismatchPoemException;
import org.melati.poem.Persistent;
import org.melati.poem.Searchability;
import org.melati.poem.StandardIntegrityFix;
import org.melati.poem.TroidPoemType;
import org.melati.poem.User;
import org.melati.poem.test.PoemTestCase;
import org.melati.poem.util.EnumUtils;

public class ColumnTest
extends PoemTestCase {
    public ColumnTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testColumn() {
    }

    public void testGetDatabase() {
        ColumnTest.assertEquals((Object)this.getDb(), (Object)this.getDb().getUserTable().troidColumn().getDatabase());
    }

    public void testGetTable() {
        ColumnTest.assertEquals((Object)this.getDb().getUserTable(), (Object)this.getDb().getUserTable().troidColumn().getTable());
    }

    public void testGetName() {
        ColumnTest.assertEquals((String)"id", (String)this.getDb().getUserTable().troidColumn().getName());
    }

    public void testQuotedName() {
        ColumnTest.assertEquals((String)this.getDb().quotedName("id"), (String)this.getDb().getUserTable().troidColumn().quotedName());
    }

    public void testFullQuotedName() {
        ColumnTest.assertEquals((String)(this.getDb().quotedName("user") + "." + this.getDb().quotedName("id")), (String)this.getDb().getUserTable().troidColumn().fullQuotedName());
    }

    public void testGetDisplayName() {
        ColumnTest.assertEquals((String)"Id", (String)this.getDb().getUserTable().troidColumn().getDisplayName());
    }

    public void testGetDescription() {
        ColumnTest.assertEquals((String)"The Table Row Object ID", (String)this.getDb().getUserTable().troidColumn().getDescription());
    }

    public void testGetColumnInfo() {
        ColumnTest.assertEquals((String)"columnInfo/0", (String)this.getDb().getUserTable().troidColumn().getColumnInfo().toString());
    }

    public void testGetDisplayLevel() {
        ColumnTest.assertEquals((Object)DisplayLevel.detail, (Object)this.getDb().getUserTable().troidColumn().getDisplayLevel());
        ColumnTest.assertEquals((Object)DisplayLevel.primary, (Object)this.getDb().getUserTable().getColumn("name").getDisplayLevel());
        ColumnTest.assertEquals((Object)DisplayLevel.summary, (Object)this.getDb().getUserTable().getColumn("login").getDisplayLevel());
    }

    public void testSetDisplayLevel() {
        ColumnTest.assertEquals((Object)DisplayLevel.summary, (Object)this.getDb().getUserTable().getColumn("login").getDisplayLevel());
        this.getDb().getUserTable().getColumn("login").setDisplayLevel(DisplayLevel.detail);
        ColumnTest.assertEquals((Object)DisplayLevel.detail, (Object)this.getDb().getUserTable().getColumn("login").getDisplayLevel());
        this.getDb().getUserTable().getColumn("login").setDisplayLevel(DisplayLevel.summary);
        ColumnTest.assertEquals((Object)DisplayLevel.summary, (Object)this.getDb().getUserTable().getColumn("login").getDisplayLevel());
    }

    public void testGetSearchability() {
        ColumnTest.assertEquals((Object)Searchability.yes, (Object)this.getDb().getUserTable().troidColumn().getSearchability());
        ColumnTest.assertEquals((Object)Searchability.primary, (Object)this.getDb().getUserTable().getColumn("name").getSearchability());
        ColumnTest.assertEquals((Object)Searchability.yes, (Object)this.getDb().getUserTable().getColumn("login").getSearchability());
        ColumnTest.assertEquals((Object)Searchability.no, (Object)this.getDb().getUserTable().getColumn("password").getSearchability());
    }

    public void testSetSearchability() {
        ColumnTest.assertEquals((Object)Searchability.yes, (Object)this.getDb().getUserTable().getColumn("login").getSearchability());
        this.getDb().getUserTable().getColumn("login").setSearchability(Searchability.no);
        ColumnTest.assertEquals((Object)Searchability.no, (Object)this.getDb().getUserTable().getColumn("login").getSearchability());
        this.getDb().getUserTable().getColumn("login").setSearchability(Searchability.yes);
        ColumnTest.assertEquals((Object)Searchability.yes, (Object)this.getDb().getUserTable().getColumn("login").getSearchability());
    }

    public void testGetUserEditable() {
    }

    public void testGetUserCreateable() {
    }

    public void testGetSQLType() {
    }

    public void testGetType() {
    }

    public void testIsTroidColumn() {
    }

    public void testIsDeletedColumn() {
    }

    public void testGetIndexed() {
    }

    public void testGetUnique() {
    }

    public void testGetIntegrityFix() {
        ColumnTest.assertEquals((Object)StandardIntegrityFix.prevent, (Object)this.getDb().getUserTable().troidColumn().getIntegrityFix());
    }

    public void testSetIntegrityFix() {
        ColumnTest.assertEquals((Object)StandardIntegrityFix.prevent, (Object)this.getDb().getUserTable().troidColumn().getIntegrityFix());
        this.getDb().getUserTable().troidColumn().setIntegrityFix(StandardIntegrityFix.delete);
        ColumnTest.assertEquals((Object)StandardIntegrityFix.delete, (Object)this.getDb().getUserTable().troidColumn().getIntegrityFix());
        this.getDb().getUserTable().troidColumn().setIntegrityFix(StandardIntegrityFix.prevent);
        ColumnTest.assertEquals((Object)StandardIntegrityFix.prevent, (Object)this.getDb().getUserTable().troidColumn().getIntegrityFix());
    }

    public void testGetRenderInfo() {
    }

    public void testGetWidth() {
    }

    public void testGetHeight() {
    }

    public void testGetDisplayOrderPriority() {
    }

    public void testGetSortDescending() {
    }

    public void testToString() {
    }

    public void testDump() {
        this.getDb().getUserTable().troidColumn().dump();
    }

    public void testEqClause() {
        ColumnTest.assertEquals((String)(this.getDb().getDbms().getQuotedName("user") + "." + this.getDb().getDbms().getQuotedName("id") + " IS NULL"), (String)this.getDb().getUserTable().troidColumn().eqClause(null));
        ColumnTest.assertEquals((String)(this.getDb().getDbms().getQuotedName("user") + "." + this.getDb().getDbms().getQuotedName("id") + " = 1"), (String)this.getDb().getUserTable().troidColumn().eqClause((Object)new Integer(1)));
    }

    public void testSelectionWhereEq() {
        if (this.getDb().getDbms().canDropColumns()) {
            ColumnTest.assertEquals((Object)new Integer(69), (Object)new Integer(EnumUtils.vectorOf((Enumeration)this.getDb().getColumnInfoTable().getHeightColumn().selectionWhereEq((Object)new Integer(1))).size()));
        }
        try {
            this.getDb().getColumnInfoTable().getHeightColumn().selectionWhereEq(null);
            ColumnTest.fail((String)"Should have bombed");
        }
        catch (NullTypeMismatchPoemException e) {
            Object var1_2 = null;
        }
    }

    public void testFirstWhereEq() {
        ColumnTest.assertNull((Object)this.getDb().getColumnInfoTable().getHeightColumn().firstWhereEq((Object)new Integer(0)));
        ColumnTest.assertNull((Object)this.getDb().getColumnInfoTable().getHeightColumn().firstWhereEq((Object)new Integer(2)));
        ColumnTest.assertEquals((String)"columnInfo/0", (String)this.getDb().getColumnInfoTable().getHeightColumn().firstWhereEq((Object)new Integer(1)).toString());
    }

    public void testCachedSelectionWhereEq() {
        CachedSelection cs = this.getDb().getColumnInfoTable().getHeightColumn().cachedSelectionWhereEq((Object)new Integer(1));
        if (this.getDb().getDbms().canDropColumns()) {
            ColumnTest.assertEquals((int)69, (int)cs.count());
        }
        int queries = this.getDb().getQueryCount();
        if (this.getDb().getDbms().canDropColumns()) {
            ColumnTest.assertEquals((int)69, (int)cs.count());
        }
        int queries2 = this.getDb().getQueryCount();
        if (this.getDb().getDbms().canDropColumns()) {
            ColumnTest.assertEquals((int)queries, (int)queries2);
        }
        int queries3 = this.getDb().getQueryCount();
        if (this.getDb().getDbms().canDropColumns()) {
            ColumnTest.assertEquals((int)queries2, (int)queries3);
        }
    }

    public void testGetRaw() {
    }

    public void testGetRaw_unsafe() {
    }

    public void testSetRaw() {
    }

    public void testSetRaw_unsafe() {
    }

    public void testGetCooked() {
    }

    public void testSetCooked() {
    }

    public void testLoad_unsafe() {
    }

    public void testSave_unsafe() {
    }

    public void testAsEmptyField() {
        Field f = this.getDb().getUserTable().troidColumn().asEmptyField();
        ColumnTest.assertEquals((String)"id", (String)f.getName());
        ColumnTest.assertEquals((String)"Id", (String)f.getDisplayName());
        ColumnTest.assertEquals((String)"The Table Row Object ID", (String)f.getDescription());
        ColumnTest.assertEquals((int)1, (int)f.getHeight());
        ColumnTest.assertEquals((int)20, (int)f.getWidth());
        ColumnTest.assertNull((Object)f.getRaw());
        try {
            f.getCooked();
            ColumnTest.fail((String)"Should have bombed");
        }
        catch (NullTypeMismatchPoemException e) {
            Object var2_3 = null;
        }
        ColumnTest.assertTrue((boolean)f.getIndexed());
        ColumnTest.assertFalse((boolean)f.getUserEditable());
        ColumnTest.assertFalse((boolean)f.getUserCreateable());
        ColumnTest.assertNull((Object)f.getRenderInfo());
        ColumnTest.assertTrue((boolean)(f.getType() instanceof TroidPoemType));
    }

    public void testSetRawString() {
        User admin = this.getDb().getUserTable().administratorUser();
        try {
            this.getDb().getUserTable().troidColumn().setRawString((Persistent)admin, "one");
            ColumnTest.fail((String)"Should have bombed");
        }
        catch (Column.SettingException e) {
            Object var2_3 = null;
        }
        this.getDb().getUserTable().getNameColumn().setRawString((Persistent)admin, "Admin");
        ColumnTest.assertEquals((String)"Admin", (String)admin.getName());
        this.getDb().getUserTable().getNameColumn().setRawString((Persistent)admin, "Melati database administrator");
    }

    public void testReferencesTo() {
        Column userTroidColumn = this.getDb().getUserTable().troidColumn();
        User admin = this.getDb().getUserTable().administratorUser();
        ColumnTest.assertEquals((String)"", (String)EnumUtils.concatenated((String)"|", (Enumeration)userTroidColumn.referencesTo((Persistent)admin)));
        Column userColumn = this.getDb().getGroupMembershipTable().getUserColumn();
        ColumnTest.assertEquals((String)"groupMembership/0", (String)EnumUtils.concatenated((String)"|", (Enumeration)userColumn.referencesTo((Persistent)admin)));
    }

    public void testEnsure() {
        User fred = (User)this.getDb().getUserTable().newPersistent();
        fred.setName("Fred");
        fred.setLogin("fred");
        fred.setPassword("fred");
        Column userNameColumn = this.getDb().getUserTable().getColumn("name");
        User ensured = (User)userNameColumn.ensure((Persistent)fred);
        ColumnTest.assertEquals((String)"Fred", (String)ensured.getName());
        fred.delete();
    }

    public void testFirstFree() {
        Column userTroidColumn = this.getDb().getUserTable().troidColumn();
        ColumnTest.assertEquals((int)2, (int)userTroidColumn.firstFree(null));
        try {
            Column userNameColumn = this.getDb().getUserTable().getColumn("name");
            userNameColumn.firstFree(null);
            ColumnTest.fail((String)"Should have bombed");
        }
        catch (AppBugPoemException e) {
            Object var2_4 = null;
        }
        ColumnTest.assertEquals((int)0, (int)userTroidColumn.firstFree("ID > 1"));
        ColumnTest.assertEquals((int)1, (int)userTroidColumn.firstFree("ID < 1"));
    }
}

