/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import org.melati.poem.AccessPoemException;
import org.melati.poem.ColumnInfo;
import org.melati.poem.NotComparablePoemException;
import org.melati.poem.NullTypeMismatchPoemException;
import org.melati.poem.OutsideRangePoemException;
import org.melati.poem.ParsingPoemException;
import org.melati.poem.PoemBugPoemException;
import org.melati.poem.PoemException;
import org.melati.poem.PoemLocale;
import org.melati.poem.PoemType;
import org.melati.poem.SQLPoemType;
import org.melati.poem.SQLSeriousPoemException;
import org.melati.poem.UnexpectedValidationPoemException;
import org.melati.poem.ValidationPoemException;
import org.melati.poem.dbms.Dbms;
import org.melati.poem.util.ConsEnumeration;

public abstract class BasePoemType<T>
implements SQLPoemType<T>,
Cloneable {
    private int sqlTypeCode;
    protected boolean nullable;
    private Comparable<T> low = null;
    private Comparable<T> limit = null;

    BasePoemType(int sqlTypeCode, boolean nullable) {
        this.sqlTypeCode = sqlTypeCode;
        this.nullable = nullable;
    }

    public void setRawRange(Comparable<T> low, Comparable<T> limit) {
        this.low = low;
        this.limit = limit;
    }

    protected Comparable<T> getLowRaw() {
        return this.low;
    }

    protected Comparable<T> getLimitRaw() {
        return this.limit;
    }

    protected abstract void _assertValidRaw(Object var1) throws ValidationPoemException;

    private void assertRawInRange(Object raw) {
        try {
            Object asComparable = raw;
            if (this.low != null && this.low.compareTo(asComparable) > 0 || this.limit != null && this.limit.compareTo(asComparable) <= 0) {
                throw new ValidationPoemException(this, raw, new OutsideRangePoemException(this.low, this.limit, raw));
            }
        }
        catch (ClassCastException e) {
            throw new NotComparablePoemException(raw, this);
        }
    }

    @Override
    public final void assertValidRaw(Object raw) throws ValidationPoemException {
        if (raw == null) {
            if (!this.nullable) {
                throw new NullTypeMismatchPoemException(this);
            }
        } else {
            if (this.low != null || this.limit != null) {
                this.assertRawInRange(raw);
            }
            this._assertValidRaw(raw);
        }
    }

    private void doubleCheckValidRaw(Object raw) {
        try {
            this.assertValidRaw(raw);
        }
        catch (ValidationPoemException e) {
            throw new UnexpectedValidationPoemException(e);
        }
    }

    protected abstract T _getRaw(ResultSet var1, int var2) throws SQLException;

    @Override
    public final T getRaw(ResultSet rs, int col) throws ValidationPoemException {
        T o;
        try {
            o = this._getRaw(rs, col);
        }
        catch (SQLException e) {
            throw new SQLSeriousPoemException(e);
        }
        this.assertValidRaw(o);
        return o;
    }

    protected abstract void _setRaw(PreparedStatement var1, int var2, Object var3) throws SQLException;

    @Override
    public final void setRaw(PreparedStatement ps, int col, Object raw) {
        this.doubleCheckValidRaw(raw);
        try {
            if (raw == null) {
                ps.setNull(col, this.sqlTypeCode());
            } else {
                this._setRaw(ps, col, raw);
            }
        }
        catch (SQLException e) {
            throw new SQLSeriousPoemException(e);
        }
    }

    protected Enumeration<T> _possibleRaws() {
        return null;
    }

    @Override
    public Enumeration<T> possibleRaws() {
        ConsEnumeration<Object> them = this._possibleRaws();
        return them == null ? null : (this.getNullable() ? new ConsEnumeration<Object>(null, them) : them);
    }

    protected abstract String _stringOfRaw(Object var1);

    @Override
    public final String stringOfRaw(Object raw) throws ValidationPoemException {
        return raw == null ? null : this._stringOfRaw(raw);
    }

    protected abstract T _rawOfString(String var1) throws ParsingPoemException;

    @Override
    public final T rawOfString(String string) throws ParsingPoemException, ValidationPoemException {
        T raw = string == null ? null : (T)this._rawOfString(string);
        this.assertValidRaw(raw);
        return raw;
    }

    protected abstract void _assertValidCooked(Object var1) throws ValidationPoemException;

    @Override
    public final void assertValidCooked(Object cooked) throws ValidationPoemException {
        if (cooked == null) {
            if (!this.nullable) {
                throw new NullTypeMismatchPoemException(this);
            }
        } else {
            this._assertValidCooked(cooked);
            if (this.low != null || this.limit != null) {
                this.assertRawInRange(this._rawOfCooked(cooked));
            }
        }
    }

    final void doubleCheckValidCooked(Object cooked) {
        try {
            this.assertValidCooked(cooked);
        }
        catch (ValidationPoemException e) {
            throw new UnexpectedValidationPoemException(e);
        }
    }

    protected abstract Object _cookedOfRaw(Object var1) throws PoemException;

    @Override
    public final Object cookedOfRaw(Object raw) throws PoemException {
        this.doubleCheckValidRaw(raw);
        return raw == null ? null : this._cookedOfRaw(raw);
    }

    protected abstract T _rawOfCooked(Object var1) throws PoemException;

    @Override
    public final T rawOfCooked(Object cooked) {
        this.doubleCheckValidCooked(cooked);
        return cooked == null ? null : (T)this._rawOfCooked(cooked);
    }

    protected abstract String _stringOfCooked(Object var1, PoemLocale var2, int var3) throws PoemException;

    @Override
    public final String stringOfCooked(Object cooked, PoemLocale locale, int style) throws PoemException {
        this.doubleCheckValidCooked(cooked);
        return cooked == null ? "" : this._stringOfCooked(cooked, locale, style);
    }

    @Override
    public final boolean getNullable() {
        return this.nullable;
    }

    @Override
    public final int sqlTypeCode() {
        return this.sqlTypeCode;
    }

    protected abstract String _sqlDefinition(Dbms var1);

    @Override
    public String sqlDefinition(Dbms dbms) {
        return this.sqlTypeDefinition(dbms) + (this.nullable ? " NULL" : " NOT NULL");
    }

    @Override
    public String sqlTypeDefinition(Dbms dbms) {
        return this._sqlDefinition(dbms);
    }

    protected abstract boolean _canRepresent(SQLPoemType<?> var1);

    @Override
    public <O> PoemType<O> canRepresent(PoemType<O> other) {
        if (!(other instanceof SQLPoemType)) {
            return null;
        }
        SQLPoemType q = (SQLPoemType)other;
        return (this.nullable || !q.getNullable()) && this._canRepresent(q) ? q : null;
    }

    @Override
    public final PoemType<T> withNullable(boolean nullableP) {
        if (this.nullable == nullableP) {
            return this;
        }
        BasePoemType it = (BasePoemType)this.clone();
        it.nullable = nullableP;
        return it;
    }

    protected abstract void _saveColumnInfo(ColumnInfo var1) throws AccessPoemException;

    @Override
    public void saveColumnInfo(ColumnInfo info) throws AccessPoemException {
        info.setNullable(this.nullable);
        info.setSize(0);
        info.setRangelow_string(this.getLowRaw() == null ? null : this.stringOfRaw(this.getLowRaw()));
        info.setRangelimit_string(this.getLimitRaw() == null ? null : this.stringOfRaw(this.getLimitRaw()));
        this._saveColumnInfo(info);
    }

    protected abstract String _quotedRaw(Object var1);

    @Override
    public String quotedRaw(Object raw) throws ValidationPoemException {
        this.assertValidRaw(raw);
        return raw == null ? "NULL" : this._quotedRaw(raw);
    }

    protected abstract String _toString();

    public String toString() {
        return (this.nullable ? "nullable " : "") + this._toString() + " (" + this.getClass().getName() + ")";
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new PoemBugPoemException();
        }
    }
}

