/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.dbms;

import java.sql.SQLException;
import org.melati.poem.Column;
import org.melati.poem.ExecutingSQLPoemException;
import org.melati.poem.Table;

public class DuplicateKeySQLPoemException
extends ExecutingSQLPoemException {
    private static final long serialVersionUID = 1L;
    public String table;
    public String column;
    public boolean insert;

    public DuplicateKeySQLPoemException(Table<?> table, String sql, boolean insert, SQLException e) {
        super(sql, e);
        if (table != null) {
            try {
                this.table = table.getDisplayName();
            }
            catch (Exception f) {
                this.table = table.getName();
            }
        }
        this.column = null;
        this.insert = insert;
    }

    public DuplicateKeySQLPoemException(Column<?> column, String sql, boolean insert, SQLException e) {
        super(sql, e);
        if (column != null) {
            try {
                this.table = column.getTable().getDisplayName();
            }
            catch (Exception f) {
                this.table = column.getTable().getName();
            }
            try {
                this.column = column.getDisplayName();
            }
            catch (Exception f) {
                this.column = column.getName();
            }
        }
        this.insert = insert;
    }

    public final String getTable() {
        return this.table;
    }

    public final String getColumn() {
        return this.column;
    }

    public final boolean getWasInsert() {
        return this.insert;
    }

    @Override
    public String getMessage() {
        String quant;
        String string = quant = this.insert ? "an existing" : "another";
        if (this.column == null) {
            String desc = this.table == null ? "record" : this.table;
            return "Unable to create " + desc + ": one or more fields clashed with " + quant + " " + desc;
        }
        return "The " + this.table + "'s " + this.column + " clashes with that of " + quant + " " + this.table;
    }
}

