/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.test.throwing;

import java.sql.Connection;
import java.sql.PreparedStatement;
import org.melati.poem.Database;
import org.melati.poem.Persistent;
import org.melati.poem.PoemDatabaseFactory;
import org.melati.poem.PoemThread;
import org.melati.poem.SQLSeriousPoemException;
import org.melati.poem.User;
import org.melati.poem.dbms.test.sql.Thrower;

public class PoemTransactionTest
extends org.melati.poem.test.PoemTransactionTest {
    public PoemTransactionTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        PoemDatabaseFactory.removeDatabase((String)this.getDatabaseName());
        super.setUp();
        PoemTransactionTest.assertEquals((String)"org.melati.poem.dbms.test.HsqldbThrower", (String)this.getDb().getDbms().getClass().getName());
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            super.tearDown();
        }
        finally {
            PoemDatabaseFactory.removeDatabase((String)this.getDatabaseName());
        }
    }

    @Override
    public Database getDatabase(String name) {
        this.maxTrans = 8;
        Database db = PoemDatabaseFactory.getDatabase((String)name, (String)("jdbc:hsqldb:mem:" + name), (String)"sa", (String)"", (String)"org.melati.poem.PoemDatabase", (String)"org.melati.poem.dbms.test.HsqldbThrower", (boolean)false, (boolean)false, (boolean)false, (int)this.maxTrans);
        return db;
    }

    @Override
    public void testClose() {
        Thrower.startThrowing(PreparedStatement.class, (String)"executeQuery");
        super.testClose();
        Thrower.stopThrowing(PreparedStatement.class, (String)"executeQuery");
    }

    @Override
    public void testCommit() {
        Thrower.startThrowing(Connection.class, (String)"commit");
        try {
            super.testCommit();
            PoemTransactionTest.fail((String)"Should have bombed");
        }
        catch (SQLSeriousPoemException e) {
            PoemTransactionTest.assertEquals((String)"Connection bombed", (String)e.innermostException().getMessage());
        }
        Thrower.stopThrowing(Connection.class, (String)"commit");
    }

    @Override
    public void testGetBlockedOn() {
    }

    @Override
    public void testGetDatabase() {
    }

    @Override
    public void testPoemTransaction() {
        Thrower.startThrowing(Connection.class, (String)"setAutoCommit");
        try {
            super.testPoemTransaction();
            PoemTransactionTest.fail((String)"Should have bombed");
        }
        catch (SQLSeriousPoemException e) {
            PoemTransactionTest.assertEquals((String)"Connection bombed", (String)e.innermostException().getMessage());
        }
        Thrower.stopThrowing(Connection.class, (String)"setAutoCommit");
    }

    @Override
    public void testRollback() {
        Thrower.startThrowing(Connection.class, (String)"rollback");
        User u = new User("tester", "tester", "tester");
        try {
            this.getDb().getUserTable().create((Persistent)u);
            PoemTransactionTest.assertEquals((String)"tester", (String)u.getName());
            u.setName("tester2");
            PoemThread.rollback();
            PoemTransactionTest.fail((String)"Should have bombed");
        }
        catch (SQLSeriousPoemException e) {
            PoemTransactionTest.assertEquals((String)"Connection bombed", (String)e.innermostException().getMessage());
        }
        Thrower.stopThrowing(Connection.class, (String)"rollback");
        u.delete();
    }

    @Override
    public void testToString() {
    }

    @Override
    public void testWriteDown() {
    }
}

