/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.melati.poem.AccessPoemException;
import org.melati.poem.AccessToken;
import org.melati.poem.Capability;
import org.melati.poem.Column;
import org.melati.poem.Field;
import org.melati.poem.FieldSet;
import org.melati.poem.NoSuchRowPoemException;
import org.melati.poem.PoemThread;
import org.melati.poem.ResultSetEnumeration;
import org.melati.poem.TailoredQuery;

public class TailoredResultSetEnumeration<T>
extends ResultSetEnumeration<T> {
    protected TailoredQuery query;

    public TailoredResultSetEnumeration(TailoredQuery query, ResultSet resultSet) {
        super(resultSet);
        this.query = query;
    }

    void checkTableAccess() {
        AccessToken token = PoemThread.accessToken();
        for (int t = 0; t < this.query.tablesWithoutCanReadColumn.length; ++t) {
            Capability canRead = this.query.tablesWithoutCanReadColumn[t].getDefaultCanRead();
            if (canRead == null || token.givesCapability(canRead)) continue;
            throw new AccessPoemException(token, canRead);
        }
    }

    Object column(ResultSet them, int c) {
        Column<?> column = this.query.columns[c];
        Object raw = column.getSQLType().getRaw(them, c + 1);
        if (this.query.isCanReadColumn[c]) {
            AccessToken token;
            Capability canRead = (Capability)column.getType().cookedOfRaw(raw);
            if (canRead == null) {
                canRead = column.getTable().getDefaultCanRead();
            }
            if (canRead != null && !(token = PoemThread.accessToken()).givesCapability(canRead)) {
                throw new AccessPoemException(token, canRead);
            }
        }
        return raw;
    }

    @Override
    protected Object mapped(ResultSet them) throws SQLException, NoSuchRowPoemException {
        this.checkTableAccess();
        Field[] fields = new Field[this.query.columns.length];
        try {
            for (int c = 0; c < fields.length; ++c) {
                fields[c] = new Field(this.column(them, c), this.query.columns[c]);
            }
        }
        catch (AccessPoemException accessProblem) {
            for (int c = 0; c < fields.length; ++c) {
                fields[c] = new Field(accessProblem, this.query.columns[c]);
            }
        }
        return new FieldSet(this.query.table_columnMap, fields);
    }
}

