/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.dbms;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.melati.poem.BigDecimalPoemType;
import org.melati.poem.BinaryPoemType;
import org.melati.poem.BooleanPoemType;
import org.melati.poem.Column;
import org.melati.poem.DatePoemType;
import org.melati.poem.DoublePoemType;
import org.melati.poem.IntegerPoemType;
import org.melati.poem.LongPoemType;
import org.melati.poem.PoemType;
import org.melati.poem.SQLPoemType;
import org.melati.poem.SQLType;
import org.melati.poem.StringPoemType;
import org.melati.poem.TimestampPoemType;
import org.melati.poem.dbms.AnsiStandard;
import org.melati.poem.dbms.SQLServer;
import org.melati.poem.util.StringUtils;

public class MSAccess
extends AnsiStandard {
    public static final int msAccessTextHack = 250;
    public static final int msAccessMemoSize = 0x3FFFFFFF;
    public static final int msAccessBinarySize = 510;

    public MSAccess() {
        this.setDriverClassName("sun.jdbc.odbc.JdbcOdbcDriver");
    }

    @Override
    public boolean canDropColumns() {
        return false;
    }

    @Override
    public boolean canStoreBlobs() {
        return false;
    }

    @Override
    public void shutdown(Connection connection) throws SQLException {
        connection.commit();
    }

    @Override
    public String unreservedName(String name) {
        if (name.equalsIgnoreCase("GROUP")) {
            name = "MELATI_" + name.toUpperCase();
        }
        if (name.equalsIgnoreCase("USER")) {
            name = "MELATI_" + name.toUpperCase();
        }
        return name;
    }

    @Override
    public String melatiName(String name) {
        if (name == null) {
            return name;
        }
        if (name.startsWith("~")) {
            return null;
        }
        if (name.equalsIgnoreCase("MELATI_GROUP")) {
            name = "group";
        }
        if (name.equalsIgnoreCase("MELATI_USER")) {
            name = "user";
        }
        return name;
    }

    @Override
    public String getSqlDefinition(String sqlTypeName) {
        if (sqlTypeName.equals("BOOLEAN")) {
            return "BIT";
        }
        if (sqlTypeName.equals("DOUBLE PRECISION")) {
            return "DOUBLE";
        }
        if (sqlTypeName.equals("INT8")) {
            return "INTEGER";
        }
        if (sqlTypeName.equals("Big Decimal")) {
            return "NUMERIC";
        }
        return super.getSqlDefinition(sqlTypeName);
    }

    @Override
    public String getLongSqlDefinition() {
        return "INTEGER";
    }

    @Override
    public String getStringSqlDefinition(int size) throws SQLException {
        if (size < 0) {
            return "VARCHAR(250)";
        }
        return super.getStringSqlDefinition(size);
    }

    @Override
    public String getFixedPtSqlDefinition(int scale, int precision) throws SQLException {
        if (scale < 0 || precision <= 0) {
            throw new SQLException("negative scale or nonpositive precision not supported in AnsiStandard DECIMALs");
        }
        return "NUMERIC";
    }

    @Override
    public String getBinarySqlDefinition(int size) throws SQLException {
        if (size < 0) {
            return "BINARY";
        }
        return "BINARY(" + size + ")";
    }

    @Override
    public String sqlBooleanValueOfRaw(Object raw) {
        if (((Boolean)raw).booleanValue()) {
            return "1";
        }
        return "0";
    }

    @Override
    public <S, O> PoemType<O> canRepresent(PoemType<S> storage, PoemType<O> type) {
        if (storage instanceof StringPoemType && type instanceof StringPoemType) {
            if (((StringPoemType)storage).getSize() == 250 && ((StringPoemType)type).getSize() == -1) {
                return type;
            }
            if (((StringPoemType)storage).getSize() == 0x3FFFFFFF && ((StringPoemType)type).getSize() == -1) {
                return type;
            }
            return storage.canRepresent(type);
        }
        if (storage instanceof BinaryPoemType && type instanceof BinaryPoemType) {
            if (((BinaryPoemType)storage).getSize() == 510 && ((BinaryPoemType)type).getSize() == -1) {
                return type;
            }
            return storage.canRepresent(type);
        }
        if (storage instanceof TimestampPoemType && type instanceof DatePoemType) {
            return type;
        }
        if (storage instanceof BooleanPoemType && type instanceof BooleanPoemType) {
            return type;
        }
        if (storage instanceof DoublePoemType && type instanceof BigDecimalPoemType && (storage.getNullable() || !type.getNullable())) {
            return type;
        }
        if (storage instanceof IntegerPoemType && type instanceof LongPoemType && (storage.getNullable() || !type.getNullable())) {
            return type;
        }
        return storage.canRepresent(type);
    }

    @Override
    public SQLPoemType<?> defaultPoemTypeOfColumnMetaData(ResultSet md) throws SQLException {
        String typeName = md.getString("TYPE_NAME");
        if (typeName.equals("text")) {
            return new MSAccessStringPoemType(md.getInt("NULLABLE") == 1, md.getInt("COLUMN_SIZE"));
        }
        if (typeName.equals("BINARY")) {
            return new BinaryPoemType(md.getInt("NULLABLE") == 1, md.getInt("COLUMN_SIZE"));
        }
        if (typeName.equals("INT")) {
            return new LongPoemType(md.getInt("NULLABLE") == 1);
        }
        if (typeName.equals("SMALLINT")) {
            return new IntegerPoemType(md.getInt("NULLABLE") == 1);
        }
        if (typeName.equals("bit")) {
            return new SQLServer.SQLServerBooleanPoemType(md.getInt("NULLABLE") == 1);
        }
        return super.defaultPoemTypeOfColumnMetaData(md);
    }

    @Override
    public String caseInsensitiveRegExpSQL(String term1, String term2) {
        if (StringUtils.isQuoted(term2)) {
            term2 = term2.substring(1, term2.length() - 1);
        }
        term2 = StringUtils.quoted(StringUtils.quoted(term2, '%'), '\'');
        return term1 + " LIKE " + term2;
    }

    @Override
    public String alterColumnNotNullableSQL(String tableName, Column<?> column) {
        return "ALTER TABLE " + this.getQuotedName(tableName) + " ALTER COLUMN " + this.getQuotedName(column.getName()) + " " + column.getSQLType().sqlDefinition(this);
    }

    @Override
    public String selectLimit(String querySelection, int limit) {
        return "SELECT TOP " + limit + " " + querySelection;
    }

    @Override
    public String getSqlDefaultValue(SQLType<?> sqlType) {
        if (sqlType instanceof BooleanPoemType) {
            return "0";
        }
        return super.getSqlDefaultValue(sqlType);
    }

    public static class MSAccessStringPoemType
    extends StringPoemType {
        public MSAccessStringPoemType(boolean nullable, int size) {
            super(nullable, size);
        }

        @Override
        protected boolean _canRepresent(SQLPoemType<?> other) {
            return this.sqlTypeCode() == other.sqlTypeCode() && (this.getSize() < 0 || this.getSize() == 250 || this.getSize() >= ((StringPoemType)other).getSize());
        }

        @Override
        public <O> PoemType<O> canRepresent(PoemType<O> other) {
            return other instanceof StringPoemType && this._canRepresent((StringPoemType)other) && (this.getNullable() || !((StringPoemType)other).getNullable()) ? other : null;
        }
    }
}

