/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.dbms;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.melati.poem.BinaryPoemType;
import org.melati.poem.DoublePoemType;
import org.melati.poem.PoemType;
import org.melati.poem.SQLPoemType;
import org.melati.poem.StringPoemType;
import org.melati.poem.dbms.AnsiStandard;

public class Mckoi
extends AnsiStandard {
    public static final int mckoiTextHack = Integer.MAX_VALUE;
    public static final int mckoiBinaryHack = Integer.MAX_VALUE;

    public Mckoi() {
        this.setDriverClassName("com.mckoi.JDBCDriver");
    }

    @Override
    public String getBinarySqlDefinition(int size) {
        return "LONGVARBINARY";
    }

    @Override
    public String getStringSqlDefinition(int size) throws SQLException {
        if (size < 0) {
            return "TEXT";
        }
        return super.getStringSqlDefinition(size);
    }

    @Override
    public String getQuotedName(String name) {
        if (name.equals("unique")) {
            return super.getQuotedName(name);
        }
        if (name.equals("from")) {
            return super.getQuotedName(name);
        }
        return name;
    }

    @Override
    public String getSqlDefinition(String sqlTypeName) {
        if (sqlTypeName.equals("INT")) {
            return "INTEGER";
        }
        return super.getSqlDefinition(sqlTypeName);
    }

    @Override
    public <S, O> PoemType<O> canRepresent(PoemType<S> storage, PoemType<O> type) {
        if (storage instanceof StringPoemType && type instanceof StringPoemType) {
            if (((StringPoemType)storage).getSize() == Integer.MAX_VALUE && ((StringPoemType)type).getSize() == -1 && (storage.getNullable() || !type.getNullable())) {
                return type;
            }
            return storage.canRepresent(type);
        }
        if (storage instanceof BinaryPoemType && type instanceof BinaryPoemType && (storage.getNullable() || !type.getNullable())) {
            if (((BinaryPoemType)storage).getSize() == Integer.MAX_VALUE && ((BinaryPoemType)type).getSize() == -1) {
                return type;
            }
            return storage.canRepresent(type);
        }
        return storage.canRepresent(type);
    }

    @Override
    public SQLPoemType<?> defaultPoemTypeOfColumnMetaData(ResultSet md) throws SQLException {
        if (md.getString("TYPE_NAME").equals("NUMERIC")) {
            return new DoublePoemType(md.getInt("NULLABLE") == 1);
        }
        return super.defaultPoemTypeOfColumnMetaData(md);
    }

    @Override
    public String givesCapabilitySQL(Integer userTroid, String capabilityExpr) {
        return "SELECT " + this.getQuotedName("groupmembership") + ".* FROM " + this.getQuotedName("groupmembership") + " LEFT JOIN " + this.getQuotedName("groupcapability") + " ON " + this.getQuotedName("groupmembership") + "." + this.getQuotedName("group") + " =  " + this.getQuotedName("groupcapability") + "." + this.getQuotedName("group") + " WHERE " + this.getQuotedName("user") + " = " + userTroid + " AND " + this.getQuotedName("groupcapability") + "." + this.getQuotedName("group") + " IS NOT NULL AND " + this.getQuotedName("capability") + " = " + capabilityExpr;
    }
}

