/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.util;

import java.util.Enumeration;
import java.util.Vector;
import org.melati.poem.util.ArrayUtils;
import org.melati.poem.util.EnumUtils;
import org.melati.poem.util.Order;

public final class SortUtils {
    private SortUtils() {
    }

    public static void swap(Object[] arr, int i, int j) {
        Object t = arr[i];
        arr[i] = arr[j];
        arr[j] = t;
    }

    public static void insertionSort(Order cmp, Object[] arr) {
        for (int i = 1; i < arr.length; ++i) {
            int j;
            Object val_i = arr[i];
            if (cmp.lessOrEqual(arr[i - 1], val_i)) continue;
            arr[i] = arr[j];
            for (j = i - 1; j >= 1 && !cmp.lessOrEqual(arr[j - 1], val_i); --j) {
                arr[j] = arr[j - 1];
            }
            arr[j] = val_i;
        }
    }

    private static void partlyQSort(Order cmp, Object[] arr, int lo, int hi) {
        if (hi - lo >= 6) {
            int j;
            int mid = lo + hi >> 1;
            if (cmp.lessOrEqual(arr[mid], arr[lo])) {
                SortUtils.swap(arr, mid, lo);
            }
            if (cmp.lessOrEqual(arr[hi], arr[mid])) {
                SortUtils.swap(arr, mid, hi);
                if (cmp.lessOrEqual(arr[mid], arr[lo])) {
                    SortUtils.swap(arr, mid, lo);
                }
            }
            Object pivot = arr[mid];
            int i = lo + 1;
            for (j = hi - 1; i < j; ++i, --j) {
                while (!cmp.lessOrEqual(pivot, arr[i])) {
                    ++i;
                }
                while (!cmp.lessOrEqual(arr[j], pivot)) {
                    --j;
                }
                if (i >= j) continue;
                SortUtils.swap(arr, i, j);
            }
            if (j - lo <= hi - i) {
                SortUtils.partlyQSort(cmp, arr, lo, j);
                SortUtils.partlyQSort(cmp, arr, i, hi);
            } else {
                SortUtils.partlyQSort(cmp, arr, i, hi);
                SortUtils.partlyQSort(cmp, arr, lo, j);
            }
        }
    }

    public static void qsort(Order cmp, Object[] arr) {
        SortUtils.partlyQSort(cmp, arr, 0, arr.length - 1);
        SortUtils.insertionSort(cmp, arr);
    }

    public static Object[] sorted(Order cmp, Object[] arr) {
        Object[] arr2 = (Object[])arr.clone();
        SortUtils.qsort(cmp, arr2);
        return arr2;
    }

    public static <O> O[] sorted(Order cmp, Vector<O> v) {
        Object[] arr = ArrayUtils.arrayOf(v);
        SortUtils.qsort(cmp, arr);
        return arr;
    }

    public static <O> O[] sorted(Order cmp, Enumeration<O> e) {
        return SortUtils.sorted(cmp, EnumUtils.vectorOf(e));
    }
}

