// Do not edit this file!  It was generated by Melati POEM's DSD preprocessor.

package org.melati.poem.generated;


import org.melati.poem.AccessPoemException;
import org.melati.poem.Column;
import org.melati.poem.Database;
import org.melati.poem.DefinitionSource;
import org.melati.poem.DisplayLevel;
import org.melati.poem.Field;
import org.melati.poem.JdbcPersistent;
import org.melati.poem.Persistent;
import org.melati.poem.PoemDatabaseTables;
import org.melati.poem.PoemException;
import org.melati.poem.PoemTable;
import org.melati.poem.Searchability;
import org.melati.poem.StringPoemType;
import org.melati.poem.TableCategory;
import org.melati.poem.TroidPoemType;
import org.melati.poem.ValidationPoemException;


/**
 * Melati POEM generated base class for <code>Table</code> <code>tableCategory</code>.
 *
 * See org.melati.poem.prepro.TableDef#generateTableBaseJava 
 */

public class TableCategoryTableBase<T extends TableCategory> extends PoemTable<T> {

  private Column<Integer> col_id = null;
  private Column<String> col_name = null;

 /**
  * Constructor. 
  * 
  * See org.melati.poem.prepro.TableDef#generateTableBaseJava 
  * @param database          the POEM database we are using
  * @param name              the name of this <code>Table</code>
  * @param definitionSource  which definition is being used
  * @throws PoemException    if anything goes wrong
  */

  public TableCategoryTableBase(
      Database database, String name,
      DefinitionSource definitionSource) throws PoemException {
    super(database, name, definitionSource);
  }


 /**
  * Get the database tables.
  *
  * See org.melati.poem.prepro.TableDef#generateTableBaseJava 
  * @return the database tables
  */
  public PoemDatabaseTables getPoemDatabaseTables() {
    return (PoemDatabaseTables)getDatabase();
  }


 /**
  * Initialise this table by defining its columns.
  *
  * See org.melati.poem.prepro.TableDef#generateTableBaseJava 
  */
  public void init() throws PoemException {
    super.init();
    defineColumn(col_id =
        new Column<Integer>(this, "id",
                   new TroidPoemType(),
                   DefinitionSource.dsd) { 
          public Object getCooked(Persistent g)
              throws AccessPoemException, PoemException {
            return ((TableCategory)g).getId();
          }

          public void setCooked(Persistent g, Object cooked)
              throws AccessPoemException, ValidationPoemException {
            ((TableCategory)g).setId((Integer)cooked);
          }

          public Field<Integer> asField(Persistent g) {
            return ((TableCategory)g).getIdField();
          }

          public boolean defaultUserEditable() {
            return false;
          }

          public boolean defaultUserCreateable() {
            return false;
          }

          public int defaultDisplayOrder() {
            return 0;
          }

          public String defaultDescription() {
            return "The Table Row Object ID";
          }

          public Object getRaw_unsafe(Persistent g)
              throws AccessPoemException {
            return ((TableCategory)g).getId_unsafe();
          }

          public void setRaw_unsafe(Persistent g, Object raw)
              throws AccessPoemException {
            ((TableCategory)g).setId_unsafe((Integer)raw);
          }

          public Object getRaw(Persistent g)
              throws AccessPoemException {
            return ((TableCategory)g).getId();
          }

          public void setRaw(Persistent g, Object raw)
              throws AccessPoemException {
            ((TableCategory)g).setId((Integer)raw);
          }
        });

    defineColumn(col_name =
        new Column<String>(this, "name",
                   new StringPoemType(false, 60),
                   DefinitionSource.dsd) { 
          public Object getCooked(Persistent g)
              throws AccessPoemException, PoemException {
            return ((TableCategory)g).getName();
          }

          public void setCooked(Persistent g, Object cooked)
              throws AccessPoemException, ValidationPoemException {
            ((TableCategory)g).setName((String)cooked);
          }

          public Field<String> asField(Persistent g) {
            return ((TableCategory)g).getNameField();
          }

          public DisplayLevel defaultDisplayLevel() {
            return DisplayLevel.primary;
          }

          public Searchability defaultSearchability() {
            return Searchability.primary;
          }

          public Integer defaultDisplayOrderPriority() {
            return new Integer(0);
          }

          public int defaultDisplayOrder() {
            return 1;
          }

          public String defaultDescription() {
            return "A human-readable name for the category";
          }

          public boolean defaultUnique() {
            return true;
          }

          public Object getRaw_unsafe(Persistent g)
              throws AccessPoemException {
            return ((TableCategory)g).getName_unsafe();
          }

          public void setRaw_unsafe(Persistent g, Object raw)
              throws AccessPoemException {
            ((TableCategory)g).setName_unsafe((String)raw);
          }

          public Object getRaw(Persistent g)
              throws AccessPoemException {
            return ((TableCategory)g).getName();
          }

          public void setRaw(Persistent g, Object raw)
              throws AccessPoemException {
            ((TableCategory)g).setName((String)raw);
          }
        });
  }


 /**
  * Retrieves the <code>Id</code> <code>Column</code> for this 
  * <code>tableCategory</code> <code>Table</code>.
  * 
  * see org.melati.poem.prepro.FieldDef#generateColAccessor 
  * @return the id <code>Column</code>
  */
  public final Column<Integer> getIdColumn() {
    return col_id;
  }


 /**
  * Retrieves the <code>Name</code> <code>Column</code> for this 
  * <code>tableCategory</code> <code>Table</code>.
  * 
  * see org.melati.poem.prepro.FieldDef#generateColAccessor 
  * @return the name <code>Column</code>
  */
  public final Column<String> getNameColumn() {
    return col_name;
  }


 /**
  * Retrieve the <code>TableCategory</code> as a <code>TableCategory</code>.
  *
  * See org.melati.poem.prepro.TableDef#generateTableBaseJava 
  * @param troid a Table Row Object ID
  * @return the <code>Persistent</code> identified by the <code>troid</code>
  */
  public TableCategory getTableCategoryObject(Integer troid) {
    return (TableCategory)getObject(troid);
  }


 /**
  * Retrieve the <code>TableCategory</code> 
  * as a <code>TableCategory</code>.
  *
  * See org.melati.poem.prepro.TableDef#generateTableBaseJava 
  * @param troid a Table Row Object ID
  * @return the <code>Persistent</code> identified   */
  public TableCategory getTableCategoryObject(int troid) {
    return (TableCategory)getObject(troid);
  }

  protected JdbcPersistent _newPersistent() {
    return new TableCategory();
  }
  public String defaultDisplayName() {
    return "Table type";
  }

  public String defaultDescription() {
    return "A category under which a table can be classified";
  }

  public boolean defaultRememberAllTroids() {
    return true;
  }

  public Integer defaultCacheLimit() {
    return new Integer(999999999);
  }

  public String defaultCategory() {
    return "System";
  }

  public int defaultDisplayOrder() {
    return 3030;
  }

  /**
   * @return a newly created or existing TableCategory
   **/
  public TableCategory ensure(String name) {
    TableCategory p = (TableCategory)getNameColumn().firstWhereEq(name);
    if (p == null) {
      p = (TableCategory)newPersistent();
      p.setName(name);
    }
    return (TableCategory)getNameColumn().ensure(p);
  }
}

