/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.dbms.test;

import java.sql.SQLException;
import org.melati.poem.BigDecimalPoemType;
import org.melati.poem.BooleanPoemType;
import org.melati.poem.DatePoemType;
import org.melati.poem.DoublePoemType;
import org.melati.poem.IntegerPoemType;
import org.melati.poem.LongPoemType;
import org.melati.poem.PoemType;
import org.melati.poem.StringPoemType;
import org.melati.poem.TimestampPoemType;
import org.melati.poem.dbms.DbmsFactory;
import org.melati.poem.dbms.test.DbmsSpec;

public class MSAccessTest
extends DbmsSpec {
    public MSAccessTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    protected void setObjectUnderTest() {
        this.it = DbmsFactory.getDbms((String)"org.melati.poem.dbms.MSAccess");
    }

    @Override
    public void testCanDropColumns() throws Exception {
        MSAccessTest.assertFalse((boolean)this.it.canDropColumns());
    }

    @Override
    public void testGetStringSqlDefinition() throws Exception {
        MSAccessTest.assertEquals((String)"VARCHAR(250)", (String)this.it.getStringSqlDefinition(-1));
        MSAccessTest.assertEquals((String)"VARCHAR(0)", (String)this.it.getStringSqlDefinition(0));
    }

    @Override
    public void testGetSqlDefinition() throws Exception {
        MSAccessTest.assertEquals((String)"BIT", (String)this.it.getSqlDefinition("BOOLEAN"));
        MSAccessTest.assertEquals((String)"DOUBLE", (String)this.it.getSqlDefinition("DOUBLE PRECISION"));
        MSAccessTest.assertEquals((String)"INTEGER", (String)this.it.getSqlDefinition("INT8"));
        MSAccessTest.assertEquals((String)"NUMERIC", (String)this.it.getSqlDefinition("Big Decimal"));
        MSAccessTest.assertEquals((String)"INTEGER", (String)this.it.getSqlDefinition("INTEGER"));
    }

    @Override
    public void testGetLongSqlDefinition() {
        MSAccessTest.assertEquals((String)"INTEGER", (String)this.it.getLongSqlDefinition());
    }

    @Override
    public void testGetBinarySqlDefinition() throws Exception {
        MSAccessTest.assertEquals((String)"BINARY(0)", (String)this.it.getBinarySqlDefinition(0));
        MSAccessTest.assertEquals((String)"BINARY", (String)this.it.getBinarySqlDefinition(-1));
    }

    @Override
    public void testMelatiName() {
        MSAccessTest.assertEquals((String)"name", (String)this.it.melatiName("name"));
        MSAccessTest.assertNull((Object)this.it.melatiName(null));
        MSAccessTest.assertNull((Object)this.it.melatiName("~MSAccess special"));
    }

    @Override
    public void testGetFixedPtSqlDefinition() throws Exception {
        MSAccessTest.assertEquals((String)"NUMERIC", (String)this.it.getFixedPtSqlDefinition(22, 2));
        try {
            this.it.getFixedPtSqlDefinition(-1, 2);
            MSAccessTest.fail((String)"Should have blown up");
        }
        catch (SQLException e2) {
            Object e2 = null;
        }
        try {
            this.it.getFixedPtSqlDefinition(22, -1);
            MSAccessTest.fail((String)"Should have blown up");
        }
        catch (SQLException e) {
            Object var1_4 = null;
        }
    }

    @Override
    public void testCanRepresent() {
        MSAccessTest.assertNull((Object)this.it.canRepresent((PoemType)StringPoemType.nullableInstance, (PoemType)IntegerPoemType.nullableInstance));
        MSAccessTest.assertNull((Object)this.it.canRepresent((PoemType)IntegerPoemType.nullableInstance, (PoemType)StringPoemType.nullableInstance));
        MSAccessTest.assertNull((Object)this.it.canRepresent((PoemType)new BigDecimalPoemType(false), (PoemType)new BigDecimalPoemType(true)));
        MSAccessTest.assertTrue((boolean)(this.it.canRepresent((PoemType)new BigDecimalPoemType(true), (PoemType)new BigDecimalPoemType(false)) instanceof BigDecimalPoemType));
        MSAccessTest.assertNull((Object)this.it.canRepresent((PoemType)new StringPoemType(true, 255), (PoemType)new StringPoemType(true, -1)));
        MSAccessTest.assertTrue((boolean)(this.it.canRepresent((PoemType)new StringPoemType(true, 250), (PoemType)new StringPoemType(true, -1)) instanceof StringPoemType));
        MSAccessTest.assertTrue((boolean)(this.it.canRepresent((PoemType)new StringPoemType(true, 0x3FFFFFFF), (PoemType)new StringPoemType(true, -1)) instanceof StringPoemType));
        MSAccessTest.assertTrue((boolean)(this.it.canRepresent((PoemType)new StringPoemType(true, -1), (PoemType)new StringPoemType(true, -1)) instanceof StringPoemType));
        MSAccessTest.assertTrue((boolean)(this.it.canRepresent((PoemType)new TimestampPoemType(true), (PoemType)new DatePoemType(true)) instanceof DatePoemType));
        MSAccessTest.assertTrue((boolean)(this.it.canRepresent((PoemType)new BooleanPoemType(true), (PoemType)new BooleanPoemType(false)) instanceof BooleanPoemType));
        MSAccessTest.assertNull((Object)this.it.canRepresent((PoemType)new DoublePoemType(false), (PoemType)new BigDecimalPoemType(true)));
        MSAccessTest.assertTrue((boolean)(this.it.canRepresent((PoemType)new DoublePoemType(true), (PoemType)new BigDecimalPoemType(false)) instanceof BigDecimalPoemType));
        MSAccessTest.assertNull((Object)this.it.canRepresent((PoemType)new IntegerPoemType(false), (PoemType)new LongPoemType(true)));
        MSAccessTest.assertTrue((boolean)(this.it.canRepresent((PoemType)new IntegerPoemType(true), (PoemType)new LongPoemType(false)) instanceof LongPoemType));
    }

    @Override
    public void testCaseInsensitiveRegExpSQL() {
        String expected = "a LIKE '%b%'";
        String actual = this.it.caseInsensitiveRegExpSQL("a", "b");
        MSAccessTest.assertEquals((String)expected, (String)actual);
    }

    @Override
    public void testCaseInsensitiveRegExpSQLQuoted() {
        String expected = "a LIKE '%b%'";
        String actual = this.it.caseInsensitiveRegExpSQL("a", "\"b\"");
        MSAccessTest.assertEquals((String)expected, (String)actual);
    }

    @Override
    public void testCaseInsensitiveRegExpSQLBlank() {
        String expected = " LIKE '%%'";
        String actual = this.it.caseInsensitiveRegExpSQL("", "");
        MSAccessTest.assertEquals((String)expected, (String)actual);
    }

    @Override
    public void testSqlBooleanValueOfRaw() {
        MSAccessTest.assertEquals((String)"0", (String)this.it.sqlBooleanValueOfRaw((Object)Boolean.FALSE));
        MSAccessTest.assertEquals((String)"1", (String)this.it.sqlBooleanValueOfRaw((Object)Boolean.TRUE));
    }

    @Override
    public void testSelectLimit() {
        MSAccessTest.assertEquals((String)"SELECT TOP 1 * FROM \"USER\"", (String)this.it.selectLimit("* FROM \"USER\"", 1));
    }

    @Override
    public void testGetForeignKeyDefinition() {
        MSAccessTest.assertEquals((String)" ADD FOREIGN KEY (\"MELATI_USER\") REFERENCES \"MELATI_USER\"(\"id\") ON DELETE RESTRICT", (String)this.it.getForeignKeyDefinition("test", "user", "user", "id", "prevent"));
        MSAccessTest.assertEquals((String)" ADD FOREIGN KEY (\"MELATI_USER\") REFERENCES \"MELATI_USER\"(\"id\") ON DELETE SET NULL", (String)this.it.getForeignKeyDefinition("test", "user", "user", "id", "clear"));
        MSAccessTest.assertEquals((String)" ADD FOREIGN KEY (\"MELATI_USER\") REFERENCES \"MELATI_USER\"(\"id\") ON DELETE CASCADE", (String)this.it.getForeignKeyDefinition("test", "user", "user", "id", "delete"));
    }
}

