/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.dbms;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.melati.poem.BigDecimalPoemType;
import org.melati.poem.BinaryPoemType;
import org.melati.poem.BooleanPoemType;
import org.melati.poem.Column;
import org.melati.poem.DoublePoemType;
import org.melati.poem.IntegerPoemType;
import org.melati.poem.LongPoemType;
import org.melati.poem.PoemType;
import org.melati.poem.SQLPoemType;
import org.melati.poem.SQLType;
import org.melati.poem.StringPoemType;
import org.melati.poem.dbms.AnsiStandard;

public class Oracle
extends AnsiStandard {
    public static int oracleTextHack = 4000;

    public Oracle() {
        this.setDriverClassName("oracle.jdbc.OracleDriver");
    }

    @Override
    public String getStringSqlDefinition(int size) throws SQLException {
        if (size < 0) {
            return "CLOB";
        }
        return super.getStringSqlDefinition(size);
    }

    @Override
    public String getLongSqlDefinition() {
        return "NUMBER";
    }

    @Override
    public String getSqlDefinition(String sqlTypeName) {
        if (sqlTypeName.equals("BOOLEAN")) {
            return "CHAR(1)";
        }
        return super.getSqlDefinition(sqlTypeName);
    }

    @Override
    public String sqlBooleanValueOfRaw(Object raw) {
        if (((Boolean)raw).booleanValue()) {
            return "1";
        }
        return "0";
    }

    @Override
    public String getBinarySqlDefinition(int size) throws SQLException {
        return "BLOB";
    }

    @Override
    public String unreservedName(String name) {
        if (name.equalsIgnoreCase("user")) {
            name = "melati_" + name;
        }
        if (name.equalsIgnoreCase("group")) {
            name = "melati_" + name;
        }
        return name.toUpperCase();
    }

    @Override
    public String melatiName(String name) {
        if (name == null) {
            return null;
        }
        if (name.equalsIgnoreCase("melati_user")) {
            name = "user";
        }
        if (name.equalsIgnoreCase("melati_group")) {
            name = "group";
        }
        return name.toLowerCase();
    }

    @Override
    public <S, O> PoemType<O> canRepresent(PoemType<S> storage, PoemType<O> type) {
        if (storage instanceof IntegerPoemType && type instanceof BigDecimalPoemType && (storage.getNullable() || !type.getNullable())) {
            return type;
        }
        if (storage instanceof IntegerPoemType && type instanceof LongPoemType && (storage.getNullable() || !type.getNullable())) {
            return type;
        }
        return storage.canRepresent(type);
    }

    @Override
    public SQLPoemType<?> defaultPoemTypeOfColumnMetaData(ResultSet md) throws SQLException {
        System.err.println("TYPE_NAME:" + md.getString("TYPE_NAME"));
        if (md.getString("TYPE_NAME").equals("VARCHAR2")) {
            return new OracleStringPoemType(md.getInt("NULLABLE") == 1, md.getInt("COLUMN_SIZE"));
        }
        if (md.getString("TYPE_NAME").equals("CLOB")) {
            return new OracleStringPoemType(md.getInt("NULLABLE") == 1, md.getInt("COLUMN_SIZE"));
        }
        if (md.getString("TYPE_NAME").equals("CHAR")) {
            return new OracleBooleanPoemType(md.getInt("NULLABLE") == 1);
        }
        if (md.getString("TYPE_NAME").equals("BLOB")) {
            return new BinaryPoemType(md.getInt("NULLABLE") == 1, md.getInt("COLUMN_SIZE"));
        }
        if (md.getString("TYPE_NAME").equals("FLOAT")) {
            return new DoublePoemType(md.getInt("NULLABLE") == 1);
        }
        if (md.getString("TYPE_NAME").equals("NUMBER")) {
            return new IntegerPoemType(md.getInt("NULLABLE") == 1);
        }
        return super.defaultPoemTypeOfColumnMetaData(md);
    }

    @Override
    public String getForeignKeyDefinition(String tableName, String fieldName, String targetTableName, String targetTableFieldName, String fixName) {
        String q = " ADD (CONSTRAINT FK_" + tableName + "_" + fieldName + ") FOREIGN KEY (" + this.getQuotedName(fieldName) + ") REFERENCES " + this.getQuotedName(targetTableName) + "(" + this.getQuotedName(targetTableFieldName) + ")";
        if (fixName.equals("delete")) {
            q = q + " ON DELETE CASCADE";
        }
        if (fixName.equals("clear")) {
            q = q + " ON DELETE SET NULL";
        }
        return q;
    }

    @Override
    public String getPrimaryKeyDefinition(String fieldName) {
        return " ADD (CONSTRAINT PK_" + fieldName + " PRIMARY KEY(" + this.getQuotedName(fieldName) + "))";
    }

    @Override
    public String booleanTrueExpression(Column<Boolean> booleanColumn) {
        return booleanColumn.fullQuotedName() + "=1";
    }

    @Override
    public String getSqlDefaultValue(SQLType<?> sqlType) {
        if (sqlType instanceof BooleanPoemType) {
            return "0";
        }
        return super.getSqlDefaultValue(sqlType);
    }

    public static class OracleBooleanPoemType
    extends BooleanPoemType {
        public OracleBooleanPoemType(boolean nullable) {
            super(nullable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Boolean _getRaw(ResultSet rs, int col) throws SQLException {
            ResultSet resultSet = rs;
            synchronized (resultSet) {
                boolean v = rs.getBoolean(col);
                return rs.wasNull() ? null : (v ? Boolean.TRUE : Boolean.FALSE);
            }
        }

        @Override
        protected void _setRaw(PreparedStatement ps, int col, Object bool) throws SQLException {
            ps.setInt(col, (Boolean)bool != false ? 1 : 0);
        }
    }

    public static class OracleStringPoemType
    extends StringPoemType {
        public OracleStringPoemType(boolean nullable, int size) {
            super(nullable, size);
        }

        @Override
        protected boolean _canRepresent(SQLPoemType<?> other) {
            return !(this.sqlTypeCode() != 12 && this.sqlTypeCode() != 2005 || other.sqlTypeCode() != 12 && other.sqlTypeCode() != 2005 || !(this.getSize() == oracleTextHack && ((StringPoemType)other).getSize() == -1 || this.getSize() == -1 && ((StringPoemType)other).getSize() == oracleTextHack) && this.getSize() < ((StringPoemType)other).getSize());
        }

        @Override
        public <O> PoemType<O> canRepresent(PoemType<O> other) {
            return other instanceof StringPoemType && this._canRepresent((StringPoemType)other) && (this.getNullable() || !other.getNullable()) ? other : null;
        }
    }
}

