/*
 * Decompiled with CFR 0.152.
 */
package org.paneris.melati.boards;

import java.util.Vector;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpSession;
import org.melati.LogicalDatabase;
import org.melati.Melati;
import org.melati.MelatiConfig;
import org.melati.PoemContext;
import org.melati.poem.AccessPoemException;
import org.melati.poem.AccessToken;
import org.melati.poem.Capability;
import org.melati.poem.Database;
import org.melati.poem.Initialiser;
import org.melati.poem.Persistent;
import org.melati.poem.PoemException;
import org.melati.poem.PoemTask;
import org.melati.poem.PoemThread;
import org.melati.poem.ValidationPoemException;
import org.melati.poem.util.StringUtils;
import org.melati.servlet.Form;
import org.melati.servlet.InvalidUsageException;
import org.melati.servlet.PathInfoException;
import org.melati.servlet.TemplateServlet;
import org.melati.template.ServletTemplateContext;
import org.melati.template.TemplateContext;
import org.melati.template.TemplateEngine;
import org.melati.util.DumbPagedEnumeration;
import org.melati.util.MelatiStringWriter;
import org.melati.util.MelatiWriter;
import org.paneris.melati.boards.BoardUtils;
import org.paneris.melati.boards.DistributeThread;
import org.paneris.melati.boards.model.Board;
import org.paneris.melati.boards.model.BoardTable;
import org.paneris.melati.boards.model.BoardsDatabaseTables;
import org.paneris.melati.boards.model.MembershipStatus;
import org.paneris.melati.boards.model.Message;
import org.paneris.melati.boards.model.MessageTable;
import org.paneris.melati.boards.model.Subscription;
import org.paneris.melati.boards.model.User;

public class BoardAdmin
extends TemplateServlet {
    private static final long serialVersionUID = 1L;
    private static int MAX_HITS = 2000;
    private static int HITS_PER_PAGE = 20;
    static MelatiConfig mConfig = null;
    static TemplateEngine tEngine = null;

    protected Persistent create(MessageTable table, final ServletTemplateContext context, final User user) {
        return table.create(new Initialiser(){

            public void init(Persistent object) throws AccessPoemException, ValidationPoemException {
                Form.extractFields((ServletTemplateContext)context, (Persistent)object);
                ((Message)object).setAuthor(user);
            }
        });
    }

    protected PoemContext melatiContext(Melati melati) throws PathInfoException {
        final PoemContext it = new PoemContext();
        final String[] parts = melati.getPathInfoParts();
        it.setLogicalDatabase("");
        if (parts.length > 0) {
            it.setLogicalDatabase(parts[0]);
            if (parts.length == 2) {
                it.setMethod(parts[1]);
            }
            if (parts.length == 3) {
                it.setTable(parts[1]);
                it.setMethod(parts[2]);
            }
            if (parts.length >= 4) {
                it.setTable(parts[1]);
                try {
                    it.setTroid(new Integer(parts[2]));
                }
                catch (NumberFormatException e) {
                    try {
                        final Database db = LogicalDatabase.getDatabase((String)parts[0]);
                        db.inSession(AccessToken.root, new PoemTask(){

                            public void run() {
                                String value = StringUtils.tr((String)parts[2], (char)'.', (char)' ');
                                Persistent p = db.getTable(parts[1]).displayColumn().firstWhereEq((Object)value);
                                if (p == null) {
                                    throw new RuntimeException("'" + value + "'" + " not found in column " + db.getTable(parts[1]).displayColumn().getDisplayName());
                                }
                                it.setTroid(p.troid());
                            }
                        });
                    }
                    catch (Exception e1) {
                        throw new PathInfoException(melati.getRequest().getPathInfo(), e1);
                    }
                }
                if (parts.length == 4) {
                    it.setMethod(parts[3]);
                } else {
                    String pathInfo = melati.getRequest().getPathInfo();
                    pathInfo = pathInfo.substring(1);
                    for (int i = 0; i < 3; ++i) {
                        pathInfo = pathInfo.substring(pathInfo.indexOf("/") + 1);
                    }
                    it.setMethod(pathInfo);
                }
            }
        }
        return it;
    }

    protected String boardTemplate(String name) {
        return "melati/boards/" + name;
    }

    protected String loginTemplate(ServletTemplateContext context, Melati melati) throws PoemException {
        org.melati.poem.User token = (org.melati.poem.User)PoemThread.accessToken();
        if (token.isGuest()) {
            throw new AccessPoemException((AccessToken)token, new Capability("Logged In"));
        }
        return this.boardTemplate(context, melati);
    }

    protected String typesTemplate() throws PoemException {
        return this.boardTemplate("Types");
    }

    protected String searchForBoardTemplate() throws PoemException {
        return this.boardTemplate("SearchForBoard");
    }

    protected String listBoardsTemplate() throws PoemException {
        return this.boardTemplate("ListBoards");
    }

    protected String boardTemplate(ServletTemplateContext context, Melati melati) throws PoemException {
        int s = new Integer((String)context.get("start"));
        DumbPagedEnumeration messages = new DumbPagedEnumeration(((Board)melati.getObject()).getMessages(), s, HITS_PER_PAGE, MAX_HITS);
        context.put("messages", (Object)messages);
        return this.boardTemplate("Board");
    }

    private void checkBanned(Board board, org.melati.poem.User user) {
        if (board.isBanned((User)user)) {
            throw new AccessPoemException((AccessToken)user, new Capability("Not Banned"));
        }
    }

    protected String searchBoardTemplate() throws PoemException {
        return this.boardTemplate("SearchBoard");
    }

    protected String settingsTemplate() throws PoemException {
        return this.boardTemplate("Settings");
    }

    protected String settingsUpdateTemplate(ServletTemplateContext context, Melati melati, Board board) throws PoemException {
        this.checkBanned(board, melati.getUser());
        Form.extractFields((ServletTemplateContext)context, (Persistent)melati.getObject());
        return this.boardTemplate("SettingsUpdate");
    }

    protected String settingsEditTemplate(Melati melati, Board board) throws PoemException {
        this.checkBanned(board, melati.getUser());
        return this.boardTemplate("SettingsEdit");
    }

    protected String membersTemplate() throws PoemException {
        return this.boardTemplate("Members");
    }

    protected String messageNewTemplate(ServletTemplateContext context, Melati melati, Board board) throws PoemException {
        this.checkBanned(board, melati.getUser());
        if (melati.getUser().isGuest() && !board.getAnonymousposting().booleanValue()) {
            throw new AccessPoemException((AccessToken)melati.getUser(), new Capability("Logged In"));
        }
        String parent = context.getFormField("parent");
        if (parent != null && !parent.equals("")) {
            context.put("parent", (Object)((BoardTable)melati.getTable()).getBoardsDatabaseTables().getMessageTable().getObject(new Integer(parent)));
        }
        return this.boardTemplate("MessageNew");
    }

    protected String messageTemplate(ServletTemplateContext context, boolean withThread) throws PoemException {
        context.put("withThread", (Object)new Boolean(withThread));
        return this.boardTemplate("Message");
    }

    protected String messageCreateTemplate(ServletTemplateContext context, final Melati melati, Board board) throws PoemException {
        Message newMessage;
        this.checkBanned(board, melati.getUser());
        User user = (User)melati.getUser();
        if (user.isGuest() && board.getAnonymousposting().booleanValue()) {
            String email = Form.getFieldNulled((ServletTemplateContext)context, (String)"field_email");
            user = (User)melati.getDatabase().getUserTable().firstSelection("UPPER(" + melati.getDatabase().getDbms().getQuotedName("email") + ") = '" + email.toUpperCase() + "'");
            if (user == null) {
                user = (User)melati.getDatabase().getUserTable().newPersistent();
                user.setEmail(email);
                user.generateDefaults();
                final User thisuser = user;
                board.getDatabase().inSession(AccessToken.root, new PoemTask(){

                    public void run() {
                        melati.getDatabase().getUserTable().create((Persistent)thisuser);
                    }

                    public String toString() {
                        return "Creating a user doing anonymous posting.";
                    }
                });
            }
        }
        if ((newMessage = (Message)this.create(((BoardTable)melati.getTable()).getBoardsDatabaseTables().getMessageTable(), context, user)).getApproved().booleanValue()) {
            newMessage.distribute();
            return this.boardTemplate("MessageCreate");
        }
        BoardAdmin.emailNotification(newMessage.getBoard(), user, "MessageReceived");
        return this.boardTemplate("MessageNeedsModerating");
    }

    protected String pendingMessagesTemplate() throws PoemException {
        return this.boardTemplate("PendingMessages");
    }

    protected String approveMessagesTemplate(ServletTemplateContext context, Melati melati) throws PoemException {
        String[] messages = melati.getRequest().getParameterValues("message");
        for (int i = 0; i < messages.length; ++i) {
            String action = Form.getFieldNulled((ServletTemplateContext)context, (String)messages[i]);
            if (action == null) continue;
            Message message = (Message)((BoardsDatabaseTables)melati.getDatabase()).getMessageTable().getObject(new Integer(messages[i]));
            if (action.equals("approve")) {
                message.approve();
                message.distribute();
                continue;
            }
            message.setDeleted(true);
        }
        return this.boardTemplate("ApproveMessages");
    }

    protected String subscribeTemplate(Melati melati, Board board) throws PoemException {
        this.checkBanned(board, melati.getUser());
        User user = (User)melati.getUser();
        if (!board.canSubscribe(user)) {
            return this.boardTemplate("SubscribeByManager");
        }
        if (board.isMember(user)) {
            return this.boardTemplate("SubscribedAlready");
        }
        if (((BoardsDatabaseTables)melati.getDatabase()).getSubscriptionTable().getUserSubscription(user, board) != null) {
            return this.boardTemplate("SubscriptionAlreadyPending");
        }
        if (board.getModeratedsubscription().booleanValue()) {
            board.subscribe(user, ((BoardsDatabaseTables)melati.getDatabase()).getMembershipStatusTable().getNormal(), Boolean.FALSE, Boolean.FALSE);
            BoardAdmin.emailNotification(board, (User)melati.getUser(), "SubscriptionRequestReceived");
            return this.boardTemplate("SubscribeApprovalRequired");
        }
        board.subscribe(user);
        BoardAdmin.emailNotification(board, (User)melati.getUser(), "Subscribed");
        return this.boardTemplate("Subscribe");
    }

    protected String unsubscribeTemplate(Melati melati, Board board) throws PoemException {
        if (melati.getUser().isGuest()) {
            throw new AccessPoemException((AccessToken)melati.getUser(), new Capability("Logged In"));
        }
        if (!board.canUnSubscribe((User)melati.getUser())) {
            throw new AccessPoemException((AccessToken)melati.getUser(), new Capability("Not Banned"));
        }
        board.unsubscribe((User)melati.getUser());
        return this.boardTemplate("Unsubscribe");
    }

    protected String membersEditTemplate(ServletTemplateContext context, Melati melati) throws PoemException {
        String[] subscriptions = melati.getRequest().getParameterValues("subscription");
        if (subscriptions == null || subscriptions.length == 0) {
            return this.boardTemplate("MembersEdit");
        }
        Vector<Subscription> toDelete = new Vector<Subscription>();
        for (int i = 0; i < subscriptions.length; ++i) {
            Subscription sub = ((Board)melati.getObject()).getBoardsDatabaseTables().getSubscriptionTable().getSubscriptionObject(new Integer(subscriptions[i]));
            String delete = context.getFormField("delete-" + subscriptions[i]);
            if ("true".equals(delete)) {
                if (sub.getUser() == melati.getUser()) continue;
                toDelete.addElement(sub);
                continue;
            }
            String manager = context.getFormField("manager-" + subscriptions[i]);
            if (sub.getUser() == melati.getUser()) {
                manager = sub.getIsmanager().toString();
            }
            String status = context.getFormField("status-" + subscriptions[i]);
            sub.setIsmanager("true".equals(manager) ? Boolean.TRUE : Boolean.FALSE);
            sub.setStatusTroid(new Integer(status));
        }
        for (int j = 0; j < toDelete.size(); ++j) {
            ((Subscription)((Object)toDelete.elementAt(j))).deleteAndCommit();
        }
        return this.boardTemplate("MembersEdit");
    }

    protected String deleteMessagesTemplate(ServletTemplateContext context, Melati melati) throws PoemException {
        String[] messages = melati.getRequest().getParameterValues("messages");
        if (messages == null || messages.length == 0) {
            return this.boardTemplate(context, melati);
        }
        for (int i = 0; i < messages.length; ++i) {
            Message mess = ((Board)melati.getObject()).getBoardsDatabaseTables().getMessageTable().getMessageObject(new Integer(messages[i]));
            String delete = context.getFormField("delete-" + messages[i]);
            if (delete == null) continue;
            mess.setDeleted(Boolean.TRUE);
        }
        return this.boardTemplate(context, melati);
    }

    protected String subscribeOthersTemplate(ServletTemplateContext context, Melati melati, Board board) throws PoemException {
        String[] others = melati.getRequest().getParameterValues("others");
        if (others == null || others.length == 0) {
            return this.boardTemplate("MembersEdit");
        }
        Boolean manager = context.getFormField("manager") != null && context.getFormField("manager").equals("true") ? Boolean.TRUE : Boolean.FALSE;
        MembershipStatus normal = ((Board)melati.getObject()).getBoardsDatabaseTables().getMembershipStatusTable().getNormal();
        for (int i = 0; i < others.length; ++i) {
            User newUser = (User)((Board)melati.getObject()).getBoardsDatabaseTables().getUserTable().getUserObject(new Integer(others[i]));
            board.subscribe(newUser, normal, manager, Boolean.TRUE);
            BoardAdmin.emailNotification(board, newUser, "Subscribed");
        }
        return this.boardTemplate("MembersEdit");
    }

    protected String pendingSubscriptionsTemplate() throws PoemException {
        return this.boardTemplate("PendingSubscriptions");
    }

    protected String approveSubscriptionsTemplate(ServletTemplateContext context, Melati melati) throws PoemException {
        String[] subscriptions = melati.getRequest().getParameterValues("subscription");
        for (int i = 0; i < subscriptions.length; ++i) {
            Subscription subscription = (Subscription)((BoardsDatabaseTables)melati.getDatabase()).getSubscriptionTable().getObject(new Integer(subscriptions[i]));
            String action = context.getFormField(subscriptions[i]);
            if (action.equals("normal") || action.equals("manager")) {
                if (action.equals("manager")) {
                    subscription.setIsmanager(Boolean.TRUE);
                }
                subscription.approve();
                BoardAdmin.emailNotification(subscription.getBoard(), (User)melati.getUser(), "SubscriptionRequestApproved");
                continue;
            }
            if (!action.equals("remove")) continue;
            BoardAdmin.emailNotification(subscription.getBoard(), (User)melati.getUser(), "SubscriptionRequestDeclined");
            subscription.deleteAndCommit();
        }
        return this.boardTemplate("ApproveSubscriptions");
    }

    protected String subscriptionEditTemplate(Melati melati, Board board) throws PoemException {
        this.checkBanned(board, melati.getUser());
        return this.boardTemplate("SubscriptionEdit");
    }

    protected String subscriptionUpdateTemplate(ServletTemplateContext context, Melati melati, Board board) throws PoemException {
        this.checkBanned(board, melati.getUser());
        Form.extractFields((ServletTemplateContext)context, (Persistent)melati.getObject());
        return this.boardTemplate("SubscriptionUpdate");
    }

    protected String doTemplateRequest(Melati melati, ServletTemplateContext context) throws Exception {
        context.put("boardutils", (Object)new BoardUtils(melati.getServletURL(), melati.getPoemContext().getLogicalDatabase()));
        Board board = null;
        if (melati.getTable() != null && melati.getObject() != null) {
            if (melati.getTable().getName().equals("Board")) {
                board = (Board)melati.getObject();
            } else if (melati.getTable().getName().equals("Subscription")) {
                board = ((Subscription)melati.getObject()).getBoard();
            } else if (melati.getTable().getName().equals("Message")) {
                board = ((Message)melati.getObject()).getBoard();
            }
        }
        context.put("start", (Object)this.getBoardStart(board, melati.getRequest().getSession(true), context.getFormField("start")));
        if (melati.getTable() == null) {
            if (melati.getMethod() != null) {
                if (melati.getMethod().equals("Types")) {
                    return this.typesTemplate();
                }
                if (melati.getMethod().equals("SearchForBoard")) {
                    return this.searchForBoardTemplate();
                }
            }
        } else if (melati.getTable().getName().equals("Board") && melati.getObject() != null) {
            if (melati.getMethod().equals("Board")) {
                return this.boardTemplate(context, melati);
            }
            if (melati.getMethod().equals("Login")) {
                return this.loginTemplate(context, melati);
            }
            if (melati.getMethod().equals("MessageNew")) {
                return this.messageNewTemplate(context, melati, board);
            }
            if (melati.getMethod().equals("MessageCreate")) {
                return this.messageCreateTemplate(context, melati, board);
            }
            if (melati.getMethod().equals("SearchBoard")) {
                return this.searchBoardTemplate();
            }
            if (melati.getMethod().equals("Settings")) {
                return this.settingsTemplate();
            }
            if (melati.getMethod().equals("SettingsEdit")) {
                return this.settingsEditTemplate(melati, board);
            }
            if (melati.getMethod().equals("SettingsUpdate")) {
                return this.settingsUpdateTemplate(context, melati, board);
            }
            if (melati.getMethod().equals("Members")) {
                return this.membersTemplate();
            }
            if (melati.getMethod().equals("Subscribe")) {
                return this.subscribeTemplate(melati, board);
            }
            if (melati.getMethod().equals("Unsubscribe")) {
                return this.unsubscribeTemplate(melati, board);
            }
            if (melati.getMethod().equals("SubscribeOthers")) {
                return this.subscribeOthersTemplate(context, melati, board);
            }
            if (melati.getMethod().equals("MembersEdit")) {
                return this.membersEditTemplate(context, melati);
            }
            if (melati.getMethod().equals("PendingMessages")) {
                return this.pendingMessagesTemplate();
            }
            if (melati.getMethod().equals("PendingSubscriptions")) {
                return this.pendingSubscriptionsTemplate();
            }
            if (melati.getMethod().equals("ApproveMessages")) {
                return this.approveMessagesTemplate(context, melati);
            }
            if (melati.getMethod().equals("DeleteMessages")) {
                return this.deleteMessagesTemplate(context, melati);
            }
            if (melati.getMethod().equals("ApproveSubscriptions")) {
                return this.approveSubscriptionsTemplate(context, melati);
            }
        } else if (melati.getTable().getName().equals("Message") && melati.getObject() != null) {
            if (melati.getMethod().equals("Message")) {
                return this.messageTemplate(context, true);
            }
            if (melati.getMethod().equals("MessageNoThread")) {
                return this.messageTemplate(context, false);
            }
        } else if (melati.getTable().getName().equals("BoardType") && melati.getObject() != null) {
            if (melati.getMethod().equals("ListBoards")) {
                return this.listBoardsTemplate();
            }
        } else if (melati.getTable().getName().equals("Subscription") && melati.getObject() != null) {
            if (melati.getMethod().equals("SubscriptionEdit")) {
                return this.subscriptionEditTemplate(melati, board);
            }
            if (melati.getMethod().equals("SubscriptionUpdate")) {
                return this.subscriptionUpdateTemplate(context, melati, board);
            }
        }
        throw new InvalidUsageException((HttpServlet)this, melati.getPoemContext());
    }

    private String getBoardStart(Board board, HttpSession session, String start) {
        if (board != null) {
            String key = "org.paneris.melati.boards." + board.troid();
            if (start == null) {
                start = (String)session.getAttribute(key);
            } else {
                session.setAttribute(key, (Object)start);
            }
        }
        return start != null ? start : "0";
    }

    public static void emailNotification(Board board, User user, String templateName) {
        try {
            new DistributeThread(board, user, BoardAdmin.evalTemplate(user, templateName, board)).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static String evalTemplate(User user, String template, Board board) throws Exception {
        if (mConfig == null) {
            mConfig = new MelatiConfig();
        }
        if (tEngine == null && (tEngine = mConfig.getTemplateEngine()) != null) {
            tEngine.init(mConfig);
        }
        MelatiStringWriter sw = tEngine.getStringWriter();
        Melati melati = new Melati(mConfig, (MelatiWriter)sw);
        ServletTemplateContext context = (ServletTemplateContext)tEngine.getTemplateContext();
        context.put("melati", (Object)melati);
        context.put("board", (Object)board);
        context.put("user", (Object)user);
        tEngine.expandTemplate(melati.getWriter(), board.templatePath(template), (TemplateContext)context);
        return sw.toString();
    }
}

