/*
 * Decompiled with CFR 0.152.
 */
package org.paneris.melati.boards;

import org.paneris.melati.boards.model.Board;
import org.paneris.melati.boards.model.BoardType;
import org.paneris.melati.boards.model.Message;
import org.paneris.melati.boards.model.Subscription;

public class BoardUtils {
    private String boardURL;
    private String logicalDatabase;

    public BoardUtils(String boardURL, String logicalDatabase) {
        this.boardURL = boardURL;
        this.logicalDatabase = logicalDatabase;
    }

    public String LoginURL(Board board) {
        return this.boardURL + "/" + this.logicalDatabase + "/board/" + board.troid() + "/Login";
    }

    public String TypesURL() {
        return this.boardURL + "/" + this.logicalDatabase + "/Types";
    }

    public String SearchForBoardURL() {
        return this.boardURL + "/" + this.logicalDatabase + "/SearchForBoard";
    }

    public String ListBoardsURL(BoardType type) {
        return this.boardURL + "/" + this.logicalDatabase + "/boardtype/" + type.troid() + "/ListBoards";
    }

    public String BoardURL(Board board, String start) {
        return this.boardURL + "/" + this.logicalDatabase + "/board/" + board.troid() + "/Board?start=" + start;
    }

    public String SearchBoardURL(Board board) {
        return this.boardURL + "/" + this.logicalDatabase + "/board/" + board.troid() + "/SearchBoard";
    }

    public String MessageURL(Message message, String start) {
        return this.boardURL + "/" + this.logicalDatabase + "/message/" + message.troid() + "/Message?start=" + start;
    }

    public String MessageNoThreadURL(Message message, String start) {
        return this.boardURL + "/" + this.logicalDatabase + "/message/" + message.troid() + "/MessageNoThread?start=" + start;
    }

    public String MessageNewURL(Board board) {
        return this.boardURL + "/" + this.logicalDatabase + "/board/" + board.troid() + "/MessageNew";
    }

    public String MessageCreateURL(Board board) {
        return this.boardURL + "/" + this.logicalDatabase + "/board/" + board.troid() + "/MessageCreate";
    }

    public String SubscribeURL(Board board) {
        return this.boardURL + "/" + this.logicalDatabase + "/board/" + board.troid() + "/Subscribe";
    }

    public String SubscriptionEditURL(Subscription sub) {
        return this.boardURL + "/" + this.logicalDatabase + "/subscription/" + sub.troid() + "/SubscriptionEdit";
    }

    public String SubscriptionUpdateURL(Subscription sub) {
        return this.boardURL + "/" + this.logicalDatabase + "/subscription/" + sub.troid() + "/SubscriptionUpdate";
    }

    public String UnsubscribeURL(Board board) {
        return this.boardURL + "/" + this.logicalDatabase + "/board/" + board.troid() + "/Unsubscribe";
    }

    public String MembersURL(Board board) {
        return this.boardURL + "/" + this.logicalDatabase + "/board/" + board.troid() + "/Members";
    }

    public String MembersEditURL(Board board) {
        return this.boardURL + "/" + this.logicalDatabase + "/board/" + board.troid() + "/MembersEdit";
    }

    public String SubscribeOthersURL(Board board) {
        return this.boardURL + "/" + this.logicalDatabase + "/board/" + board.troid() + "/SubscribeOthers";
    }

    public String PendingMessagesURL(Board board) {
        return this.boardURL + "/" + this.logicalDatabase + "/board/" + board.troid() + "/PendingMessages";
    }

    public String PendingSubscriptionsURL(Board board) {
        return this.boardURL + "/" + this.logicalDatabase + "/board/" + board.troid() + "/PendingSubscriptions";
    }

    public String ApproveMessagesURL(Board board) {
        return this.boardURL + "/" + this.logicalDatabase + "/board/" + board.troid() + "/ApproveMessages";
    }

    public String ApproveSubscriptionsURL(Board board) {
        return this.boardURL + "/" + this.logicalDatabase + "/board/" + board.troid() + "/ApproveSubscriptions";
    }

    public String SettingsURL(Board board) {
        return this.boardURL + "/" + this.logicalDatabase + "/board/" + board.troid() + "/Settings";
    }

    public String SettingsUpdateURL(Board board) {
        return this.boardURL + "/" + this.logicalDatabase + "/board/" + board.troid() + "/SettingsUpdate";
    }

    public String SettingsEditURL(Board board) {
        return this.boardURL + "/" + this.logicalDatabase + "/board/" + board.troid() + "/SettingsEdit";
    }

    public String DeleteMessagesURL(Board board) {
        return this.boardURL + "/" + this.logicalDatabase + "/board/" + board.troid() + "/DeleteMessages";
    }

    public static int indent(int space, int depth) {
        return space * depth + 1;
    }
}

