/*
 * Decompiled with CFR 0.152.
 */
package org.paneris.melati.boards.model;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.melati.poem.AccessPoemException;
import org.melati.poem.ValidationPoemException;
import org.melati.util.UTF8URLEncoder;
import org.melati.util.UnexpectedExceptionException;
import org.paneris.melati.boards.model.Board;
import org.paneris.melati.boards.model.Message;
import org.paneris.melati.boards.model.generated.AttachmentBase;

public class Attachment
extends AttachmentBase {
    @Override
    public void setFilename_unsafe(String cooked) {
        super.setFilename_unsafe(cooked);
        Message thisMessage = (Message)this.getDatabase().getTable("message").getObject(this.getMessage_unsafe());
        Board board = (Board)this.getDatabase().getTable("board").getObject(thisMessage.getBoard_unsafe());
        this.setPath_unsafe(board.getAttachmentspath_unsafe() + File.separatorChar + cooked);
        this.setUrl_unsafe(board.getAttachmentsurl_unsafe() + File.separatorChar + UTF8URLEncoder.encode((String)cooked));
    }

    @Override
    public void setFilename(String cooked) {
        super.setFilename(cooked);
        this.setPath(this.getMessage().getBoard().getAttachmentspath() + File.separatorChar + cooked);
        this.setUrl(this.getMessage().getBoard().getAttachmentsurl() + File.separatorChar + UTF8URLEncoder.encode((String)cooked));
    }

    public void setFilename_unique_unsafe(String cooked) {
        cooked = this.makeUnique(cooked);
        this.setFilename_unsafe(cooked);
    }

    public void setFilename_unique(String cooked) throws AccessPoemException, ValidationPoemException {
        cooked = this.makeUnique(cooked);
        this.setFilename(cooked);
    }

    public String makeUnique(String fileName) {
        File testFile;
        if (fileName == null) {
            fileName = "attachment";
        }
        Message thisMessage = (Message)this.getDatabase().getTable("message").getObject(this.getMessage_unsafe());
        Board board = (Board)this.getDatabase().getTable("board").getObject(thisMessage.getBoard_unsafe());
        try {
            testFile = new File(board.getAttachmentspath_unsafe(), fileName);
        }
        catch (Exception e) {
            throw new UnexpectedExceptionException("Failed to create a file in directory:" + board.getAttachmentspath_unsafe() + " filename:" + fileName, e);
        }
        int dot = fileName.lastIndexOf(".");
        String start = dot != -1 ? fileName.substring(0, dot) : fileName;
        String extension = dot != -1 ? fileName.substring(dot, fileName.length()) : "";
        int count = 0;
        while (testFile.exists()) {
            fileName = start + count++ + extension;
            testFile = new File(board.getAttachmentspath_unsafe(), fileName);
        }
        return testFile.getName();
    }

    public void writeData(byte[] content) throws FileNotFoundException, IOException {
        this.writeDataToFile(new File(this.getPath()), content);
    }

    public void writeData_unsafe(byte[] content) throws FileNotFoundException, IOException {
        this.writeDataToFile(new File(this.getPath_unsafe()), content);
    }

    private void writeDataToFile(File attachment, byte[] content) throws FileNotFoundException, IOException {
        attachment.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(attachment);
        fos.write(content);
        fos.close();
    }
}

