/*
 * Decompiled with CFR 0.152.
 */
package org.paneris.melati.boards.model;

import java.io.File;
import java.lang.ref.SoftReference;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.melati.poem.AccessPoemException;
import org.melati.poem.AccessToken;
import org.melati.poem.CachedCount;
import org.melati.poem.CachedSelection;
import org.melati.poem.Capability;
import org.melati.poem.Persistent;
import org.melati.poem.Treeable;
import org.melati.poem.ValidationPoemException;
import org.melati.poem.util.EnumUtils;
import org.melati.poem.util.MappedEnumeration;
import org.melati.util.ChildrenDrivenMutableTree;
import org.melati.util.Email;
import org.paneris.melati.boards.model.BoardTable;
import org.paneris.melati.boards.model.MembershipStatus;
import org.paneris.melati.boards.model.Message;
import org.paneris.melati.boards.model.MessageNotInBoardException;
import org.paneris.melati.boards.model.MessageTable;
import org.paneris.melati.boards.model.SettingNotFoundException;
import org.paneris.melati.boards.model.Subscription;
import org.paneris.melati.boards.model.User;
import org.paneris.melati.boards.model.generated.BoardBase;

public class Board
extends BoardBase {
    public static String SMTPSERVER = "SMTPServer";
    private CachedCount managerCount = null;
    private CachedSelection managersubs = null;
    private CachedCount memberCount = null;
    private CachedSelection membersubs = null;
    private CachedSelection roots = null;
    private Vector threadTrees = null;
    private Hashtable threadsByRoot = null;
    SoftReference messages = null;
    private CachedCount messageCount = null;
    private CachedCount pendingMessageCount = null;
    private CachedSelection pendingMessages = null;
    private CachedCount pendingSubscriptionCount = null;
    private CachedSelection pendingSubscriptions = null;

    public boolean isAdmin(User user) {
        return user.givesCapability(this.getDatabase().administerCapability());
    }

    public boolean isManager(User user) {
        return this.getBoardsDatabaseTables().getSubscriptionTable().isManager(user, this);
    }

    public boolean isMember(User user) {
        return this.getBoardsDatabaseTables().getSubscriptionTable().isMember(user, this);
    }

    public boolean isBanned(User user) {
        Subscription subscription = this.getUserSubscription(user);
        return subscription != null && subscription.getStatus() == this.getBoardsDatabaseTables().getMembershipStatusTable().getBanned();
    }

    public void ban(User user) {
        Subscription subscription = this.getUserSubscription(user);
        subscription.setStatus(this.getBoardsDatabaseTables().getMembershipStatusTable().getBanned());
    }

    public int getManagerCount() {
        if (this.managerCount == null) {
            this.managerCount = this.getBoardsDatabaseTables().getSubscriptionTable().cachedManagerCount(this);
        }
        return this.managerCount.count();
    }

    public Enumeration getManagersSubscriptions() {
        if (this.managersubs == null) {
            this.managersubs = this.getBoardsDatabaseTables().getSubscriptionTable().cachedManagers(this);
        }
        return this.managersubs.objects();
    }

    public Enumeration getManagers() {
        return new MappedEnumeration(this.getManagersSubscriptions()){

            public Object mapped(Object subscription) {
                return ((Subscription)((Object)subscription)).getUser();
            }
        };
    }

    public int getMemberCount() {
        if (this.memberCount == null) {
            this.memberCount = this.getBoardsDatabaseTables().getSubscriptionTable().cachedMemberCount(this);
        }
        return this.memberCount.count();
    }

    public Enumeration getMembersSubscriptions() {
        if (this.membersubs == null) {
            this.membersubs = this.getBoardsDatabaseTables().getSubscriptionTable().cachedMembers(this);
        }
        return this.membersubs.objects();
    }

    public Enumeration getMembers() {
        return new MappedEnumeration(this.getMembersSubscriptions()){

            public Object mapped(Object subscription) {
                return ((Subscription)((Object)subscription)).getUser();
            }
        };
    }

    public Enumeration getNormalDistributionList() {
        return this.getBoardsDatabaseTables().getSubscriptionTable().getNormalDistributionList(this);
    }

    public Enumeration getDigestDistributionList() {
        return this.getBoardsDatabaseTables().getSubscriptionTable().getDigestDistributionList(this);
    }

    public boolean canSubscribe(User user) {
        if (this.isBanned(user)) {
            return false;
        }
        return this.getOpensubscription() != false || this.isManager(user) || this.isAdmin(user);
    }

    public boolean canUnSubscribe(User user) {
        return !this.isBanned(user);
    }

    public boolean canPost(User user) {
        if (this.isBanned(user)) {
            return false;
        }
        return this.getOpenposting() != false || this.isMember(user) || this.isAdmin(user);
    }

    public boolean canViewMessages(User user) {
        if (this.isBanned(user)) {
            return false;
        }
        return this.getOpenmessageviewing() != false || this.isMember(user) || this.isAdmin(user);
    }

    public boolean canViewMembers(User user) {
        if (this.isBanned(user)) {
            return false;
        }
        return this.getOpenmemberlist() != false || this.isMember(user) || this.isAdmin(user);
    }

    public boolean canManage(User user) {
        return this.isManager(user) || this.isAdmin(user);
    }

    public void assertCanWrite(AccessToken token) throws AccessPoemException {
        if (token == AccessToken.root) {
            return;
        }
        try {
            if (!this.canManage((User)token)) {
                throw new AccessPoemException(token, new Capability("Manager"));
            }
        }
        catch (ClassCastException e) {
            throw new AccessPoemException(token, new Capability("Manager"));
        }
    }

    public void assertCanCreate(AccessToken token) throws AccessPoemException {
        if (token == AccessToken.root) {
            return;
        }
        try {
            if (token == this.getDatabase().guestAccessToken()) {
                throw new AccessPoemException(token, new Capability("Logged In"));
            }
        }
        catch (ClassCastException e) {
            throw new AccessPoemException(token, new Capability("Logged In"));
        }
    }

    public final void makePersistent(User manager) {
        ((BoardTable)this.getTable()).create((Persistent)this, manager);
    }

    public void subscribe(User user, MembershipStatus status, Boolean ismanager, Boolean approved) {
        this.getBoardsDatabaseTables().getSubscriptionTable().subscribe(user, this, status, ismanager, approved);
    }

    public void subscribe(User user) {
        this.subscribe(user, this.getBoardsDatabaseTables().getMembershipStatusTable().getNormal(), Boolean.FALSE, new Boolean(this.getModeratedsubscription_unsafe() == false));
    }

    public boolean isSubscribed(User user) {
        return this.getBoardsDatabaseTables().getSubscriptionTable().isMember(user, this);
    }

    public void unsubscribe(User user) {
        this.getBoardsDatabaseTables().getSubscriptionTable().unsubscribe(user, this);
    }

    public Subscription getUserSubscription(User user) {
        return this.getBoardsDatabaseTables().getSubscriptionTable().getUserSubscription(user, this);
    }

    public void distribute(Message message) {
        String toString;
        String members = EnumUtils.concatenated((String)",", (Enumeration)new MappedEnumeration(this.getMembers()){

            public Object mapped(Object member) {
                return Email.mailAddress((String)((User)((Object)member)).getName(), (String)((User)((Object)member)).getEmail());
            }
        });
        Message parent = message.getParent();
        if (parent != null && !this.isSubscribed(parent.getAuthor())) {
            members = members + Email.mailAddress((String)parent.getAuthor().getEmail(), (String)parent.getAuthor().getEmail());
        }
        String replyTo = toString = this.getEmailAddress(message);
        String body = message.getBody();
        body = body + "\n\n-----------------------------------------------------------------------\n";
        body = body + "From the " + this.getDisplayname() + " board:\n";
        body = body + "To unsubscribe, see the list of members or other messages, go to:\n";
        body = body + this.getBoardURL() + "\n\n";
        body = body + "This message";
        if (message.hasAttachments()) {
            body = body + " (has " + message.getAttachmentCount() + " attachments)";
        }
        body = body + ":\n";
        body = body + this.getMessageURL(message) + "\n";
        try {
            String smtpServer = this.getDatabase().getSettingTable().get(SMTPSERVER);
            File[] empty = new File[]{};
            Email.sendWithAttachments((String)smtpServer, (String)Email.mailAddress((String)message.getAuthor().getName(), (String)message.getAuthor().getEmail()), (String)members, (String)replyTo, (String)("[" + this.getName() + "] " + message.getSubject()), (String)body, (File[])empty);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Enumeration threadsRoots() {
        if (this.roots == null) {
            this.roots = this.getBoardsDatabaseTables().getMessageTable().cachedBoardRoots(this);
        }
        return this.roots.objects();
    }

    private void computeThreads() {
        this.threadTrees = new Vector();
        this.threadsByRoot = new Hashtable();
        Enumeration rootsEnum = this.threadsRoots();
        while (rootsEnum.hasMoreElements()) {
            Message root = (Message)((Object)rootsEnum.nextElement());
            this.addThread(root);
        }
    }

    void addThread(Message root) {
        this.addThread(root, false);
    }

    void addThread(Message root, boolean atStart) {
        if (atStart) {
            this.addThread(root, 0);
        } else {
            this.addThread(root, -1);
        }
    }

    void addThread(Message root, int index) {
        if (this.threadTrees == null) {
            return;
        }
        ChildrenDrivenMutableTree tree = new ChildrenDrivenMutableTree((Treeable)root);
        if (index != -1) {
            this.threadTrees.insertElementAt(tree, index);
        } else {
            this.threadTrees.addElement(tree);
        }
        this.threadsByRoot.put(root, tree);
        this.computeMessages();
    }

    void addToParent(Message mess, Message parent) {
        if (this.threadTrees == null) {
            return;
        }
        DefaultMutableTreeNode messNode = new DefaultMutableTreeNode((Object)mess);
        DefaultMutableTreeNode parentNode = this.getTreeNode(parent);
        if (parentNode == null) {
            throw new MessageNotInBoardException("Message " + (Object)((Object)parent) + " is not in this board (" + (Object)((Object)this) + ")");
        }
        parentNode.add(messNode);
        this.computeMessages();
    }

    void removeAndSquash(Message message) {
        if (this.threadTrees == null) {
            return;
        }
        DefaultMutableTreeNode parent = null;
        int treeIndex = 0;
        if (message.getParent() != null) {
            parent = this.getTreeNode(message.getParent());
        } else {
            treeIndex = this.threadTrees.indexOf(this.threadWithRoot(message));
        }
        DefaultMutableTreeNode node = this.getTreeNode(message);
        if (node == null) {
            return;
        }
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            if (parent == null) {
                child.setParent(null);
                this.addThread((Message)((Object)child.getUserObject()), treeIndex);
                continue;
            }
            parent.add(child);
        }
        node.removeFromParent();
        this.threadTrees.remove(this.threadWithRoot(message));
        this.threadsByRoot.remove((Object)message);
        this.computeMessages();
    }

    private DefaultMutableTreeNode getTreeNode(Message m) {
        DefaultMutableTreeNode res = null;
        for (int i = 0; i < this.threadTrees.size(); ++i) {
            ChildrenDrivenMutableTree thread = (ChildrenDrivenMutableTree)this.threadTrees.elementAt(i);
            res = thread.getTreeNodeFor((Treeable)m);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public ChildrenDrivenMutableTree threadWithRoot(Message m) {
        if (this.threadsByRoot == null) {
            this.computeThreads();
        }
        return (ChildrenDrivenMutableTree)this.threadsByRoot.get((Object)m);
    }

    private void computeMessages() {
        if (this.threadsByRoot == null) {
            this.computeThreads();
        }
        Vector realMessages = new Vector();
        for (int i = 0; i < this.threadTrees.size(); ++i) {
            ChildrenDrivenMutableTree thread = (ChildrenDrivenMutableTree)this.threadTrees.elementAt(i);
            Enumeration e = thread.preorderEnumeration();
            while (e.hasMoreElements()) {
                realMessages.addElement(e.nextElement());
            }
        }
        this.messages = new SoftReference(realMessages);
    }

    public Enumeration getMessages() {
        Vector realMessages;
        if (this.messages == null || this.messages.get() == null) {
            this.computeMessages();
        }
        return (realMessages = (Vector)this.messages.get()) == null ? null : realMessages.elements();
    }

    public int getMessageCount() {
        if (this.messageCount == null) {
            this.messageCount = this.getBoardsDatabaseTables().getMessageTable().cachedMessageCount(this);
        }
        return this.messageCount.count();
    }

    public int getFirstMessageId() throws SQLException {
        int result = -1;
        MessageTable<Message> messageTable = this.getBoardsDatabaseTables().getMessageTable();
        ResultSet rs = this.getDatabase().sqlQuery("SELECT MIN(" + messageTable.troidColumn().quotedName() + ") FROM " + messageTable.quotedName() + " WHERE  " + messageTable.getBoardColumn().quotedName() + " = " + this.getTroid());
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    public int getLastMessageId() throws SQLException {
        int result = -1;
        MessageTable<Message> messageTable = this.getBoardsDatabaseTables().getMessageTable();
        ResultSet rs = this.getDatabase().sqlQuery("SELECT MAX(" + messageTable.troidColumn().quotedName() + ") FROM " + messageTable.quotedName() + " WHERE  " + messageTable.getBoardColumn().quotedName() + " = " + this.getTroid());
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    public Message getLastMessage() {
        try {
            return (Message)this.getDatabase().getTable("message").getObject(this.getLastMessageId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean hasPendingMessages() {
        return this.getPendingMessageCount() > 0;
    }

    public int getPendingMessageCount() {
        if (this.pendingMessageCount == null) {
            this.pendingMessageCount = this.getBoardsDatabaseTables().getMessageTable().cachedPendingMessageCount(this);
        }
        return this.pendingMessageCount.count();
    }

    public Enumeration getPendingMessages() {
        if (this.pendingMessages == null) {
            this.pendingMessages = this.getBoardsDatabaseTables().getMessageTable().cachedPendingMessages(this);
        }
        return this.pendingMessages.objects();
    }

    public boolean hasPendingSubscriptions() {
        return this.getPendingSubscriptionCount() > 0;
    }

    public int getPendingSubscriptionCount() {
        if (this.pendingSubscriptionCount == null) {
            this.pendingSubscriptionCount = this.getBoardsDatabaseTables().getSubscriptionTable().cachedPendingSubscriptionCount(this);
        }
        return this.pendingSubscriptionCount.count();
    }

    public Enumeration getPendingSubscriptions() {
        if (this.pendingSubscriptions == null) {
            this.pendingSubscriptions = this.getBoardsDatabaseTables().getSubscriptionTable().cachedPendingSubscriptions(this);
        }
        return this.pendingSubscriptions.objects();
    }

    public String getEmailAddress() throws SettingNotFoundException {
        return this.getName() + "@" + this.getBoardTable().getBoardsEmailDomain();
    }

    public String getEmailAddress(Message m) throws SettingNotFoundException {
        return m.troid() + "." + this.getName() + "@" + this.getBoardTable().getBoardsEmailDomain();
    }

    public String getBoardURL() throws SettingNotFoundException {
        return this.getBoardTable().getBoardsSystemURL() + "/" + this.getBoardTable().getLogicalDatabase() + "/board/" + this.troid() + "/Board";
    }

    public String getStylesheetURL() throws SettingNotFoundException {
        return this.getBoardTable().getBoardsStylesheetURL();
    }

    public String getMessageURL(Message m) throws SettingNotFoundException {
        return this.getBoardTable().getBoardsSystemURL() + "/" + this.getBoardTable().getLogicalDatabase() + "/message/" + m.troid() + "/Message";
    }

    public String templatePath(String templateName) {
        return this.getBoardTable().getBoardsEmailTemplates() + File.separator + templateName + ".wm";
    }

    @Override
    public void setName(String name) throws AccessPoemException, ValidationPoemException {
        String lName = name.toLowerCase();
        super.setName(lName);
    }
}

