/*
 * Decompiled with CFR 0.152.
 */
package org.paneris.melati.boards.model;

import java.io.File;
import org.melati.poem.AccessPoemException;
import org.melati.poem.AccessToken;
import org.melati.poem.Database;
import org.melati.poem.DefinitionSource;
import org.melati.poem.InitialisationPoemException;
import org.melati.poem.Persistent;
import org.melati.poem.PoemException;
import org.melati.poem.PoemTask;
import org.melati.poem.PoemThread;
import org.melati.poem.ValidationPoemException;
import org.paneris.melati.boards.model.Board;
import org.paneris.melati.boards.model.Setting;
import org.paneris.melati.boards.model.SettingNotFoundException;
import org.paneris.melati.boards.model.User;
import org.paneris.melati.boards.model.generated.BoardTableBase;

public class BoardTable<T extends Board>
extends BoardTableBase<Board> {
    public BoardTable(Database database, String name, DefinitionSource definitionSource) throws PoemException {
        super(database, name, definitionSource);
    }

    @Override
    public void init() throws PoemException {
        super.init();
    }

    public String getBoardsEmailDomain() throws SettingNotFoundException {
        return this.getSettingValue("BoardsEmailDomain");
    }

    public String getBoardsSystemURL() throws SettingNotFoundException {
        return this.getSettingValue("BoardsSystemURL");
    }

    public String getBoardsEmailTemplates() throws SettingNotFoundException {
        return this.getSettingValue("BoardsEmailTemplates");
    }

    public String getBoardsAttachmentsPath() throws SettingNotFoundException {
        return this.getSettingValue("BoardsAttachmentsPath");
    }

    public String getBoardsAttachmentsURL() throws SettingNotFoundException {
        return this.getSettingValue("BoardsAttachmentsURL");
    }

    public String getBoardsStylesheetURL() throws SettingNotFoundException {
        return this.getSettingValue("BoardsStylesheetURL");
    }

    public String getLogicalDatabase() throws SettingNotFoundException {
        return this.getSettingValue("LogicalDatabase");
    }

    public String getSettingValue(String settingName) throws SettingNotFoundException {
        Setting setting = (Setting)this.getDatabase().getSettingTable().getNameColumn().firstWhereEq((Object)settingName);
        if (setting.getValue_unsafe().equals("")) {
            throw new SettingNotFoundException(settingName);
        }
        return setting.getValue_unsafe();
    }

    public void create(Persistent persistent) {
        this.create(persistent, null);
    }

    public void create(Persistent persistent, User manager) throws AccessPoemException, ValidationPoemException, InitialisationPoemException {
        final Board b = (Board)persistent;
        b.setAttachmentspath(this.getBoardsAttachmentsPath() + File.separatorChar + b.getName_unsafe());
        b.setAttachmentsurl(this.getBoardsAttachmentsURL() + File.separatorChar + b.getName_unsafe());
        super.create(persistent);
        if (manager == null) {
            manager = (User)PoemThread.accessToken();
        }
        final User theManager = manager;
        PoemThread.withAccessToken((AccessToken)AccessToken.root, (PoemTask)new PoemTask(){

            public void run() {
                b.subscribe(theManager, BoardTable.this.getBoardsDatabaseTables().getMembershipStatusTable().getNormal(), Boolean.TRUE, Boolean.TRUE);
            }

            public String toString() {
                return "Subscribing the user " + (Object)((Object)theManager) + " to this board";
            }
        });
    }
}

