/*
 * Decompiled with CFR 0.152.
 */
package org.paneris.melati.boards.model;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.TimeZone;
import java.util.Vector;
import org.melati.poem.AccessPoemException;
import org.melati.poem.AccessToken;
import org.melati.poem.CachedCount;
import org.melati.poem.Capability;
import org.melati.poem.CreationAccessPoemException;
import org.melati.poem.Persistent;
import org.melati.poem.Treeable;
import org.melati.poem.ValidationPoemException;
import org.melati.poem.util.EnumUtils;
import org.melati.poem.util.StringUtils;
import org.melati.util.ChildrenDrivenMutableTree;
import org.paneris.melati.boards.model.Board;
import org.paneris.melati.boards.model.DistributeThread;
import org.paneris.melati.boards.model.MessageAndParentOnDifferentBoardsException;
import org.paneris.melati.boards.model.User;
import org.paneris.melati.boards.model.generated.MessageBase;

public class Message
extends MessageBase
implements Treeable {
    private static DateFormat localeFormatter = new SimpleDateFormat("dd MMM yyyy HH:mm:ss");
    String[] lines = null;
    CachedCount attachments = null;

    public String getLondonDate() {
        return localeFormatter.format(this.getDate_unsafe());
    }

    public void distribute() {
        new DistributeThread(this).start();
    }

    public void approve() {
        this.setApproved(Boolean.TRUE);
        if (this.getParent() == null) {
            this.getBoard().addThread(this, true);
        } else {
            this.getBoard().addToParent(this, this.getParent());
        }
    }

    public String[] getLines() {
        if (this.lines == null) {
            this.lines = StringUtils.split((String)this.getBody_unsafe(), (char)'\n');
        }
        return this.lines;
    }

    public String IndentBody(String indent) {
        StringBuffer ret = new StringBuffer(this.getBody_unsafe().length() + this.getLines().length * indent.length());
        for (int i = 0; i < this.getLines().length; ++i) {
            ret.append(indent);
            ret.append(this.lines[i]);
        }
        return ret.toString();
    }

    public String IndentBody() {
        return this.IndentBody(">");
    }

    public Enumeration getAttachments() {
        return this.getBoardsDatabaseTables().getAttachmentTable().getColumn("message").referencesTo((Persistent)this);
    }

    public int getAttachmentCount() {
        if (this.attachments == null) {
            this.attachments = this.getBoardsDatabaseTables().getAttachmentTable().cachedCount(this.getBoardsDatabaseTables().getAttachmentTable().getMessageColumn().eqClause((Object)this.troid()));
        }
        return this.attachments.count();
    }

    public boolean hasAttachments() {
        return this.getAttachmentCount() > 0;
    }

    public Treeable[] getChildren() {
        Enumeration kidsEnum = this.getTable().selection(this.getMessageTable().getParentColumn().eqClause((Object)this.troid()) + " AND " + this.getMessageTable().getApprovedColumn().eqClause((Object)Boolean.TRUE) + " AND " + this.getMessageTable().getDeletedColumn().eqClause((Object)Boolean.FALSE));
        Vector kidsVector = EnumUtils.vectorOf((Enumeration)kidsEnum);
        Object[] kidsArray = new Treeable[kidsVector.size()];
        kidsVector.copyInto(kidsArray);
        return kidsArray;
    }

    public Message getThreadRoot() {
        Message current = this;
        while (current.getParent() != null) {
            current = current.getParent();
        }
        return current;
    }

    public ChildrenDrivenMutableTree getThread() {
        return this.getBoard().threadWithRoot(this.getThreadRoot());
    }

    @Override
    public void setDeleted(Boolean cooked) throws AccessPoemException, ValidationPoemException {
        if (this.getDeleted() == Boolean.FALSE && cooked == Boolean.TRUE) {
            this.getBoard().removeAndSquash(this);
            Enumeration kidsEnum = this.getTable().selection(this.getMessageTable().getParentColumn().eqClause((Object)this.troid()));
            while (kidsEnum.hasMoreElements()) {
                Message child = (Message)((Object)kidsEnum.nextElement());
                child.setParent(this.getParent());
            }
        }
        super.setDeleted(cooked);
    }

    public void assertCanRead(AccessToken token) throws AccessPoemException {
        if (token == AccessToken.root) {
            return;
        }
        try {
            Board b = this.getBoardsDatabaseTables().getBoardTable().getBoardObject(this.getBoard_unsafe());
            if (!b.canViewMessages((User)token)) {
                throw new AccessPoemException(token, new Capability("Member"));
            }
        }
        catch (ClassCastException e) {
            throw new AccessPoemException(token, new Capability("Member"));
        }
    }

    public void assertCanWrite(AccessToken token) throws AccessPoemException {
        if (token == AccessToken.root) {
            return;
        }
        try {
            Board b = this.getBoardsDatabaseTables().getBoardTable().getBoardObject(this.getBoard_unsafe());
            if (!b.canManage((User)token) && !this.getAuthor_unsafe().equals(((User)token).troid())) {
                throw new AccessPoemException(token, new Capability("Logged In"));
            }
        }
        catch (ClassCastException e) {
            throw new AccessPoemException(token, new Capability("Logged In"));
        }
    }

    public void assertCanCreate(AccessToken token) throws AccessPoemException {
        if (token == AccessToken.root) {
            return;
        }
        try {
            Board b = this.getBoardsDatabaseTables().getBoardTable().getBoardObject(this.getBoard_unsafe());
            if (!b.canPost((User)token)) {
                throw new CreationAccessPoemException(this.getTable(), token, new Capability("Logged in"));
            }
        }
        catch (ClassCastException e) {
            throw new CreationAccessPoemException(this.getTable(), token, new Capability("Member"));
        }
    }

    @Override
    public void setParentTroid(Integer raw) throws AccessPoemException {
        this.getMessageTable().getParentColumn().getType().assertValidRaw((Object)raw);
        this.writeLock();
        if (raw != null && !this.getBoard_unsafe().equals(this.getMessageTable().getMessageObject(raw).getBoard_unsafe())) {
            throw new MessageAndParentOnDifferentBoardsException("Attempted to set the parent of this message (" + (Object)((Object)this) + ") to a message on a different board (message id:" + raw + ")");
        }
        this.setParent_unsafe(raw);
    }

    public String getName() throws AccessPoemException {
        return this.getSubject();
    }

    static {
        localeFormatter.setTimeZone(TimeZone.getTimeZone("Europe/London"));
    }
}

