/*
 * Decompiled with CFR 0.152.
 */
package org.paneris.melati.boards.model;

import java.util.ArrayList;
import java.util.Enumeration;
import org.melati.poem.AccessPoemException;
import org.melati.poem.AccessToken;
import org.melati.poem.CachedCount;
import org.melati.poem.CachedSelection;
import org.melati.poem.Database;
import org.melati.poem.DefinitionSource;
import org.melati.poem.InitialisationPoemException;
import org.melati.poem.Initialiser;
import org.melati.poem.Persistent;
import org.melati.poem.PoemException;
import org.melati.poem.PoemThread;
import org.melati.poem.ValidationPoemException;
import org.paneris.melati.boards.model.Board;
import org.paneris.melati.boards.model.MembershipStatus;
import org.paneris.melati.boards.model.Subscription;
import org.paneris.melati.boards.model.User;
import org.paneris.melati.boards.model.generated.SubscriptionTableBase;

public class SubscriptionTable<T extends Subscription>
extends SubscriptionTableBase<Subscription> {
    public SubscriptionTable(Database database, String name, DefinitionSource definitionSource) throws PoemException {
        super(database, name, definitionSource);
    }

    public Subscription subscribe(final User user, final Board board, final MembershipStatus status, final Boolean ismanager, final Boolean approved) {
        return (Subscription)this.create(new Initialiser(){

            public void init(Persistent object) throws AccessPoemException, ValidationPoemException {
                object.setRaw("user", (Object)user.troid());
                object.setRaw("board", (Object)board.troid());
                object.setRaw("status", (Object)status.troid());
                object.setRaw("ismanager", (Object)ismanager);
                object.setRaw("approved", (Object)approved);
            }
        });
    }

    public void unsubscribe(User user, Board board) {
        ArrayList toDelete = new ArrayList();
        Enumeration e = this.selection(this.getUserColumn().eqClause((Object)user.troid()) + " AND " + this.getBoardColumn().eqClause((Object)board.troid()));
        while (e.hasMoreElements()) {
            toDelete.add(e.nextElement());
        }
        for (Subscription s : toDelete) {
            s.deleteAndCommit();
        }
    }

    public Subscription getUserSubscription(User user, Board board) {
        Enumeration e = this.selection(this.getUserColumn().eqClause((Object)user.troid()) + " AND " + this.getBoardColumn().eqClause((Object)board.troid()));
        if (e.hasMoreElements()) {
            return (Subscription)((Object)e.nextElement());
        }
        return null;
    }

    public void create(Persistent persistent) throws AccessPoemException, ValidationPoemException, InitialisationPoemException {
        Board b = this.getBoardsDatabaseTables().getBoardTable().getBoardObject(((Subscription)persistent).getBoard_unsafe());
        AccessToken token = PoemThread.accessToken();
        if (token == AccessToken.root) {
            persistent.setRaw("approved", (Object)Boolean.TRUE);
            persistent.setRaw("ismanager", (Object)Boolean.TRUE);
        } else if (b.canManage((User)token)) {
            persistent.setRaw("approved", (Object)Boolean.TRUE);
        } else {
            persistent.setRaw("approved", (Object)new Boolean(b.getModeratedsubscription_unsafe() == false));
            persistent.setRaw("ismanager", (Object)Boolean.FALSE);
        }
        super.create(persistent);
    }

    public String managerSQL(Board board) {
        return this.getBoardColumn().eqClause((Object)board.troid()) + " AND " + this.getApprovedColumn().eqClause((Object)Boolean.TRUE) + " AND " + this.getIsmanagerColumn().eqClause((Object)Boolean.TRUE);
    }

    public String memberSQL(Board board) {
        return this.getBoardColumn().eqClause((Object)board.troid()) + " AND " + this.getApprovedColumn().eqClause((Object)Boolean.TRUE);
    }

    public String pendingSubscriptionSQL(Board board) {
        return this.getBoardColumn().eqClause((Object)board.troid()) + " AND " + this.getApprovedColumn().eqClause((Object)Boolean.FALSE);
    }

    public boolean isManager(User user, Board board) {
        return this.exists(this.getUserColumn().eqClause((Object)user.troid()) + " AND " + this.managerSQL(board));
    }

    public boolean isMember(User user, Board board) {
        return this.exists(this.getUserColumn().eqClause((Object)user.troid()) + " AND " + this.memberSQL(board));
    }

    public CachedSelection<Subscription> cachedManagers(Board board) {
        return this.cachedSelection(this.managerSQL(board), null);
    }

    public CachedSelection<Subscription> cachedMembers(Board board) {
        return this.cachedSelection(this.memberSQL(board), null);
    }

    public CachedSelection<Subscription> cachedPendingSubscriptions(Board board) {
        return this.cachedSelection(this.pendingSubscriptionSQL(board), null);
    }

    public CachedCount cachedManagerCount(Board board) {
        return this.cachedCount(this.managerSQL(board));
    }

    public CachedCount cachedMemberCount(Board board) {
        return this.cachedCount(this.memberSQL(board));
    }

    public CachedCount cachedPendingSubscriptionCount(Board board) {
        return this.cachedCount(this.pendingSubscriptionSQL(board));
    }

    public Enumeration getNormalDistributionList(Board board) {
        return this.selection(this.memberSQL(board) + " AND " + this.getStatusColumn().eqClause((Object)this.getBoardsDatabaseTables().getMembershipStatusTable().getNormal().getTroid()));
    }

    public Enumeration getDigestDistributionList(Board board) {
        return this.selection(this.memberSQL(board) + " AND " + this.getStatusColumn().eqClause((Object)this.getBoardsDatabaseTables().getMembershipStatusTable().getDigest().getTroid()));
    }
}

