/*
 * Decompiled with CFR 0.152.
 */
package org.paneris.melati.boards.model.generated;

import org.melati.poem.AccessPoemException;
import org.melati.poem.Column;
import org.melati.poem.Database;
import org.melati.poem.DefinitionSource;
import org.melati.poem.DisplayLevel;
import org.melati.poem.Field;
import org.melati.poem.IntegerPoemType;
import org.melati.poem.JdbcPersistent;
import org.melati.poem.Persistent;
import org.melati.poem.PoemException;
import org.melati.poem.ReferencePoemType;
import org.melati.poem.SQLPoemType;
import org.melati.poem.Searchability;
import org.melati.poem.StandardIntegrityFix;
import org.melati.poem.StringPoemType;
import org.melati.poem.Table;
import org.melati.poem.TroidPoemType;
import org.melati.poem.ValidationPoemException;
import org.paneris.melati.boards.model.Attachment;
import org.paneris.melati.boards.model.AttachmentType;
import org.paneris.melati.boards.model.BoardsDatabaseTables;
import org.paneris.melati.boards.model.BoardsTable;
import org.paneris.melati.boards.model.Message;

public class AttachmentTableBase<T extends Attachment>
extends BoardsTable<T> {
    private Column<Integer> col_id = null;
    private Column<Integer> col_message = null;
    private Column<String> col_filename = null;
    private Column<String> col_path = null;
    private Column<String> col_url = null;
    private Column<Integer> col_size = null;
    private Column<Integer> col_type = null;

    public AttachmentTableBase(Database database, String name, DefinitionSource definitionSource) throws PoemException {
        super(database, name, definitionSource);
    }

    public BoardsDatabaseTables getBoardsDatabaseTables() {
        return (BoardsDatabaseTables)this.getDatabase();
    }

    public void init() throws PoemException {
        super.init();
        this.col_id = new Column<Integer>((Table)this, "id", (SQLPoemType)new TroidPoemType(), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Attachment)g).getId();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Attachment)g).setId((Integer)cooked);
            }

            public Field<Integer> asField(Persistent g) {
                return ((Attachment)g).getIdField();
            }

            public boolean defaultUserEditable() {
                return false;
            }

            public boolean defaultUserCreateable() {
                return false;
            }

            public int defaultDisplayOrder() {
                return 0;
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Attachment)g).getId_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Attachment)g).setId_unsafe((Integer)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Attachment)g).getId();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Attachment)g).setId((Integer)raw);
            }
        };
        this.defineColumn((Column)this.col_id);
        this.col_message = new Column<Integer>((Table)this, "message", (SQLPoemType)new ReferencePoemType(this.getBoardsDatabaseTables().getMessageTable(), false), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Attachment)g).getMessage();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Attachment)g).setMessage((Message)((Object)cooked));
            }

            public Field<Integer> asField(Persistent g) {
                return ((Attachment)g).getMessageField();
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.summary;
            }

            public Searchability defaultSearchability() {
                return Searchability.yes;
            }

            public Integer defaultDisplayOrderPriority() {
                return new Integer(0);
            }

            public int defaultDisplayOrder() {
                return 1;
            }

            public String defaultDescription() {
                return "The message this attachment belongs to";
            }

            public boolean defaultIndexed() {
                return true;
            }

            public String defaultRenderinfo() {
                return "SelectionWindow";
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Attachment)g).getMessage_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Attachment)g).setMessage_unsafe((Integer)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Attachment)g).getMessageTroid();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Attachment)g).setMessageTroid((Integer)raw);
            }

            public StandardIntegrityFix defaultIntegrityFix() {
                return StandardIntegrityFix.delete;
            }
        };
        this.defineColumn((Column)this.col_message);
        this.col_filename = new Column<String>((Table)this, "filename", (SQLPoemType)new StringPoemType(false, -1), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Attachment)g).getFilename();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Attachment)g).setFilename((String)cooked);
            }

            public Field<String> asField(Persistent g) {
                return ((Attachment)g).getFilenameField();
            }

            public boolean defaultUserEditable() {
                return false;
            }

            public boolean defaultUserCreateable() {
                return false;
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.primary;
            }

            public Searchability defaultSearchability() {
                return Searchability.yes;
            }

            public Integer defaultDisplayOrderPriority() {
                return new Integer(1);
            }

            public int defaultDisplayOrder() {
                return 2;
            }

            public String defaultDescription() {
                return "The filename of this attachment";
            }

            public int defaultWidth() {
                return 40;
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Attachment)g).getFilename_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Attachment)g).setFilename_unsafe((String)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Attachment)g).getFilename();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Attachment)g).setFilename((String)raw);
            }
        };
        this.defineColumn((Column)this.col_filename);
        this.col_path = new Column<String>((Table)this, "path", (SQLPoemType)new StringPoemType(false, -1), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Attachment)g).getPath();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Attachment)g).setPath((String)cooked);
            }

            public Field<String> asField(Persistent g) {
                return ((Attachment)g).getPathField();
            }

            public boolean defaultUserCreateable() {
                return false;
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.record;
            }

            public Searchability defaultSearchability() {
                return Searchability.yes;
            }

            public int defaultDisplayOrder() {
                return 3;
            }

            public String defaultDescription() {
                return "The path to this attachment";
            }

            public int defaultWidth() {
                return 40;
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Attachment)g).getPath_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Attachment)g).setPath_unsafe((String)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Attachment)g).getPath();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Attachment)g).setPath((String)raw);
            }
        };
        this.defineColumn((Column)this.col_path);
        this.col_url = new Column<String>((Table)this, "url", (SQLPoemType)new StringPoemType(false, -1), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Attachment)g).getUrl();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Attachment)g).setUrl((String)cooked);
            }

            public Field<String> asField(Persistent g) {
                return ((Attachment)g).getUrlField();
            }

            public boolean defaultUserCreateable() {
                return false;
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.record;
            }

            public Searchability defaultSearchability() {
                return Searchability.yes;
            }

            public int defaultDisplayOrder() {
                return 4;
            }

            public String defaultDescription() {
                return "A url to this attachment";
            }

            public int defaultWidth() {
                return 40;
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Attachment)g).getUrl_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Attachment)g).setUrl_unsafe((String)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Attachment)g).getUrl();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Attachment)g).setUrl((String)raw);
            }
        };
        this.defineColumn((Column)this.col_url);
        this.col_size = new Column<Integer>((Table)this, "size", (SQLPoemType)new IntegerPoemType(false), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Attachment)g).getSize();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Attachment)g).setSize((Integer)cooked);
            }

            public Field<Integer> asField(Persistent g) {
                return ((Attachment)g).getSizeField();
            }

            public boolean defaultUserEditable() {
                return false;
            }

            public boolean defaultUserCreateable() {
                return false;
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.summary;
            }

            public Searchability defaultSearchability() {
                return Searchability.no;
            }

            public int defaultDisplayOrder() {
                return 5;
            }

            public String defaultDescription() {
                return "The size of the file in bytes";
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Attachment)g).getSize_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Attachment)g).setSize_unsafe((Integer)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Attachment)g).getSize();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Attachment)g).setSize((Integer)raw);
            }
        };
        this.defineColumn((Column)this.col_size);
        this.col_type = new Column<Integer>((Table)this, "type", (SQLPoemType)new ReferencePoemType(this.getBoardsDatabaseTables().getAttachmentTypeTable(), false), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Attachment)g).getType();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Attachment)g).setType((AttachmentType)((Object)cooked));
            }

            public Field<Integer> asField(Persistent g) {
                return ((Attachment)g).getTypeField();
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.summary;
            }

            public Searchability defaultSearchability() {
                return Searchability.yes;
            }

            public int defaultDisplayOrder() {
                return 6;
            }

            public String defaultDescription() {
                return "The type of this attachment";
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Attachment)g).getType_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Attachment)g).setType_unsafe((Integer)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Attachment)g).getTypeTroid();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Attachment)g).setTypeTroid((Integer)raw);
            }
        };
        this.defineColumn((Column)this.col_type);
    }

    public final Column<Integer> getIdColumn() {
        return this.col_id;
    }

    public final Column<Integer> getMessageColumn() {
        return this.col_message;
    }

    public final Column<String> getFilenameColumn() {
        return this.col_filename;
    }

    public final Column<String> getPathColumn() {
        return this.col_path;
    }

    public final Column<String> getUrlColumn() {
        return this.col_url;
    }

    public final Column<Integer> getSizeColumn() {
        return this.col_size;
    }

    public final Column<Integer> getTypeColumn() {
        return this.col_type;
    }

    public Attachment getAttachmentObject(Integer troid) {
        return (Attachment)this.getObject(troid);
    }

    public Attachment getAttachmentObject(int troid) {
        return (Attachment)this.getObject(troid);
    }

    protected JdbcPersistent _newPersistent() {
        return new Attachment();
    }

    public String defaultDescription() {
        return "A file sent as an attachment to a message";
    }

    public String defaultCategory() {
        return "Boards";
    }

    public int defaultDisplayOrder() {
        return 1070;
    }
}

